/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.combinationlookup;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.combinationlookup.CombinationLookupData;
import org.pentaho.di.trans.steps.combinationlookup.CombinationLookupMeta;

public class CombinationLookupMetaTest {
    @Test
    public void testProvidesModelerMeta() throws Exception {
        final RowMeta rowMeta = (RowMeta)Mockito.mock(RowMeta.class);
        CombinationLookupMeta combinationLookupMeta = new CombinationLookupMeta(){

            Database createDatabaseObject() {
                return (Database)Mockito.mock(Database.class);
            }

            protected RowMetaInterface getDatabaseTableFields(Database db, String schemaName, String tableName) throws KettleDatabaseException {
                Assert.assertEquals((Object)"aSchema", (Object)schemaName);
                Assert.assertEquals((Object)"aDimTable", (Object)tableName);
                return rowMeta;
            }
        };
        combinationLookupMeta.setKeyLookup(new String[]{"f1", "f2", "f3"});
        combinationLookupMeta.setKeyField(new String[]{"s4", "s5", "s6"});
        combinationLookupMeta.setSchemaName("aSchema");
        combinationLookupMeta.setTablename("aDimTable");
        CombinationLookupData dimensionLookupData = new CombinationLookupData();
        Assert.assertEquals((Object)rowMeta, (Object)combinationLookupMeta.getRowMeta((StepDataInterface)dimensionLookupData));
        Assert.assertEquals((long)3L, (long)combinationLookupMeta.getDatabaseFields().size());
        Assert.assertEquals((Object)"f1", combinationLookupMeta.getDatabaseFields().get(0));
        Assert.assertEquals((Object)"f2", combinationLookupMeta.getDatabaseFields().get(1));
        Assert.assertEquals((Object)"f3", combinationLookupMeta.getDatabaseFields().get(2));
        Assert.assertEquals((long)3L, (long)combinationLookupMeta.getStreamFields().size());
        Assert.assertEquals((Object)"s4", combinationLookupMeta.getStreamFields().get(0));
        Assert.assertEquals((Object)"s5", combinationLookupMeta.getStreamFields().get(1));
        Assert.assertEquals((Object)"s6", combinationLookupMeta.getStreamFields().get(2));
    }
}

