/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupData;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupMeta;

public class DatabaseLookupMetaTest {
    private DatabaseLookupMeta databaseLookupMeta = new DatabaseLookupMeta();

    @Test
    public void getFieldWithValueUsedTwice() throws KettleStepException {
        this.databaseLookupMeta.setReturnValueField(new String[]{"match", "match", "mismatch"});
        this.databaseLookupMeta.setReturnValueNewName(new String[]{"v1", "v2", "v3"});
        ValueMetaString v1 = new ValueMetaString("match");
        ValueMetaString v2 = new ValueMetaString("match1");
        RowMetaInterface[] info = new RowMetaInterface[]{new RowMeta()};
        info[0].setValueMetaList(Arrays.asList(v1, v2));
        ValueMetaString r1 = new ValueMetaString("value");
        RowMeta row = new RowMeta();
        row.setValueMetaList(new ArrayList<ValueMetaInterface>(Arrays.asList(r1)));
        this.databaseLookupMeta.getFields((RowMetaInterface)row, "", info, null, null, null, null);
        List<ValueMetaInterface> expectedRow = Arrays.asList(new ValueMetaString("value"), new ValueMetaString("v1"), new ValueMetaString("v2"));
        Assert.assertEquals((long)3L, (long)row.getValueMetaList().size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)expectedRow.get(i).getName(), (Object)((ValueMetaInterface)row.getValueMetaList().get(i)).getName());
        }
    }

    @Test
    public void testProvidesModelerMeta() throws Exception {
        DatabaseLookupMeta databaseLookupMeta = new DatabaseLookupMeta();
        databaseLookupMeta.setReturnValueField(new String[]{"f1", "f2", "f3"});
        databaseLookupMeta.setReturnValueNewName(new String[]{"s4", "s5", "s6"});
        DatabaseLookupData databaseLookupData = new DatabaseLookupData();
        databaseLookupData.returnMeta = (RowMetaInterface)Mockito.mock(RowMeta.class);
        Assert.assertEquals((Object)databaseLookupData.returnMeta, (Object)databaseLookupMeta.getRowMeta((StepDataInterface)databaseLookupData));
        Assert.assertEquals((long)3L, (long)databaseLookupMeta.getDatabaseFields().size());
        Assert.assertEquals((Object)"f1", databaseLookupMeta.getDatabaseFields().get(0));
        Assert.assertEquals((Object)"f2", databaseLookupMeta.getDatabaseFields().get(1));
        Assert.assertEquals((Object)"f3", databaseLookupMeta.getDatabaseFields().get(2));
        Assert.assertEquals((long)3L, (long)databaseLookupMeta.getStreamFields().size());
        Assert.assertEquals((Object)"s4", databaseLookupMeta.getStreamFields().get(0));
        Assert.assertEquals((Object)"s5", databaseLookupMeta.getStreamFields().get(1));
        Assert.assertEquals((Object)"s6", databaseLookupMeta.getStreamFields().get(2));
    }
}

