/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.trans.steps.databaselookup.readallcache.Index;
import org.pentaho.di.trans.steps.databaselookup.readallcache.SearchingContext;

public abstract class IndexTestBase<T extends Index> {
    final Long[][] rows;
    private final Class<T> clazz;
    T index;
    SearchingContext context;

    private static Long[][] toMatrix(long ... values) {
        Long[][] result = new Long[values.length][];
        for (int i = 0; i < values.length; ++i) {
            result[i] = new Long[]{values[i]};
        }
        return result;
    }

    static List<Object[]> createSampleData() {
        return Arrays.asList({IndexTestBase.toMatrix(0L, 1L, 2L, 2L, 3L)}, {IndexTestBase.toMatrix(3L, 2L, 2L, 1L, 0L)}, {IndexTestBase.toMatrix(1L, 3L, 2L, 0L, 2L)});
    }

    public IndexTestBase(Class<T> clazz, Long[][] rows) {
        this.rows = rows;
        this.clazz = clazz;
    }

    @Before
    public void setUp() throws Exception {
        this.index = this.createIndexInstance(0, (ValueMetaInterface)new ValueMetaInteger(), 5);
        this.index.performIndexingOf((Object[][])this.rows);
        this.context = new SearchingContext();
        this.context.init(5);
    }

    T createIndexInstance(int column, ValueMetaInterface meta, int rowsAmount) throws Exception {
        return (T)((Index)this.clazz.getDeclaredConstructor(Integer.TYPE, ValueMetaInterface.class, Integer.TYPE).newInstance(column, meta, rowsAmount));
    }

    @After
    public void tearDown() {
        this.index = null;
        this.context = null;
    }

    void testFindsNothing(long value) {
        Assert.assertFalse((boolean)this.context.isEmpty());
        this.index.applyRestrictionsTo(this.context, (ValueMetaInterface)new ValueMetaInteger(), (Object)value);
        Assert.assertTrue((String)("Expected not to find anything matching " + value), (boolean)this.context.isEmpty());
    }

    void testFindsCorrectly(long lookupValue, int expectedAmount) {
        Assert.assertFalse((boolean)this.context.isEmpty());
        this.index.applyRestrictionsTo(this.context, (ValueMetaInterface)new ValueMetaInteger(), (Object)lookupValue);
        Assert.assertFalse((String)"Expected to find something", (boolean)this.context.isEmpty());
        BitSet actual = this.context.getCandidates();
        int lastSetBit = 0;
        for (int cnt = expectedAmount; cnt > 0; --cnt) {
            if ((lastSetBit = actual.nextSetBit(lastSetBit)) < 0) {
                Assert.fail((String)("Expected to find " + expectedAmount + " values, but got: " + actual.toString()));
            }
            this.doAssertMatches(actual, lookupValue, this.rows[lastSetBit][0]);
            ++lastSetBit;
        }
    }

    abstract void doAssertMatches(BitSet var1, long var2, long var4);

    @Test
    public abstract void lookupFor_MinusOne();

    @Test
    public abstract void lookupFor_Zero();

    @Test
    public abstract void lookupFor_One();

    @Test
    public abstract void lookupFor_Two();

    @Test
    public abstract void lookupFor_Three();

    @Test
    public abstract void lookupFor_Hundred();
}

