/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.trans.steps.databaselookup.readallcache.IsNullIndex;
import org.pentaho.di.trans.steps.databaselookup.readallcache.SearchingContext;

@RunWith(value=Parameterized.class)
public class IsNullIndexTest {
    private final Long[][] rows;
    private final int amountOfNulls;
    private IsNullIndex matchingNulls;
    private IsNullIndex matchingNonNulls;
    private SearchingContext context;

    @Parameterized.Parameters
    public static List<Object[]> createSampleData() {
        Long[][] sample1 = new Long[][]{{null}, {null}, {1L}, {null}, {null}};
        Long[][] sample2 = new Long[][]{{1L}, {null}, {null}, {1L}, {1L}};
        Long[][] sample3 = new Long[][]{{null}, {1L}, {null}, {1L}, {null}};
        Long[][] sample4 = new Long[][]{{null}, {null}, {null}, {null}, {null}};
        Long[][] sample5 = new Long[][]{{1L}, {1L}, {1L}, {1L}, {1L}};
        return Arrays.asList({sample1}, {sample2}, {sample3}, {sample4}, {sample5});
    }

    public IsNullIndexTest(Long[][] rows) {
        this.rows = rows;
        int cnt = 0;
        Long[][] arr$ = rows;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long[] row;
            for (Long value : row = arr$[i$]) {
                if (value != null) continue;
                ++cnt;
            }
        }
        this.amountOfNulls = cnt;
    }

    @Before
    public void setUp() throws Exception {
        this.matchingNulls = new IsNullIndex(0, (ValueMetaInterface)new ValueMetaInteger(), 5, true);
        this.matchingNulls.performIndexingOf((Object[][])this.rows);
        this.matchingNonNulls = new IsNullIndex(0, (ValueMetaInterface)new ValueMetaInteger(), 5, false);
        this.matchingNonNulls.performIndexingOf((Object[][])this.rows);
        this.context = new SearchingContext();
        this.context.init(5);
    }

    @After
    public void tearDown() {
        this.matchingNulls = null;
        this.matchingNonNulls = null;
        this.context = null;
    }

    @Test
    public void lookupFor_Null() {
        this.testFindsCorrectly(this.matchingNulls, true);
    }

    @Test
    public void lookupFor_One() {
        this.testFindsCorrectly(this.matchingNonNulls, false);
    }

    private void testFindsCorrectly(IsNullIndex index, boolean isLookingForNull) {
        int expectedAmount = isLookingForNull ? this.amountOfNulls : 5 - this.amountOfNulls;
        Assert.assertFalse((boolean)this.context.isEmpty());
        index.applyRestrictionsTo(this.context, (ValueMetaInterface)new ValueMetaInteger(), null);
        if (expectedAmount == 0) {
            Assert.assertTrue((boolean)this.context.isEmpty());
            return;
        }
        Assert.assertFalse((String)String.format("Expected to find %d values", expectedAmount), (boolean)this.context.isEmpty());
        BitSet actual = this.context.getCandidates();
        int lastSetBit = 0;
        for (int cnt = expectedAmount; cnt > 0; --cnt) {
            if ((lastSetBit = actual.nextSetBit(lastSetBit)) < 0) {
                Assert.fail((String)("Expected to find " + expectedAmount + " values, but got: " + actual.toString()));
            }
            Long actualValue = this.rows[lastSetBit][0];
            if (isLookingForNull) {
                Assert.assertNull((Object)actualValue);
            } else {
                Assert.assertEquals((Object)1L, (Object)actualValue);
            }
            ++lastSetBit;
        }
    }
}

