/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.delete;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.delete.Delete;
import org.pentaho.di.trans.steps.delete.DeleteData;
import org.pentaho.di.trans.steps.delete.DeleteMeta;

public class DeleteMetaTest {
    private StepMeta stepMeta;
    private Delete del;
    private DeleteData dd;
    private DeleteMeta dmi;

    @BeforeClass
    public static void initEnvironment() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        TransMeta transMeta = new TransMeta();
        transMeta.setName("delete1");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("max.sz", "10");
        transMeta.injectVariables(vars);
        this.dmi = new DeleteMeta();
        this.dd = new DeleteData();
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String deletePid = plugReg.getPluginId(StepPluginType.class, (Object)this.dmi);
        this.stepMeta = new StepMeta(deletePid, "delete", (StepMetaInterface)this.dmi);
        Trans trans = new Trans(transMeta);
        transMeta.addStep(this.stepMeta);
        this.del = new Delete(this.stepMeta, (StepDataInterface)this.dd, 1, transMeta, trans);
        this.del.copyVariablesFrom((VariableSpace)transMeta);
    }

    @Test
    public void testCommitCountFixed() {
        this.dmi.setCommitSize("100");
        Assert.assertTrue((this.dmi.getCommitSize((VariableSpace)this.del) == 100 ? 1 : 0) != 0);
    }

    @Test
    public void testCommitCountVar() {
        this.dmi.setCommitSize("${max.sz}");
        Assert.assertTrue((this.dmi.getCommitSize((VariableSpace)this.del) == 10 ? 1 : 0) != 0);
    }

    @Test
    public void testCommitCountMissedVar() {
        this.dmi.setCommitSize("missed-var");
        try {
            this.dmi.getCommitSize((VariableSpace)this.del);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

