/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KWorkbook;
import org.pentaho.di.trans.steps.excelinput.SpreadSheetType;
import org.pentaho.di.trans.steps.excelinput.WorkbookFactory;
import org.pentaho.di.trans.steps.excelinput.ods.OdfSheet;

public class OdfSheetTest {
    private KWorkbook ods341;
    private KWorkbook ods24;

    @Before
    public void init() throws KettleException {
        this.ods341 = WorkbookFactory.getWorkbook((SpreadSheetType)SpreadSheetType.ODS, (String)this.getClass().getResource("files/sample-3.4.1.ods").getPath(), null);
        this.ods24 = WorkbookFactory.getWorkbook((SpreadSheetType)SpreadSheetType.ODS, (String)this.getClass().getResource("files/sample-2.4.ods").getPath(), null);
    }

    @Test
    public void testRowColumnsCount() {
        String sameRowWidthSheet = "SameRowWidth";
        String diffRowWidthSheet = "DifferentRowWidth";
        this.checkRowCount((OdfSheet)this.ods341.getSheet(sameRowWidthSheet), 3, "Row count mismatch for ODF v3.4.1");
        this.checkRowCount((OdfSheet)this.ods24.getSheet(sameRowWidthSheet), 2, "Row count mismatch for ODF v2.4");
        this.checkRowCount((OdfSheet)this.ods341.getSheet(diffRowWidthSheet), 3, "Row count mismatch for ODF v3.4.1");
        this.checkRowCount((OdfSheet)this.ods24.getSheet(diffRowWidthSheet), 2, "Row count mismatch for ODF v2.4");
        this.checkCellCount((OdfSheet)this.ods341.getSheet(sameRowWidthSheet), 15, "Cell count mismatch for ODF v3.4.1");
        this.checkCellCount((OdfSheet)this.ods24.getSheet(sameRowWidthSheet), 1, "Cell count mismatch for ODF v2.4");
        this.checkCellCount((OdfSheet)this.ods341.getSheet(diffRowWidthSheet), new int[]{15, 15, 12}, "Cell count mismatch for ODF v3.4.1");
        this.checkCellCount((OdfSheet)this.ods24.getSheet(diffRowWidthSheet), new int[]{3, 2}, "Cell count mismatch for ODF v2.4");
    }

    private void checkRowCount(OdfSheet sheet, int expected, String failMsg) {
        int actual = sheet.getRows();
        Assert.assertEquals((String)failMsg, (long)expected, (long)actual);
    }

    private void checkCellCount(OdfSheet sheet, int expected, String failMsg) {
        int rowNo = sheet.getRows();
        for (int i = 0; i < rowNo; ++i) {
            KCell[] row = sheet.getRow(i);
            Assert.assertEquals((String)(failMsg + "; Row content: " + this.rowToString(row)), (long)expected, (long)row.length);
        }
    }

    private void checkCellCount(OdfSheet sheet, int[] expected, String failMsg) {
        int rowNo = sheet.getRows();
        Assert.assertEquals((String)"Row count mismatch", (long)expected.length, (long)rowNo);
        for (int i = 0; i < rowNo; ++i) {
            KCell[] row = sheet.getRow(i);
            Assert.assertEquals((String)(failMsg + "; Row content: " + this.rowToString(row)), (long)expected[i], (long)row.length);
        }
    }

    private String rowToString(KCell[] row) {
        if (row == null || row.length == 0) {
            return "";
        }
        String result = this.cellToStr(row[0]);
        for (int j = 1; j < row.length; ++j) {
            result = result + "," + this.cellToStr(row[j]);
        }
        return result;
    }

    private String cellToStr(KCell cell) {
        String result = "null";
        if (cell != null) {
            result = cell.getContents();
        }
        return result;
    }
}

