/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelwriter;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStep;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepData;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.utils.TestUtils;

public class ExcelWriterStepTest {
    private static final String SHEET_NAME = "Sheet1";
    private HSSFWorkbook wb;
    private StepMockHelper<ExcelWriterStepMeta, ExcelWriterStepData> mockHelper;
    private ExcelWriterStep step;
    private ExcelWriterStepMeta stepMeta;

    @Before
    public void setUp() throws Exception {
        String path = TestUtils.createRamFile(this.getClass().getSimpleName() + "/testXLSProtect.xls");
        FileObject xlsFile = TestUtils.getFileObject(path);
        this.wb = this.createWorkbook(xlsFile);
        this.mockHelper = new StepMockHelper<ExcelWriterStepMeta, ExcelWriterStepData>("Excel Writer Test", ExcelWriterStepMeta.class, ExcelWriterStepData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        this.step = new ExcelWriterStep(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        this.stepMeta = new ExcelWriterStepMeta();
    }

    @Test
    public void testProtectSheet() throws Exception {
        this.step.protectSheet((Sheet)this.wb.getSheet(SHEET_NAME), "aa");
        Assert.assertTrue((boolean)this.wb.getSheet(SHEET_NAME).getProtect());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxSheetNameLength() throws Exception {
        PrintStream err = System.err;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            System.setErr(new PrintStream(baos));
            Mockito.when((Object)((ExcelWriterStepMeta)this.mockHelper.initStepMetaInterface).getSheetname()).thenReturn((Object)"12345678901234567890123456789012");
            this.step.init(this.mockHelper.initStepMetaInterface, this.mockHelper.initStepDataInterface);
            try {
                this.step.prepareNextOutputFile();
                Assert.fail();
            }
            catch (KettleException expected) {
                String content = expected.getMessage();
                if (!content.contains("12345678901234567890123456789012")) {
                    Assert.fail();
                }
            }
        }
        finally {
            System.setErr(err);
        }
    }

    @Test
    public void testTopLevelMetadataEntries() {
        try {
            List entries = this.stepMeta.getStepMetaInjectionInterface().getStepInjectionMetadataEntries();
            String masterKeys = "FIELDS";
            for (StepInjectionMetaEntry entry : entries) {
                String key = entry.getKey();
                Assert.assertTrue((boolean)masterKeys.contains(key));
                masterKeys = masterKeys.replace(key, "");
            }
            Assert.assertTrue((masterKeys.trim().length() == 0 ? 1 : 0) != 0);
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testChildLevelMetadataEntries() {
        try {
            List entries = this.stepMeta.getStepMetaInjectionInterface().getStepInjectionMetadataEntries();
            String childKeys = "NAME TYPE FORMAT STYLECELL FIELDTITLE TITLESTYLE FORMULA HYPERLINKFIELD CELLCOMMENT COMMENTAUTHOR";
            StepInjectionMetaEntry mappingEntry = null;
            for (StepInjectionMetaEntry entry : entries) {
                String key = entry.getKey();
                if (!key.equals("FIELDS")) continue;
                mappingEntry = entry;
                break;
            }
            Assert.assertNotNull(mappingEntry);
            List fieldAttributes = ((StepInjectionMetaEntry)mappingEntry.getDetails().get(0)).getDetails();
            for (StepInjectionMetaEntry attribute : fieldAttributes) {
                String key = attribute.getKey();
                Assert.assertTrue((boolean)childKeys.contains(key));
                childKeys = childKeys.replace(key, "");
            }
            Assert.assertTrue((childKeys.trim().length() == 0 ? 1 : 0) != 0);
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInjection() {
        ExcelWriterStepMeta meta = new ExcelWriterStepMeta();
        try {
            List entries = this.stepMeta.getStepMetaInjectionInterface().getStepInjectionMetadataEntries();
            for (StepInjectionMetaEntry entry : entries) {
                switch (entry.getValueType()) {
                    case 2: {
                        entry.setValue((Object)"new_".concat(entry.getKey()));
                        break;
                    }
                    case 4: {
                        entry.setValue((Object)Boolean.TRUE);
                        break;
                    }
                }
                if (entry.getDetails().isEmpty()) continue;
                List childEntries = ((StepInjectionMetaEntry)entry.getDetails().get(0)).getDetails();
                for (StepInjectionMetaEntry childEntry : childEntries) {
                    switch (childEntry.getValueType()) {
                        case 2: {
                            childEntry.setValue((Object)"new_".concat(childEntry.getKey()));
                            break;
                        }
                        case 4: {
                            childEntry.setValue((Object)Boolean.TRUE);
                            break;
                        }
                    }
                }
            }
            this.stepMeta.getStepMetaInjectionInterface().injectStepMetadataEntries(entries);
            Assert.assertEquals((String)"Cell comment not properly injected... ", (Object)"new_CELLCOMMENT", (Object)this.stepMeta.getOutputFields()[0].getCommentField());
            Assert.assertEquals((String)"Format not properly injected... ", (Object)"new_FORMAT", (Object)this.stepMeta.getOutputFields()[0].getFormat());
            Assert.assertEquals((String)"Hyperlink not properly injected... ", (Object)"new_HYPERLINKFIELD", (Object)this.stepMeta.getOutputFields()[0].getHyperlinkField());
            Assert.assertEquals((String)"Name not properly injected... ", (Object)"new_NAME", (Object)this.stepMeta.getOutputFields()[0].getName());
            Assert.assertEquals((String)"Style cell not properly injected... ", (Object)"new_STYLECELL", (Object)this.stepMeta.getOutputFields()[0].getStyleCell());
            Assert.assertEquals((String)"Title not properly injected... ", (Object)"new_FIELDTITLE", (Object)this.stepMeta.getOutputFields()[0].getTitle());
            Assert.assertEquals((String)"Title style cell not properly injected... ", (Object)"new_TITLESTYLE", (Object)this.stepMeta.getOutputFields()[0].getTitleStyleCell());
            Assert.assertEquals((String)"Type not properly injected... ", (long)0L, (long)this.stepMeta.getOutputFields()[0].getType());
            Assert.assertEquals((String)"Comment author not properly injected... ", (Object)"new_COMMENTAUTHOR", (Object)this.stepMeta.getOutputFields()[0].getCommentAuthorField());
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HSSFWorkbook createWorkbook(FileObject file) throws Exception {
        HSSFWorkbook wb = null;
        OutputStream os = null;
        try {
            os = file.getContent().getOutputStream();
            wb = new HSSFWorkbook();
            wb.createSheet(SHEET_NAME);
            wb.write(os);
        }
        finally {
            os.flush();
            os.close();
        }
        return wb;
    }
}

