/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.http.HTTP;
import org.pentaho.di.trans.steps.http.HTTPData;
import org.pentaho.di.trans.steps.http.HTTPMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class HTTPIT {
    public static final String host = "localhost";
    public static final int port = 9998;
    public static final String HTTP_LOCALHOST_9998 = "http://localhost:9998/";
    @InjectMocks
    private StepMockHelper<HTTPMeta, HTTPData> stepMockHelper;
    private HttpServer httpServer;

    @BeforeClass
    public static void setupBeforeClass() throws KettleException {
        KettleClientEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<HTTPMeta, HTTPData>("HTTP CLIENT TEST", HTTPMeta.class, HTTPData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
        ((Trans)Mockito.verify((Object)this.stepMockHelper.trans, (VerificationMode)Mockito.never())).stopAll();
        this.startHttp204Answer();
    }

    @After
    public void tearDown() throws Exception {
        this.httpServer.stop(5);
    }

    @Test
    public void test204Answer() throws Exception {
        HTTPData data = new HTTPData();
        Object[] expectedRow = new Object[]{"", 204L, null, null, null, null, null, null, null, null, null, null};
        HTTPHandler http = new HTTPHandler(this.stepMockHelper.stepMeta, (StepDataInterface)data, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        http.setInputRowMeta(inputRowMeta);
        Mockito.when((Object)inputRowMeta.clone()).thenReturn((Object)inputRowMeta);
        Mockito.when((Object)((HTTPMeta)this.stepMockHelper.processRowsStepMetaInterface).getUrl()).thenReturn((Object)HTTP_LOCALHOST_9998);
        Mockito.when((Object)((HTTPMeta)this.stepMockHelper.processRowsStepMetaInterface).getHeaderField()).thenReturn((Object)new String[0]);
        Mockito.when((Object)((HTTPMeta)this.stepMockHelper.processRowsStepMetaInterface).getArgumentField()).thenReturn((Object)new String[0]);
        Mockito.when((Object)((HTTPMeta)this.stepMockHelper.processRowsStepMetaInterface).getResultCodeFieldName()).thenReturn((Object)"ResultCodeFieldName");
        Mockito.when((Object)((HTTPMeta)this.stepMockHelper.processRowsStepMetaInterface).getFieldName()).thenReturn((Object)"ResultFieldName");
        http.init((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)data);
        Assert.assertTrue((boolean)http.processRow((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)data));
        System.out.println(Arrays.toString(expectedRow));
        Object[] out = http.getOutputRow();
        System.out.println(Arrays.toString(out));
        Assert.assertTrue((boolean)Arrays.equals(expectedRow, out));
    }

    private void startHttp204Answer() throws IOException {
        this.httpServer = HttpServer.create(new InetSocketAddress(host, 9998), 10);
        this.httpServer.createContext("/", new HttpHandler(){

            @Override
            public void handle(HttpExchange httpExchange) throws IOException {
                httpExchange.sendResponseHeaders(204, 0L);
                httpExchange.close();
            }
        });
        this.httpServer.start();
    }

    @Test
    public void testLoadSaveRoundTrip() throws KettleException {
        List<String> attributes = Arrays.asList("url", "urlInField", "urlField", "encoding", "httpLogin", "httpPassword", "proxyHost", "proxyPort", "socketTimeout", "connectionTimeout", "closeIdleConnectionsTime", "argumentField", "argumentParameter", "headerField", "headerParameter", "fieldName", "resultCodeFieldName", "responseTimeFieldName");
        HashMap fieldLoadSaveValidatorAttributeMap = new HashMap();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 25);
        fieldLoadSaveValidatorAttributeMap.put("argumentField", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("argumentParameter", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("headerField", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("headerParameter", stringArrayLoadSaveValidator);
        LoadSaveTester loadSaveTester = new LoadSaveTester(HTTPMeta.class, attributes, new HashMap<String, String>(), new HashMap<String, String>(), fieldLoadSaveValidatorAttributeMap, new HashMap());
        loadSaveTester.testRepoRoundTrip();
        loadSaveTester.testXmlRoundTrip();
    }

    private class HTTPHandler
    extends HTTP {
        Object[] row;
        Object[] outputRow;

        public HTTPHandler(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
            this.row = new Object[]{"anyData"};
        }

        public Object[] getRow() throws KettleException {
            return this.row;
        }

        public void putRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            this.outputRow = row;
        }

        public Object[] getOutputRow() {
            return this.outputRow;
        }
    }
}

