/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ifnull;

import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ifnull.IfNull;
import org.pentaho.di.trans.steps.ifnull.IfNullData;
import org.pentaho.di.trans.steps.ifnull.IfNullMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.test.util.FieldAccessor;

public class IfNullTest {
    StepMockHelper<IfNullMeta, IfNullData> smh;

    @BeforeClass
    public static void beforeClass() throws KettleException {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        this.smh = new StepMockHelper<IfNullMeta, IfNullData>("Field IfNull processor", IfNullMeta.class, IfNullData.class);
        Mockito.when((Object)this.smh.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.smh.logChannelInterface);
        Mockito.when((Object)this.smh.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void clean() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        FieldAccessor.resetEmptyStringIsNotNull();
    }

    private RowSet buildInputRowSet(Object ... row) {
        return this.smh.getMockInputRowSet(new Object[][]{row});
    }

    private IfNullMeta mockProcessRowMeta() throws KettleStepException {
        IfNullMeta processRowMeta = (IfNullMeta)this.smh.processRowsStepMetaInterface;
        ((IfNullMeta)Mockito.doReturn((Object)new String[]{"null-field", "empty-field", "space-field"}).when((Object)processRowMeta)).getFieldName();
        ((IfNullMeta)Mockito.doReturn((Object)"replace-value").when((Object)processRowMeta)).getReplaceAllByValue();
        ((IfNullMeta)Mockito.doCallRealMethod().when((Object)processRowMeta)).getFields((RowMetaInterface)Matchers.any(RowMetaInterface.class), Matchers.anyString(), (RowMetaInterface[])Matchers.any(RowMetaInterface[].class), (StepMeta)Matchers.any(StepMeta.class), (VariableSpace)Matchers.any(VariableSpace.class), (Repository)Matchers.any(Repository.class), (IMetaStore)Matchers.any(IMetaStore.class));
        return processRowMeta;
    }

    private RowMeta buildInputRowMeta(ValueMetaInterface ... valueMetaInterface) {
        RowMeta inputRowMeta = new RowMeta();
        for (ValueMetaInterface iValuMetaInterface : valueMetaInterface) {
            inputRowMeta.addValueMeta(iValuMetaInterface);
        }
        return inputRowMeta;
    }

    @Test
    public void testString_emptyIsNull() throws KettleException {
        boolean hasMoreRows;
        FieldAccessor.ensureEmptyStringIsNotNull(false);
        IfNull step = new IfNull(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        step.init(this.smh.initStepMetaInterface, this.smh.stepDataInterface);
        RowMeta inputRowMeta = this.buildInputRowMeta(new ValueMetaInterface[]{new ValueMetaString("some-field"), new ValueMetaString("null-field"), new ValueMetaString("empty-field"), new ValueMetaString("space-field"), new ValueMetaString("another-field")});
        step.setInputRowMeta((RowMetaInterface)inputRowMeta);
        Object[] inputRow = new Object[]{"value1", null, "", "    ", "value5"};
        Object[] expectedRow = new Object[]{"value1", "replace-value", "replace-value", "    ", "value5"};
        step.getInputRowSets().add(this.buildInputRowSet(inputRow));
        step.getOutputRowSets().add(new QueueRowSet());
        while (hasMoreRows = step.processRow((StepMetaInterface)this.mockProcessRowMeta(), this.smh.processRowsStepDataInterface)) {
        }
        RowSet outputRowSet = (RowSet)step.getOutputRowSets().get(0);
        this.assertRowSetMatches("", expectedRow, outputRowSet);
    }

    @Test
    public void testString_emptyIsNotNull() throws KettleException {
        boolean hasMoreRows;
        FieldAccessor.ensureEmptyStringIsNotNull(true);
        IfNull step = new IfNull(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        step.init(this.smh.initStepMetaInterface, this.smh.stepDataInterface);
        RowMeta inputRowMeta = this.buildInputRowMeta(new ValueMetaInterface[]{new ValueMetaString("some-field"), new ValueMetaString("null-field"), new ValueMetaString("empty-field"), new ValueMetaString("space-field"), new ValueMetaString("another-field")});
        step.setInputRowMeta((RowMetaInterface)inputRowMeta);
        Object[] inputRow = new Object[]{"value1", null, "", "    ", "value5"};
        Object[] expectedRow = new Object[]{"value1", "replace-value", "", "    ", "value5"};
        step.getInputRowSets().add(this.buildInputRowSet(inputRow));
        step.getOutputRowSets().add(new QueueRowSet());
        while (hasMoreRows = step.processRow((StepMetaInterface)this.mockProcessRowMeta(), this.smh.processRowsStepDataInterface)) {
        }
        RowSet outputRowSet = (RowSet)step.getOutputRowSets().get(0);
        this.assertRowSetMatches("", expectedRow, outputRowSet);
    }

    private void assertRowSetMatches(String msg, Object[] expectedRow, RowSet outputRowSet) {
        Object[] actualRow = outputRowSet.getRow();
        Assert.assertEquals((String)(msg + ". Output row is of an unexpected length"), (int)expectedRow.length, (int)outputRowSet.getRowMeta().size());
        for (int i = 0; i < expectedRow.length; ++i) {
            Assert.assertEquals((String)(msg + ". Unexpected output value at index " + i), (Object)expectedRow[i], (Object)actualRow[i]);
        }
    }
}

