/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mapping;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.mapping.Mapping;
import org.pentaho.di.trans.steps.mapping.MappingData;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.pentaho.di.trans.steps.mapping.MappingParameters;

public class MappingParametersTest {
    private Mapping step;
    private Trans trans;
    private TransMeta transMeta;

    @Before
    public void setUp() throws Exception {
        this.step = StepMockUtil.getStep(Mapping.class, MappingMeta.class, "junit");
        this.trans = (Trans)Mockito.mock(Trans.class);
        this.transMeta = (TransMeta)Mockito.mock(TransMeta.class);
    }

    @After
    public void tearDown() throws Exception {
        this.step = null;
        this.trans = null;
        this.transMeta = null;
    }

    @Test
    public void testInheritAllParametersCopy() throws Exception {
        MappingParameters param = new MappingParameters();
        this.step.setVariable("a", "1");
        this.step.setVariable("b", "2");
        param.setInheritingAllVariables(true);
        Mockito.when((Object)this.transMeta.listParameters()).thenReturn((Object)new String[]{"a"});
        this.step.setMappingParameters(this.trans, this.transMeta, param);
        ((Trans)Mockito.verify((Object)this.trans)).setVariable("b", "2");
        ((Trans)Mockito.verify((Object)this.trans)).setParameterValue("a", "1");
    }

    @Test
    public void testOverrideMappingParameters() throws KettleException {
        MappingParameters param = (MappingParameters)Mockito.mock(MappingParameters.class);
        Mockito.when((Object)param.getVariable()).thenReturn((Object)new String[]{"a", "b"});
        Mockito.when((Object)param.getInputField()).thenReturn((Object)new String[]{"11", "12"});
        Mockito.when((Object)this.transMeta.listParameters()).thenReturn((Object)new String[]{"a"});
        this.step.setMappingParameters(this.trans, this.transMeta, param);
        ((Trans)Mockito.verify((Object)this.trans, (VerificationMode)Mockito.times((int)1))).setParameterValue(Mockito.anyString(), Mockito.anyString());
        ((Trans)Mockito.verify((Object)this.trans, (VerificationMode)Mockito.times((int)1))).setVariable(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void testDoNotOverrideMappingParametes() throws KettleException {
        this.prepareMappingParametesActions(false);
        ((TransMeta)Mockito.verify((Object)this.transMeta, (VerificationMode)Mockito.never())).copyVariablesFrom((VariableSpace)Mockito.any(VariableSpace.class));
    }

    @Test
    public void testDoOverrideMappingParametes() throws KettleException {
        this.prepareMappingParametesActions(true);
        ((TransMeta)Mockito.verify((Object)this.transMeta, (VerificationMode)Mockito.times((int)1))).copyVariablesFrom((VariableSpace)Mockito.any(VariableSpace.class));
    }

    private void prepareMappingParametesActions(boolean override) throws KettleException {
        MappingMeta meta = new MappingMeta();
        meta.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        Repository rep = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)this.step.getTransMeta().getRepository()).thenReturn((Object)rep);
        Mockito.when((Object)rep.loadTransformation((ObjectId)Mockito.any(ObjectId.class), Mockito.anyString())).thenReturn((Object)this.transMeta);
        MappingParameters mapPar = new MappingParameters();
        mapPar.setInheritingAllVariables(override);
        meta.setMappingParameters(mapPar);
        MappingData data = new MappingData();
        this.step.init((StepMetaInterface)meta, (StepDataInterface)data);
    }
}

