/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mergejoin;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidatorFactory;
import org.pentaho.di.trans.steps.mergejoin.MergeJoinMeta;

public class MergeJoinMetaTest {
    LoadSaveTester loadSaveTester;

    public MergeJoinMetaTest() {
        List<String> attributes = Arrays.asList("joinType", "keyFields1", "keyFields2");
        HashMap attrValidatorMap = new HashMap();
        HashMap typeValidatorMap = new HashMap();
        HashMap<String, String> getterMap = new HashMap<String, String>();
        getterMap.put("joinType", "getJoinType");
        getterMap.put("keyFields1", "getKeyFields1");
        getterMap.put("keyFields2", "getKeyFields2");
        HashMap<String, String> setterMap = new HashMap<String, String>();
        setterMap.put("joinType", "setJoinType");
        setterMap.put("keyFields1", "setKeyFields1");
        setterMap.put("keyFields2", "setKeyFields2");
        this.loadSaveTester = new LoadSaveTester(MergeJoinMeta.class, attributes, getterMap, setterMap, attrValidatorMap, typeValidatorMap);
        FieldLoadSaveValidatorFactory validatorFactory = this.loadSaveTester.getFieldLoadSaveValidatorFactory();
        FieldLoadSaveValidator<MergeJoinMeta> targetValidator = new FieldLoadSaveValidator<MergeJoinMeta>(){

            @Override
            public MergeJoinMeta getTestObject() {
                return new MergeJoinMeta(){
                    {
                        this.setJoinType(join_types[0]);
                        this.setKeyFields1(new String[]{"field1", "field2"});
                        this.setKeyFields2(new String[]{"field1", "field3"});
                    }
                };
            }

            @Override
            public boolean validateTestObject(MergeJoinMeta testObject, Object actual) {
                return testObject.getJoinType().equals(((MergeJoinMeta)actual).getJoinType()) && Arrays.equals(testObject.getKeyFields1(), ((MergeJoinMeta)actual).getKeyFields1()) && Arrays.equals(testObject.getKeyFields2(), ((MergeJoinMeta)actual).getKeyFields2());
            }
        };
        validatorFactory.registerValidator(validatorFactory.getName((Type)((Object)MergeJoinMeta.class)), targetValidator);
    }

    @Test
    public void testLoadSaveXML() throws KettleException {
        this.loadSaveTester.testXmlRoundTrip();
    }

    @Test
    public void testLoadSaveRepo() throws KettleException {
        this.loadSaveTester.testRepoRoundTrip();
    }

    @Test
    public void testGetFieldsEmptyInput() throws Exception {
        RowMeta outputRowMeta = new RowMeta();
        MergeJoinMeta meta = new MergeJoinMeta();
        RowMeta inputRow1 = new RowMeta();
        ValueMetaInteger field1_row1 = new ValueMetaInteger("field1");
        field1_row1.setOrigin("inputStep1");
        inputRow1.addValueMeta((ValueMetaInterface)field1_row1);
        ValueMetaString field2_row1 = new ValueMetaString("field2");
        field2_row1.setOrigin("inputStep1");
        inputRow1.addValueMeta((ValueMetaInterface)field2_row1);
        RowMeta inputRow2 = new RowMeta();
        ValueMetaString field1_row2 = new ValueMetaString("field1");
        field1_row2.setOrigin("inputStep2");
        inputRow2.addValueMeta((ValueMetaInterface)field1_row2);
        ValueMetaString field3_row2 = new ValueMetaString("field3");
        field3_row2.setOrigin("inputStep2");
        inputRow2.addValueMeta((ValueMetaInterface)field3_row2);
        StepMeta stepMeta = new StepMeta("Merge", (StepMetaInterface)meta);
        meta.getFields((RowMetaInterface)outputRowMeta, "Merge Join", new RowMetaInterface[]{inputRow1, inputRow2}, stepMeta, (VariableSpace)new Variables(), null, null);
        Assert.assertNotNull((Object)outputRowMeta);
        Assert.assertFalse((boolean)outputRowMeta.isEmpty());
        Assert.assertEquals((long)4L, (long)outputRowMeta.size());
        List vmi = outputRowMeta.getValueMetaList();
        Assert.assertNotNull((Object)vmi);
        ValueMetaInterface field1 = outputRowMeta.getValueMeta(0);
        Assert.assertNotNull((Object)field1);
        Assert.assertEquals((Object)"field1", (Object)field1.getName());
        Assert.assertTrue((boolean)(field1 instanceof ValueMetaInteger));
        Assert.assertEquals((Object)"inputStep1", (Object)field1.getOrigin());
        ValueMetaInterface field2 = outputRowMeta.getValueMeta(1);
        Assert.assertNotNull((Object)field2);
        Assert.assertEquals((Object)"field2", (Object)field2.getName());
        Assert.assertTrue((boolean)(field2 instanceof ValueMetaString));
        Assert.assertEquals((Object)"inputStep1", (Object)field2.getOrigin());
        ValueMetaInterface field1_1 = outputRowMeta.getValueMeta(2);
        Assert.assertNotNull((Object)field1_1);
        Assert.assertEquals((Object)"field1_1", (Object)field1_1.getName());
        Assert.assertTrue((boolean)(field1_1 instanceof ValueMetaString));
        Assert.assertEquals((Object)"Merge Join", (Object)field1_1.getOrigin());
        ValueMetaInterface field3 = outputRowMeta.getValueMeta(3);
        Assert.assertNotNull((Object)field3);
        Assert.assertEquals((Object)"field3", (Object)field3.getName());
        Assert.assertTrue((boolean)(field3 instanceof ValueMetaString));
        Assert.assertEquals((Object)"inputStep2", (Object)field3.getOrigin());
    }
}

