/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.orabulkloader;

import java.io.File;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoader;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoaderData;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoaderMeta;

public class OraBulkLoaderTest {
    @BeforeClass
    public static void setupBeforeClass() throws KettleException {
        KettleClientEnvironment.init();
    }

    @Test
    public void testCreateCommandLine() throws Exception {
        StepMockHelper<OraBulkLoaderMeta, OraBulkLoaderData> stepMockHelper = new StepMockHelper<OraBulkLoaderMeta, OraBulkLoaderData>("TEST_CREATE_COMMANDLINE", OraBulkLoaderMeta.class, OraBulkLoaderData.class);
        Mockito.when((Object)stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)stepMockHelper.logChannelInterface);
        Mockito.when((Object)stepMockHelper.trans.isRunning()).thenReturn((Object)true);
        OraBulkLoader oraBulkLoader = new OraBulkLoader(stepMockHelper.stepMeta, stepMockHelper.stepDataInterface, 0, stepMockHelper.transMeta, stepMockHelper.trans);
        File tmp = File.createTempFile("testCreateCOmmandLine", "tmp");
        tmp.deleteOnExit();
        OraBulkLoaderMeta meta = new OraBulkLoaderMeta();
        meta.setSqlldr(tmp.getAbsolutePath());
        meta.setControlFile(tmp.getAbsolutePath());
        DatabaseMeta dm = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        Mockito.when((Object)dm.getUsername()).thenReturn((Object)"user");
        Mockito.when((Object)dm.getPassword()).thenReturn((Object)"Encrypted 2be98afc86aa7f2e4cb298b5eeab387f5");
        meta.setDatabaseMeta(dm);
        String cmd = oraBulkLoader.createCommandLine(meta, true);
        String expected = tmp.getAbsolutePath() + " control='" + tmp.getAbsolutePath() + "' userid=user/PENTAHO@";
        Assert.assertEquals((String)"Comandline for oracle bulkloader is not as expected", (Object)expected, (Object)cmd);
    }
}

