/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.prioritizestreams;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.SingleRowRowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.prioritizestreams.PrioritizeStreams;
import org.pentaho.di.trans.steps.prioritizestreams.PrioritizeStreamsData;
import org.pentaho.di.trans.steps.prioritizestreams.PrioritizeStreamsMeta;

public class PrioritizeStreamsTest {
    private static StepMockHelper<PrioritizeStreamsMeta, StepDataInterface> stepMockHelper;

    @BeforeClass
    public static void setup() {
        stepMockHelper = new StepMockHelper<PrioritizeStreamsMeta, StepDataInterface>("Priority Streams Test", PrioritizeStreamsMeta.class, StepDataInterface.class);
        Mockito.when((Object)PrioritizeStreamsTest.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)PrioritizeStreamsTest.stepMockHelper.logChannelInterface);
        Mockito.when((Object)PrioritizeStreamsTest.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @AfterClass
    public static void tearDown() {
        stepMockHelper.cleanUp();
    }

    @Test
    public void testProcessRow() throws KettleException {
        PrioritizeStreamsMeta meta = new PrioritizeStreamsMeta();
        meta.setStepName(new String[]{"high", "medium", "low"});
        PrioritizeStreamsData data = new PrioritizeStreamsData();
        PrioritizeStreamsInner step = new PrioritizeStreamsInner(stepMockHelper);
        try {
            step.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        }
        catch (NullPointerException e) {
            Assert.fail((String)"NullPointerException detecded, seems that RowMetaInterface was not set for RowSet you are attemptingto read from.");
        }
        junit.framework.Assert.assertTrue((String)"First waiting for row set is 'high'", (boolean)data.currentRowSet.getClass().equals(SingleRowRowSet.class));
    }

    private class PrioritizeStreamsInner
    extends PrioritizeStreams {
        public PrioritizeStreamsInner(StepMockHelper<PrioritizeStreamsMeta, StepDataInterface> stepMockHelper) {
            super(stepMockHelper.stepMeta, stepMockHelper.stepDataInterface, 0, stepMockHelper.transMeta, stepMockHelper.trans);
        }

        public RowSet findInputRowSet(String sourceStep) throws KettleStepException {
            if (sourceStep.equals("high")) {
                return new SingleRowRowSet();
            }
            return new QueueRowSet();
        }

        protected void checkInputLayoutValid(RowMetaInterface referenceRowMeta, RowMetaInterface compareRowMeta) {
        }

        public Object[] getRowFrom(RowSet rowSet) throws KettleStepException {
            rowSet.setRowMeta((RowMetaInterface)new RowMeta());
            return new Object[0];
        }

        public void putRow(RowMetaInterface rmi, Object[] input) {
            if (rmi == null) {
                throw new NullPointerException();
            }
        }
    }
}

