/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.regexeval;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.TransTestingUtil;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.regexeval.RegexEval;
import org.pentaho.di.trans.steps.regexeval.RegexEvalData;
import org.pentaho.di.trans.steps.regexeval.RegexEvalMeta;
import org.pentaho.test.util.FieldAccessor;

public class RegexEval_EmptyStringVsNull_Test {
    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Test
    public void emptyAndNullsAreNotDifferent() throws Exception {
        List<Object[]> expected = Arrays.asList({false, ""}, {false, ""}, {false, null});
        this.doTestEmptyStringVsNull(false, expected);
    }

    @Test
    public void emptyAndNullsAreDifferent() throws Exception {
        List<Object[]> expected = Arrays.asList({false, ""}, {false, ""}, {false, null});
        this.doTestEmptyStringVsNull(true, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestEmptyStringVsNull(boolean diffProperty, List<Object[]> expected) throws Exception {
        FieldAccessor.ensureEmptyStringIsNotNull(diffProperty);
        try {
            this.executeAndAssertResults(expected);
        }
        finally {
            FieldAccessor.resetEmptyStringIsNotNull();
        }
    }

    private void executeAndAssertResults(List<Object[]> expected) throws Exception {
        RegexEvalMeta meta = new RegexEvalMeta();
        meta.allocate(2);
        meta.getFieldName()[0] = "string";
        meta.getFieldName()[1] = "matcher";
        meta.setFieldType(new int[]{2, 2});
        meta.setResultFieldName("string");
        meta.setReplacefields(true);
        meta.setMatcher("matcher");
        meta.setAllowCaptureGroupsFlag(true);
        RegexEvalData data = new RegexEvalData();
        RegexEval step = this.createAndInitStep(meta, data);
        RowMeta input = new RowMeta();
        input.addValueMeta((ValueMetaInterface)new ValueMetaString("string"));
        input.addValueMeta((ValueMetaInterface)new ValueMetaString("matcher"));
        step.setInputRowMeta((RowMetaInterface)input);
        step = (RegexEval)Mockito.spy((Object)step);
        ((RegexEval)Mockito.doReturn((Object)new String[]{" ", " "}).doReturn((Object)new String[]{"", ""}).doReturn((Object)new String[]{null, null}).when((Object)step)).getRow();
        data.pattern = Pattern.compile("(a)(a)");
        List<Object[]> actual = TransTestingUtil.execute((BaseStep)step, (StepMetaInterface)meta, (StepDataInterface)data, 3, false);
        TransTestingUtil.assertResult(expected, actual);
    }

    private RegexEval createAndInitStep(RegexEvalMeta meta, RegexEvalData data) throws Exception {
        StepMockHelper<RegexEvalMeta, StepDataInterface> helper = StepMockUtil.getStepMockHelper(RegexEvalMeta.class, "RegexEval_EmptyStringVsNull_Test");
        Mockito.when((Object)helper.stepMeta.getStepMetaInterface()).thenReturn((Object)meta);
        RegexEval step = new RegexEval(helper.stepMeta, (StepDataInterface)data, 0, helper.transMeta, helper.trans);
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        return step;
    }
}

