/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.replacestring;

import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.replacestring.ReplaceString;
import org.pentaho.di.trans.steps.replacestring.ReplaceStringData;
import org.pentaho.di.trans.steps.replacestring.ReplaceStringMeta;

public class ReplaceStringTest {
    private Object[] row = new Object[]{"some data", "another data"};
    private Object[] expectedRow = new Object[]{"some data", "1nother d1t1", "1no2her d121", null, null, null, null, null, null, null, null, null, null};
    private StepMockHelper<ReplaceStringMeta, ReplaceStringData> stepMockHelper;

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<ReplaceStringMeta, ReplaceStringData>("REPLACE STRING TEST", ReplaceStringMeta.class, ReplaceStringData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Matchers.anyString());
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Matchers.anyString(), new Object[]{Matchers.anyObject()});
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Matchers.anyString(), (Throwable)Matchers.anyObject());
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void tearDown() throws Exception {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testGetOneRow() throws Exception {
        ReplaceStringData data = new ReplaceStringData();
        ReplaceString replaceString = new ReplaceString(this.stepMockHelper.stepMeta, (StepDataInterface)data, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        RowMeta inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta(0, (ValueMetaInterface)new ValueMetaString("SomeDataMeta"));
        inputRowMeta.addValueMeta(1, (ValueMetaInterface)new ValueMetaString("AnotherDataMeta"));
        replaceString.init(this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)data);
        replaceString.setInputRowMeta((RowMetaInterface)inputRowMeta);
        data.outputRowMeta = inputRowMeta;
        data.outputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("AnotherDataMeta"));
        data.inputFieldsNr = 2;
        data.numFields = 2;
        data.inStreamNrs = new int[]{1, 1};
        data.patterns = new Pattern[]{Pattern.compile("a"), Pattern.compile("t")};
        data.replaceFieldIndex = new int[]{-1, -1};
        data.outStreamNrs = new String[]{"", "1"};
        data.replaceByString = new String[]{"1", "2"};
        data.setEmptyString = new boolean[]{false, false};
        Object[] output = replaceString.getOneRow((RowMetaInterface)inputRowMeta, this.row);
        Assert.assertArrayEquals((String)"Output varies", (Object[])this.expectedRow, (Object[])output);
    }
}

