/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rowgenerator;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.steps.loadsave.MemoryRepository;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;
import org.pentaho.metastore.api.IMetaStore;

public class RowGeneratorMetaTest {
    private Repository rep;
    private ObjectId id_step;
    private final String launchVariable = "${ROW_LIMIT}";
    private final String rowGeneratorRowLimitCode = "limit";

    @Before
    public void setUp() throws KettleException {
        this.rep = new MemoryRepository();
        this.id_step = new StringObjectId("aStringObjectID");
        this.rep.saveStepAttribute((ObjectId)new StringObjectId("transId"), this.id_step, "limit", "${ROW_LIMIT}");
    }

    @Test
    public void testReadRowLimitAsStringFromRepository() throws KettleException {
        RowGeneratorMeta rowGeneratorMeta = new RowGeneratorMeta();
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        rowGeneratorMeta.readRep(this.rep, metaStore, this.id_step, Collections.singletonList(dbMeta));
        Assert.assertEquals((Object)rowGeneratorMeta.getRowLimit(), (Object)"${ROW_LIMIT}");
    }
}

