/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rowgenerator;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rowgenerator.RowGenerator;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorData;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;

public class RowGeneratorUnitTest {
    private RowGenerator rowGenerator;

    @BeforeClass
    public static void initEnvironment() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() throws KettleException {
        StepMetaInterface stepMetaInterface = (StepMetaInterface)Mockito.spy((Object)new RowGeneratorMeta());
        ((RowGeneratorMeta)stepMetaInterface).setRowLimit("${ROW_LIMIT}");
        String[] strings = new String[]{};
        Mockito.when((Object)((RowGeneratorMeta)stepMetaInterface).getFieldName()).thenReturn((Object)strings);
        StepMeta stepMeta = new StepMeta();
        stepMeta.setStepMetaInterface(stepMetaInterface);
        stepMeta.setName("ROW_STEP_META");
        StepDataInterface stepDataInterface = stepMeta.getStepMetaInterface().getStepData();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ROW_LIMIT", "1440");
        TransMeta transMeta = (TransMeta)Mockito.spy((Object)new TransMeta());
        transMeta.injectVariables(map);
        Mockito.when((Object)transMeta.findStep(Mockito.anyString())).thenReturn((Object)stepMeta);
        Trans trans = (Trans)Mockito.spy((Object)new Trans(transMeta, null));
        Mockito.when((Object)trans.getSocketRepository()).thenReturn(null);
        Mockito.when((Object)trans.getLogChannelId()).thenReturn((Object)"ROW_LIMIT");
        this.rowGenerator = (RowGenerator)Mockito.spy((Object)new RowGenerator(stepMeta, stepDataInterface, 0, transMeta, trans));
        this.rowGenerator.initializeVariablesFrom((VariableSpace)trans);
        this.rowGenerator.init(stepMetaInterface, stepDataInterface);
    }

    @Test
    public void testReadRowLimitAsTransformationVar() throws KettleException {
        long rowLimit = ((RowGeneratorData)this.rowGenerator.getStepDataInterface()).rowLimit;
        Assert.assertEquals((long)rowLimit, (long)1440L);
    }
}

