/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sort;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.MemoryRepository;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.BooleanLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveBooleanArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.sort.SortRowsMeta;
import org.pentaho.metastore.api.IMetaStore;

public class SortRowsMetaUnit {
    private List<DatabaseMeta> databases;
    private IMetaStore metaStore;

    @Before
    public void setUp() {
        this.databases = (List)Mockito.mock(List.class);
        this.metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
    }

    @Test
    public void testReadRep() throws KettleException {
        String sortSize = "${test}";
        MemoryRepository rep = new MemoryRepository();
        rep.saveStepAttribute(null, null, "sort_size", sortSize);
        SortRowsMeta sortRowsMeta = new SortRowsMeta();
        sortRowsMeta.readRep((Repository)rep, this.metaStore, null, this.databases);
        Assert.assertEquals((Object)sortSize, (Object)sortRowsMeta.getSortSize());
        int sortSizeInt = Mockito.anyInt();
        MemoryRepository rep2 = new MemoryRepository();
        rep2.saveStepAttribute(null, null, "sort_size", sortSizeInt);
        SortRowsMeta sortRowsMeta2 = new SortRowsMeta();
        sortRowsMeta2.readRep((Repository)rep2, this.metaStore, null, this.databases);
        Assert.assertEquals((Object)String.valueOf(sortSizeInt), (Object)sortRowsMeta2.getSortSize());
    }

    @Test
    public void testRoundTrips() throws KettleException {
        List<String> attributes = Arrays.asList("directory", "prefix", "sort_size", "free_memory", "compress", "compress_variable", "unique_rows", "name", "ascending", "case_sensitive", "presorted");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        getterMap.put("sort_size", "getSortSize");
        getterMap.put("free_memory", "getFreeMemoryLimit");
        getterMap.put("compress", "getCompressFiles");
        getterMap.put("compress_variable", "getCompressFilesVariable");
        getterMap.put("unique_rows", "isOnlyPassingUniqueRows");
        getterMap.put("name", "getFieldName");
        getterMap.put("case_sensitive", "getCaseSensitive");
        getterMap.put("presorted", "getPreSortedField");
        HashMap<String, String> setterMap = new HashMap<String, String>();
        setterMap.put("sort_size", "setSortSize");
        setterMap.put("free_memory", "setFreeMemoryLimit");
        setterMap.put("compress", "setCompressFiles");
        setterMap.put("compress_variable", "setCompressFilesVariable");
        setterMap.put("name", "setFieldName");
        setterMap.put("case_sensitive", "setCaseSensitive");
        setterMap.put("presorted", "setPreSortedField");
        HashMap fieldLoadSaveValidatorAttributeMap = new HashMap();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 25);
        PrimitiveBooleanArrayLoadSaveValidator booleanArrayLoadSaveValidator = new PrimitiveBooleanArrayLoadSaveValidator(new BooleanLoadSaveValidator(), 25);
        fieldLoadSaveValidatorAttributeMap.put("name", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("ascending", booleanArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("case_sensitive", booleanArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("presorted", booleanArrayLoadSaveValidator);
        LoadSaveTester loadSaveTester = new LoadSaveTester(SortRowsMeta.class, attributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, new HashMap());
        loadSaveTester.testRepoRoundTrip();
        loadSaveTester.testXmlRoundTrip();
    }
}

