/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.synchronizeaftermerge;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.Driver;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.synchronizeaftermerge.SynchronizeAfterMerge;
import org.pentaho.di.trans.steps.synchronizeaftermerge.SynchronizeAfterMergeData;
import org.pentaho.di.trans.steps.synchronizeaftermerge.SynchronizeAfterMergeMeta;

public class SynchronizeAfterMergeIT {
    private static final int COMMIT_SIZE = 10;
    private static final int ROW_SIZE = 5;
    private static final int ROW_FOR_UPDATE = 18;
    private static final int ROW_FOR_DELETE = 18;
    private static final int ROW_FOR_INSERT = 18;
    private static final String DELETE_FLAG = "deleted";
    private static final String INSERT_FLAG = "insert";
    private static final String UPDATE_FLAG = "update";
    private String injectorStepname = "injectorStepname";
    private String synchronizeAfterMergeStepname = "SynchronizeAfterMerge";
    private TransMeta transMeta;
    private Connection connection;

    @BeforeClass
    public static void beforeClass() throws Exception {
        KettleEnvironment.init();
        DriverManager.registerDriver((java.sql.Driver)new Driver());
    }

    @AfterClass
    public static void afterClass() throws Exception {
        KettleEnvironment.shutdown();
    }

    @After
    public void tearDown() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    @Before
    public void setUp() throws KettleDatabaseException, SQLException {
        this.connection = DriverManager.getConnection("jdbc:h2:mem:PERSON;");
        this.connection.setAutoCommit(false);
        PreparedStatement stmt = this.connection.prepareStatement("CREATE TABLE PERSON (ID INT PRIMARY KEY, personName VARCHAR(64) )");
        stmt.execute();
        stmt.close();
        stmt = this.connection.prepareStatement("INSERT INTO PERSON (ID, personName) VALUES (?, ?)");
        for (int i = 0; i < 36; ++i) {
            stmt.setInt(1, i);
            stmt.setString(2, "personName" + i);
            stmt.addBatch();
        }
        stmt.executeBatch();
        stmt.close();
        this.connection.commit();
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        this.transMeta = new TransMeta();
        this.transMeta.setName("SynchronizeAfterMerge");
        InjectorMeta injectorMeta = new InjectorMeta();
        String injectorPid = pluginRegistry.getPluginId(StepPluginType.class, (Object)injectorMeta);
        StepMeta injectorStep = new StepMeta(injectorPid, this.injectorStepname, (StepMetaInterface)injectorMeta);
        this.transMeta.addStep(injectorStep);
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.spy((Object)new DatabaseMeta());
        dbMeta.setDatabaseType("H2");
        Mockito.when((Object)dbMeta.getURL()).thenReturn((Object)"jdbc:h2:mem:PERSON;");
        Mockito.when((Object)dbMeta.supportsErrorHandlingOnBatchUpdates()).thenReturn((Object)false);
        SynchronizeAfterMergeMeta synchronizeAfterMergeMeta = new SynchronizeAfterMergeMeta();
        synchronizeAfterMergeMeta.setCommitSize(10);
        synchronizeAfterMergeMeta.setDatabaseMeta(dbMeta);
        synchronizeAfterMergeMeta.setKeyCondition(new String[]{"="});
        synchronizeAfterMergeMeta.setKeyLookup(new String[]{"ID"});
        synchronizeAfterMergeMeta.setKeyStream(new String[]{"personName"});
        synchronizeAfterMergeMeta.setKeyStream2(new String[]{null});
        synchronizeAfterMergeMeta.setUpdate(new Boolean[]{Boolean.TRUE});
        synchronizeAfterMergeMeta.setOperationOrderField("flag");
        synchronizeAfterMergeMeta.setOrderDelete(DELETE_FLAG);
        synchronizeAfterMergeMeta.setOrderInsert(INSERT_FLAG);
        synchronizeAfterMergeMeta.setOrderUpdate(UPDATE_FLAG);
        synchronizeAfterMergeMeta.setPerformLookup(true);
        synchronizeAfterMergeMeta.setTableName("PERSON");
        synchronizeAfterMergeMeta.settablenameInField(false);
        synchronizeAfterMergeMeta.settablenameField(null);
        synchronizeAfterMergeMeta.setUseBatchUpdate(true);
        synchronizeAfterMergeMeta.setUpdateLookup(new String[]{"ID"});
        synchronizeAfterMergeMeta.setUpdateStream(new String[]{"personName"});
        String synchronizeAfterMergePid = pluginRegistry.getPluginId(StepPluginType.class, (Object)this.synchronizeAfterMergeStepname);
        StepMeta synchronizeAfterMerge = new StepMeta(synchronizeAfterMergePid, this.synchronizeAfterMergeStepname, (StepMetaInterface)synchronizeAfterMergeMeta);
        this.transMeta.addStep(synchronizeAfterMerge);
        String dummyResultStepName = "dummyResultStepName";
        DummyTransMeta dummyResultTransMeta = new DummyTransMeta();
        String dummyResultPid = pluginRegistry.getPluginId(StepPluginType.class, (Object)dummyResultTransMeta);
        StepMeta dummyResultStep = new StepMeta(dummyResultPid, dummyResultStepName, (StepMetaInterface)dummyResultTransMeta);
        this.transMeta.addStep(dummyResultStep);
        String dummyErrorStepName = "dummyErrorStepName";
        DummyTransMeta dummyErrorTransMeta = new DummyTransMeta();
        String dummyErrorPid = pluginRegistry.getPluginId(StepPluginType.class, (Object)dummyErrorTransMeta);
        StepMeta dummyErrorStep = new StepMeta(dummyErrorPid, dummyErrorStepName, (StepMetaInterface)dummyErrorTransMeta);
        this.transMeta.addStep(dummyErrorStep);
        StepErrorMeta stepErrorMeta = new StepErrorMeta((VariableSpace)this.transMeta, synchronizeAfterMerge, dummyErrorStep);
        stepErrorMeta.setEnabled(true);
        synchronizeAfterMerge.setStepErrorMeta(stepErrorMeta);
        TransHopMeta injSynch = new TransHopMeta(injectorStep, synchronizeAfterMerge);
        this.transMeta.addTransHop(injSynch);
        TransHopMeta synchDummyResult = new TransHopMeta(synchronizeAfterMerge, dummyResultStep);
        this.transMeta.addTransHop(synchDummyResult);
        TransHopMeta synchDummyError = new TransHopMeta(synchronizeAfterMerge, dummyErrorStep);
        this.transMeta.addTransHop(synchDummyError);
    }

    @Test
    public void testProcessRow_Itterupted() throws Exception {
        this.processRow(TransProcessControl.ITTERUPT);
    }

    @Test
    public void testProcessRow_RowSizeEqualsCommitSize() throws Exception {
        this.transMeta.setSizeRowset(10);
        this.processRow(TransProcessControl.WAIT);
    }

    @Test
    public void testProcessRow_RowSizeLesserThanCommitSize() throws Exception {
        this.transMeta.setSizeRowset(5);
        this.processRow(TransProcessControl.WAIT);
    }

    private void processRow(TransProcessControl control) throws Exception {
        Trans trans = new Trans(this.transMeta);
        trans.prepareExecution(null);
        RowProducer rp = trans.addRowProducer(this.injectorStepname, 0);
        trans.startThreads();
        this.generateData(rp);
        rp.finished();
        StepInterface si = trans.getStepInterface(this.synchronizeAfterMergeStepname, 0);
        switch (control) {
            case ITTERUPT: {
                trans.stopAll();
                while (!si.getStatus().equals((Object)BaseStepData.StepExecutionStatus.STATUS_STOPPED)) {
                }
                break;
            }
            default: {
                trans.waitUntilFinished();
                Assert.assertEquals((String)"Step still started", (Object)BaseStepData.StepExecutionStatus.STATUS_FINISHED, (Object)si.getStatus());
            }
        }
        Assert.assertEquals((String)"Unexpected error occurred", (long)0L, (long)si.getErrors());
        Field field = SynchronizeAfterMerge.class.getDeclaredField("data");
        field.setAccessible(true);
        SynchronizeAfterMergeData data = (SynchronizeAfterMergeData)field.get(si);
        Assert.assertNull((Object)data.db.getConnection());
    }

    private void generateData(RowProducer rp) {
        int i;
        RowMeta rm = new RowMeta();
        rm.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaString("personName"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaString("flag"));
        for (i = 0; i < 18; ++i) {
            rp.putRow(rm.clone(), new Object[]{"personNameUpdated" + i, i, UPDATE_FLAG});
        }
        for (i = 18; i < 36; ++i) {
            rp.putRow(rm.clone(), new Object[]{"personName" + i, i, DELETE_FLAG});
        }
        for (i = 36; i < 54; ++i) {
            rp.putRow(rm.clone(), new Object[]{"personNameInserted" + i, i, INSERT_FLAG});
        }
    }

    private static enum TransProcessControl {
        WAIT,
        ITTERUPT;

    }
}

