/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.syslog;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.syslog.SyslogMessage;
import org.pentaho.di.trans.steps.syslog.SyslogMessageData;
import org.pentaho.di.trans.steps.syslog.SyslogMessageMeta;
import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogIF;

public class SyslogMessageTest {
    private StepMockHelper<SyslogMessageMeta, SyslogMessageData> stepMockHelper;

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<SyslogMessageMeta, SyslogMessageData>("SYSLOG_MESSAGE TEST", SyslogMessageMeta.class, SyslogMessageData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
    }

    @Test
    public void testDispose() throws Exception {
        SyslogMessageData data = new SyslogMessageData();
        SyslogIF syslog = (SyslogIF)Mockito.mock(SyslogIF.class);
        SyslogConfigIF syslogConfigIF = (SyslogConfigIF)Mockito.mock(SyslogConfigIF.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)syslog.getConfig()).thenReturn((Object)syslogConfigIF);
        final Boolean[] initialized = new Boolean[]{Boolean.FALSE};
        ((SyslogIF)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                initialized[0] = true;
                return initialized;
            }
        }).when((Object)syslog)).initialize(Mockito.anyString(), (SyslogConfigIF)Mockito.anyObject());
        ((SyslogIF)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                if (!initialized[0].booleanValue()) {
                    throw new NullPointerException("this.socket is null");
                }
                initialized[0] = false;
                return initialized;
            }
        }).when((Object)syslog)).shutdown();
        SyslogMessageMeta meta = new SyslogMessageMeta();
        SyslogMessage syslogMessage = new SyslogMessage(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        SyslogMessage sysLogMessageSpy = (SyslogMessage)Mockito.spy((Object)syslogMessage);
        Mockito.when((Object)sysLogMessageSpy.getSyslog()).thenReturn((Object)syslog);
        meta.setServerName("1");
        meta.setMessageFieldName("1");
        sysLogMessageSpy.init((StepMetaInterface)meta, (StepDataInterface)data);
        sysLogMessageSpy.dispose((StepMetaInterface)meta, (StepDataInterface)data);
    }
}

