/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.systemdata;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.trans.steps.systemdata.SystemDataMeta;
import org.pentaho.di.trans.steps.systemdata.SystemDataTypes;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SystemDataMetaTest {
    SystemDataMeta expectedSystemDataMeta;
    String expectedXML = "    <fields>\n      <field>\n        <name>hostname_real</name>\n        <type>Hostname real</type>\n        </field>\n      <field>\n        <name>hostname</name>\n        <type>Hostname</type>\n        </field>\n      </fields>\n";

    @Before
    public void setUp() throws Exception {
        this.expectedSystemDataMeta = new SystemDataMeta();
        this.expectedSystemDataMeta.allocate(2);
        String[] names = this.expectedSystemDataMeta.getFieldName();
        SystemDataTypes[] types = this.expectedSystemDataMeta.getFieldType();
        names[0] = "hostname_real";
        names[1] = "hostname";
        types[0] = SystemDataMeta.getType((String)SystemDataMeta.getTypeDesc((SystemDataTypes)SystemDataTypes.TYPE_SYSTEM_INFO_HOSTNAME_REAL));
        types[1] = SystemDataMeta.getType((String)SystemDataMeta.getTypeDesc((SystemDataTypes)SystemDataTypes.TYPE_SYSTEM_INFO_HOSTNAME));
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLoadXML() throws Exception {
        Document document;
        SystemDataMeta systemDataMeta = new SystemDataMeta();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document node = document = documentBuilder.parse(new InputSource(new StringReader(this.expectedXML)));
        IMetaStore store = null;
        systemDataMeta.loadXML((Node)node, null, store);
        Assert.assertEquals((Object)this.expectedSystemDataMeta, (Object)systemDataMeta);
    }

    @Test
    public void testGetXML() throws Exception {
        String generatedXML = this.expectedSystemDataMeta.getXML();
        Assert.assertEquals((Object)this.expectedXML.replaceAll("\n", "").replaceAll("\r", ""), (Object)generatedXML.replaceAll("\n", "").replaceAll("\r", ""));
    }
}

