/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileinput;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.playlist.FilePlayListAll;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.TransTestingUtil;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandler;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.textfileinput.TextFileFilter;
import org.pentaho.di.trans.steps.textfileinput.TextFileFilterProcessor;
import org.pentaho.di.trans.steps.textfileinput.TextFileInput;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputData;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputMeta;
import org.pentaho.di.utils.TestUtils;

public class TextFileInputTest {
    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    private static InputStreamReader getInputStreamReader(String data) throws UnsupportedEncodingException {
        return new InputStreamReader(new ByteArrayInputStream(data.getBytes("UTF-8")));
    }

    @Test
    public void testGetLineDOS() throws KettleFileException, UnsupportedEncodingException {
        String input = "col1\tcol2\tcol3\r\ndata1\tdata2\tdata3\r\n";
        String expected = "col1\tcol2\tcol3";
        String output = TextFileInput.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(input), (int)0, (StringBuilder)new StringBuilder(1000));
        Assert.assertEquals((Object)expected, (Object)output);
    }

    @Test
    public void testGetLineUnix() throws KettleFileException, UnsupportedEncodingException {
        String input = "col1\tcol2\tcol3\ndata1\tdata2\tdata3\n";
        String expected = "col1\tcol2\tcol3";
        String output = TextFileInput.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(input), (int)1, (StringBuilder)new StringBuilder(1000));
        Assert.assertEquals((Object)expected, (Object)output);
    }

    @Test
    public void testGetLineOSX() throws KettleFileException, UnsupportedEncodingException {
        String input = "col1\tcol2\tcol3\rdata1\tdata2\tdata3\r";
        String expected = "col1\tcol2\tcol3";
        String output = TextFileInput.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(input), (int)1, (StringBuilder)new StringBuilder(1000));
        Assert.assertEquals((Object)expected, (Object)output);
    }

    @Test
    public void testGetLineMixed() throws KettleFileException, UnsupportedEncodingException {
        String input = "col1\tcol2\tcol3\r\ndata1\tdata2\tdata3\r";
        String expected = "col1\tcol2\tcol3";
        String output = TextFileInput.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(input), (int)2, (StringBuilder)new StringBuilder(1000));
        Assert.assertEquals((Object)expected, (Object)output);
    }

    @Test(timeout=100L)
    public void test_PDI695() throws KettleFileException, UnsupportedEncodingException {
        String inputDOS = "col1\tcol2\tcol3\r\ndata1\tdata2\tdata3\r\n";
        String inputUnix = "col1\tcol2\tcol3\ndata1\tdata2\tdata3\n";
        String inputOSX = "col1\tcol2\tcol3\rdata1\tdata2\tdata3\r";
        String expected = "col1\tcol2\tcol3";
        Assert.assertEquals((Object)expected, (Object)TextFileInput.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(inputDOS), (int)1, (StringBuilder)new StringBuilder(1000)));
        Assert.assertEquals((Object)expected, (Object)TextFileInput.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(inputUnix), (int)1, (StringBuilder)new StringBuilder(1000)));
        Assert.assertEquals((Object)expected, (Object)TextFileInput.getLine(null, (InputStreamReader)TextFileInputTest.getInputStreamReader(inputOSX), (int)1, (StringBuilder)new StringBuilder(1000)));
    }

    @Test
    public void readWrappedInputWithoutHeaders() throws Exception {
        String content = "r1c1" + '\n' + ";r1c2\n" + "r2c1" + '\n' + ";r2c2";
        String virtualFile = TextFileInputTest.createVirtualFile("pdi-2607.txt", content);
        TextFileInputMeta meta = new TextFileInputMeta();
        meta.setLineWrapped(true);
        meta.setNrWraps(1);
        meta.setInputFields(new TextFileInputField[]{TextFileInputTest.field("col1"), TextFileInputTest.field("col2")});
        meta.setFileCompression("None");
        meta.setFileType("CSV");
        meta.setHeader(false);
        meta.setNrHeaderLines(-1);
        meta.setFooter(false);
        meta.setNrFooterLines(-1);
        TextFileInputData data = new TextFileInputData();
        data.setFiles(new FileInputList());
        data.getFiles().addFile(KettleVFS.getFileObject((String)virtualFile));
        data.outputRowMeta = new RowMeta();
        data.outputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("col1"));
        data.outputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("col2"));
        data.dataErrorLineHandler = (FileErrorHandler)Mockito.mock(FileErrorHandler.class);
        data.fileFormatType = 1;
        data.separator = ";";
        data.filterProcessor = new TextFileFilterProcessor(new TextFileFilter[0]);
        data.filePlayList = new FilePlayListAll();
        TextFileInput input = StepMockUtil.getStep(TextFileInput.class, TextFileInputMeta.class, "test");
        List<Object[]> output = TransTestingUtil.execute((BaseStep)input, (StepMetaInterface)meta, (StepDataInterface)data, 2, false);
        TransTestingUtil.assertResult(new Object[]{"r1c1", "r1c2"}, output.get(0));
        TransTestingUtil.assertResult(new Object[]{"r2c1", "r2c2"}, output.get(1));
        TextFileInputTest.deleteVfsFile(virtualFile);
    }

    @Test
    public void readInputWithMissedValues() throws Exception {
        String virtualFile = TextFileInputTest.createVirtualFile("pdi-14172.txt", "1,1,1\n", "2,,2\n");
        TextFileInputMeta meta = new TextFileInputMeta();
        TextFileInputField field2 = TextFileInputTest.field("col2");
        field2.setRepeated(true);
        meta.setInputFields(new TextFileInputField[]{TextFileInputTest.field("col1"), field2, TextFileInputTest.field("col3")});
        meta.setFileCompression("None");
        meta.setFileType("CSV");
        meta.setHeader(false);
        meta.setNrHeaderLines(-1);
        meta.setFooter(false);
        meta.setNrFooterLines(-1);
        TextFileInputData data = new TextFileInputData();
        data.setFiles(new FileInputList());
        data.getFiles().addFile(KettleVFS.getFileObject((String)virtualFile));
        data.outputRowMeta = new RowMeta();
        data.outputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("col1"));
        data.outputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("col2"));
        data.outputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("col3"));
        data.dataErrorLineHandler = (FileErrorHandler)Mockito.mock(FileErrorHandler.class);
        data.fileFormatType = 1;
        data.separator = ",";
        data.filterProcessor = new TextFileFilterProcessor(new TextFileFilter[0]);
        data.filePlayList = new FilePlayListAll();
        TextFileInput input = StepMockUtil.getStep(TextFileInput.class, TextFileInputMeta.class, "test");
        List<Object[]> output = TransTestingUtil.execute((BaseStep)input, (StepMetaInterface)meta, (StepDataInterface)data, 2, false);
        TransTestingUtil.assertResult(new Object[]{"1", "1", "1"}, output.get(0));
        TransTestingUtil.assertResult(new Object[]{"2", "1", "2"}, output.get(1));
        TextFileInputTest.deleteVfsFile(virtualFile);
    }

    @Test
    public void readInputWithDefaultValues() throws Exception {
        String virtualFile = TextFileInputTest.createVirtualFile("pdi-14832.txt", "1,\n");
        TextFileInputMeta meta = new TextFileInputMeta();
        TextFileInputField field2 = TextFileInputTest.field("col2");
        field2.setIfNullValue("DEFAULT");
        meta.setInputFields(new TextFileInputField[]{TextFileInputTest.field("col1"), field2});
        meta.setFileCompression("None");
        meta.setFileType("CSV");
        meta.setHeader(false);
        meta.setNrHeaderLines(-1);
        meta.setFooter(false);
        meta.setNrFooterLines(-1);
        TextFileInputData data = new TextFileInputData();
        data.setFiles(new FileInputList());
        data.getFiles().addFile(KettleVFS.getFileObject((String)virtualFile));
        data.outputRowMeta = new RowMeta();
        data.outputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("col1"));
        data.outputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("col2"));
        data.dataErrorLineHandler = (FileErrorHandler)Mockito.mock(FileErrorHandler.class);
        data.fileFormatType = 1;
        data.separator = ",";
        data.filterProcessor = new TextFileFilterProcessor(new TextFileFilter[0]);
        data.filePlayList = new FilePlayListAll();
        TextFileInput input = StepMockUtil.getStep(TextFileInput.class, TextFileInputMeta.class, "test");
        List<Object[]> output = TransTestingUtil.execute((BaseStep)input, (StepMetaInterface)meta, (StepDataInterface)data, 1, false);
        TransTestingUtil.assertResult(new Object[]{"1", "DEFAULT"}, output.get(0));
        TextFileInputTest.deleteVfsFile(virtualFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createVirtualFile(String filename, String ... rows) throws Exception {
        String virtualFile = TestUtils.createRamFile(filename);
        StringBuilder content = new StringBuilder();
        if (rows != null) {
            for (String row : rows) {
                content.append(row);
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(content.toString().getBytes());
        try (OutputStream os = KettleVFS.getFileObject((String)virtualFile).getContent().getOutputStream();){
            IOUtils.copy((InputStream)new ByteArrayInputStream(bos.toByteArray()), (OutputStream)os);
        }
        return virtualFile;
    }

    private static void deleteVfsFile(String path) throws Exception {
        TestUtils.getFileObject(path).delete();
    }

    private static TextFileInputField field(String name) {
        return new TextFileInputField(name, -1, -1);
    }
}

