/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileoutput;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.compress.CompressionOutputStream;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;
import org.pentaho.di.utils.TestUtils;

public class TextFileOutputTest {
    private static final String EMPTY_FILE_NAME = "Empty File";
    private static final String EMPTY_STRING = "";
    private static final String TEXT_FILE_OUTPUT_PREFIX = "textFileOutput";
    private static final String TEXT_FILE_OUTPUT_EXTENSION = ".txt";
    private static final String END_LINE = " endLine ";
    private static final String RESULT_ROWS = "\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n";
    private static final String TEST_PREVIOUS_DATA = "testPreviousData\n";
    private StepMockHelper<TextFileOutputMeta, TextFileOutputData> stepMockHelper;
    private TextFileField textFileField = new TextFileField("Name", 2, "", 10, 20, "", "", "", "");
    private TextFileField textFileField2 = new TextFileField("Surname", 2, "", 10, 20, "", "", "", "");
    private TextFileField[] textFileFields = new TextFileField[]{this.textFileField, this.textFileField2};
    private Object[] row = new Object[]{"some data", "another data"};
    private Object[] row2 = new Object[]{"some data2", "another data2"};
    private List<Object[]> emptyRows = new ArrayList<Object[]>();
    private List<Object[]> rows = new ArrayList<Object[]>();
    private List<String> contents = new ArrayList<String>();
    private TextFileOutput textFileOutput;

    public TextFileOutputTest() {
        this.rows.add(this.row);
        this.rows.add(this.row2);
        this.contents.add(EMPTY_STRING);
        this.contents.add(EMPTY_STRING);
        this.contents.add(END_LINE);
        this.contents.add(END_LINE);
        this.contents.add(null);
        this.contents.add(null);
        this.contents.add(END_LINE);
        this.contents.add(END_LINE);
        this.contents.add(RESULT_ROWS);
        this.contents.add(RESULT_ROWS);
        this.contents.add("\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add("\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add(RESULT_ROWS);
        this.contents.add(RESULT_ROWS);
        this.contents.add("\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add("\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add(EMPTY_STRING);
        this.contents.add(TEST_PREVIOUS_DATA);
        this.contents.add(END_LINE);
        this.contents.add("testPreviousData\n endLine ");
        this.contents.add(TEST_PREVIOUS_DATA);
        this.contents.add(TEST_PREVIOUS_DATA);
        this.contents.add(END_LINE);
        this.contents.add("testPreviousData\n endLine ");
        this.contents.add(RESULT_ROWS);
        this.contents.add("testPreviousData\n\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n");
        this.contents.add("\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add("testPreviousData\n\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add(RESULT_ROWS);
        this.contents.add("testPreviousData\n\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n");
        this.contents.add("\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add("testPreviousData\n\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
        PluginRegistry.init((boolean)true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<TextFileOutputMeta, TextFileOutputData>("TEXT FILE OUTPUT TEST", TextFileOutputMeta.class, TextFileOutputData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Matchers.anyString());
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Matchers.anyString(), new Object[]{Matchers.anyObject()});
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Matchers.anyString(), (Throwable)Matchers.anyObject());
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
        ((Trans)Mockito.verify((Object)this.stepMockHelper.trans, (VerificationMode)Mockito.never())).stopAll();
        ((TextFileOutputData)this.stepMockHelper.stepDataInterface).previouslyOpenedFiles = new ArrayList();
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getSeparator()).thenReturn((Object)" ");
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getEnclosure()).thenReturn((Object)"\"");
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getNewline()).thenReturn((Object)"\n");
        Mockito.when((Object)this.stepMockHelper.transMeta.listVariables()).thenReturn((Object)new String[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testCloseFileDataOutIsNullCase() {
        this.textFileOutput = new TextFileOutput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        this.textFileOutput.data = (TextFileOutputData)Mockito.mock(TextFileOutputData.class);
        junit.framework.Assert.assertNull((Object)this.textFileOutput.data.out);
        this.textFileOutput.closeFile();
    }

    @Test
    public void testCloseFileDataOutIsNotNullCase() throws IOException {
        this.textFileOutput = new TextFileOutput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        this.textFileOutput.data = (TextFileOutputData)Mockito.mock(TextFileOutputData.class);
        this.textFileOutput.data.out = (CompressionOutputStream)Mockito.mock(CompressionOutputStream.class);
        this.textFileOutput.closeFile();
        ((CompressionOutputStream)Mockito.verify((Object)this.textFileOutput.data.out, (VerificationMode)Mockito.times((int)1))).close();
    }

    private FileObject createTemplateFile() throws IOException {
        String path = TestUtils.createRamFile(this.getClass().getSimpleName() + "/" + TEXT_FILE_OUTPUT_PREFIX + new Random().nextLong() + TEXT_FILE_OUTPUT_EXTENSION);
        return TestUtils.getFileObject(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject createTemplateFile(String content) throws IOException {
        FileObject f2 = this.createTemplateFile();
        if (content == null) {
            f2.delete();
        } else {
            try (OutputStreamWriter fw = null;){
                fw = new OutputStreamWriter(f2.getContent().getOutputStream());
                fw.write(content);
            }
        }
        return f2;
    }

    @Test
    public void testsIterate() {
        FileObject resultFile = null;
        String content = null;
        Boolean[] bool = new Boolean[]{false, true};
        int i = 0;
        for (Boolean fileExists : bool) {
            for (Boolean dataReceived : bool) {
                for (Boolean isDoNotOpenNewFileInit : bool) {
                    for (Boolean endLineExists : bool) {
                        for (Boolean append : bool) {
                            try {
                                resultFile = this.helpTestInit(fileExists, dataReceived, isDoNotOpenNewFileInit, endLineExists, append);
                                content = (String)this.contents.toArray()[i++];
                                FileObject contentFile = this.createTemplateFile(content);
                                if (resultFile.exists()) {
                                    Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)resultFile.getContent().getInputStream(), (InputStream)contentFile.getContent().getInputStream()));
                                    continue;
                                }
                                Assert.assertFalse((boolean)contentFile.exists());
                            }
                            catch (Exception e) {
                                junit.framework.Assert.fail((String)(e.getMessage() + "\n FileExists = " + fileExists + "\n DataReceived = " + dataReceived + "\n isDoNotOpenNewFileInit = " + isDoNotOpenNewFileInit + "\n EndLineExists = " + endLineExists + "\n Append = " + append + "\n Content = " + content + "\n resultFile = " + resultFile));
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testNoOpenFileCall_IfRule_1() throws KettleException {
        TextFileField tfFieldMock = (TextFileField)Mockito.mock(TextFileField.class);
        TextFileField[] textFileFields = new TextFileField[]{tfFieldMock};
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.initStepMetaInterface).getEndedLine()).thenReturn((Object)EMPTY_STRING);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.initStepMetaInterface).getOutputFields()).thenReturn((Object)textFileFields);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.initStepMetaInterface).isDoNotOpenNewFileInit()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getEndedLine()).thenReturn((Object)EMPTY_STRING);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getFileName()).thenReturn((Object)EMPTY_FILE_NAME);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isDoNotOpenNewFileInit()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getOutputFields()).thenReturn((Object)textFileFields);
        Mockito.when((Object)((TextFileOutputData)this.stepMockHelper.processRowsStepDataInterface).getPreviouslyOpenedFiles()).thenReturn(new ArrayList());
        this.textFileOutput = new TextFileOutput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        TextFileOutput textFileoutputSpy = (TextFileOutput)Mockito.spy((Object)this.textFileOutput);
        ((TextFileOutput)Mockito.doNothing().when((Object)textFileoutputSpy)).openNewFile(EMPTY_FILE_NAME);
        textFileoutputSpy.init(this.stepMockHelper.initStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        textFileoutputSpy.processRow(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        ((TextFileOutput)Mockito.verify((Object)textFileoutputSpy, (VerificationMode)Mockito.never())).openNewFile(EMPTY_FILE_NAME);
        ((TextFileOutput)Mockito.verify((Object)textFileoutputSpy, (VerificationMode)Mockito.never())).writeEndedLine();
        ((TextFileOutput)Mockito.verify((Object)textFileoutputSpy)).setOutputDone();
    }

    private FileObject helpTestInit(Boolean fileExists, Boolean dataReceived, Boolean isDoNotOpenNewFileInit, Boolean endLineExists, Boolean append) throws Exception {
        List<Throwable> errors;
        String endLine = null;
        FileObject f = fileExists != false ? this.createTemplateFile(TEST_PREVIOUS_DATA) : this.createTemplateFile(null);
        List<Object[]> rows = dataReceived != false ? this.rows : this.emptyRows;
        if (endLineExists.booleanValue()) {
            endLine = END_LINE;
        }
        if (!(errors = this.doOutput(this.textFileFields, rows, f.getName().getURI(), endLine, false, isDoNotOpenNewFileInit, append)).isEmpty()) {
            StringBuilder str = new StringBuilder();
            for (Throwable thr : errors) {
                str.append(thr);
            }
            junit.framework.Assert.fail((String)str.toString());
        }
        return f;
    }

    private List<Throwable> doOutput(TextFileField[] textFileField, List<Object[]> rows, String pathToFile, String endedLine, Boolean isHeaderEnabled, Boolean isDoNotOpenNewFileInit, Boolean append) throws KettleException {
        int i;
        TextFileOutputData textFileOutputData = new TextFileOutputData();
        TextFileOutputTestHandler textFileOutput = new TextFileOutputTestHandler(this.stepMockHelper.stepMeta, (StepDataInterface)textFileOutputData, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isDoNotOpenNewFileInit()).thenReturn((Object)isDoNotOpenNewFileInit);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isFileAppended()).thenReturn((Object)append);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isHeaderEnabled()).thenReturn((Object)isHeaderEnabled);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getFileName()).thenReturn((Object)pathToFile);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).buildFilename(Matchers.anyString(), Matchers.anyString(), (VariableSpace)Matchers.anyObject(), Matchers.anyInt(), Matchers.anyString(), Matchers.anyInt(), Matchers.anyBoolean(), (TextFileOutputMeta)Matchers.anyObject())).thenReturn((Object)pathToFile);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getOutputFields()).thenReturn((Object)textFileField);
        textFileOutput.init((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)textFileOutputData);
        RowSet rowSet = this.stepMockHelper.getMockInputRowSet(rows);
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        textFileOutput.setInputRowMeta(inputRowMeta);
        Mockito.when((Object)rowSet.getRowWait((long)Matchers.anyInt(), (TimeUnit)((Object)Matchers.anyObject()))).thenReturn(rows.isEmpty() ? null : rows.iterator().next());
        Mockito.when((Object)rowSet.getRowMeta()).thenReturn((Object)inputRowMeta);
        Mockito.when((Object)inputRowMeta.clone()).thenReturn((Object)inputRowMeta);
        for (i = 0; i < textFileField.length; ++i) {
            String name = textFileField[i].getName();
            Mockito.when((Object)inputRowMeta.getValueMeta(i)).thenReturn((Object)new ValueMetaString(name));
            Mockito.when((Object)inputRowMeta.indexOfValue(name)).thenReturn((Object)i);
        }
        textFileOutput.getInputRowSets().add(rowSet);
        textFileOutput.getOutputRowSets().add(rowSet);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getEndedLine()).thenReturn((Object)endedLine);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isFastDump()).thenReturn((Object)true);
        for (i = 0; i < rows.size(); ++i) {
            textFileOutput.setRow(rows.get(i));
            textFileOutput.processRow((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)textFileOutputData);
        }
        textFileOutput.setRow(null);
        textFileOutput.processRow((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)textFileOutputData);
        textFileOutput.dispose((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)textFileOutputData);
        return textFileOutput.errors;
    }

    @Test
    public void containsSeparatorOrEnclosureIsNotUnnecessaryInvoked_SomeFieldsFromMeta() {
        TextFileField field = new TextFileField();
        field.setName("name");
        this.assertNotInvokedTwice(field);
    }

    @Test
    public void containsSeparatorOrEnclosureIsNotUnnecessaryInvoked_AllFieldsFromMeta() {
        this.assertNotInvokedTwice(null);
    }

    private void assertNotInvokedTwice(TextFileField field) {
        TextFileOutput step = new TextFileOutput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 1, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        TextFileOutputMeta meta = new TextFileOutputMeta();
        meta.setEnclosureForced(false);
        meta.setEnclosureFixDisabled(false);
        step.meta = meta;
        TextFileOutputData data = new TextFileOutputData();
        data.binarySeparator = " ".getBytes();
        data.binaryEnclosure = "\"".getBytes();
        data.binaryNewline = "\n".getBytes();
        step.data = data;
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("name"));
        data.outputRowMeta = rowMeta;
        data.writer = new ByteArrayOutputStream();
        if (field != null) {
            meta.setOutputFields(new TextFileField[]{field});
        }
        step = (TextFileOutput)Mockito.spy((Object)step);
        step.writeHeader();
        ((TextFileOutput)Mockito.verify((Object)step)).containsSeparatorOrEnclosure((byte[])Matchers.any(byte[].class), (byte[])Matchers.any(byte[].class), (byte[])Matchers.any(byte[].class));
    }

    private class TextFileOutputTestHandler
    extends TextFileOutput {
        public List<Throwable> errors;
        private Object[] row;

        public TextFileOutputTestHandler(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
            this.errors = new ArrayList<Throwable>();
        }

        public void setRow(Object[] row) {
            this.row = row;
        }

        public Object[] getRow() throws KettleException {
            return this.row;
        }

        public boolean checkPreviouslyOpened(String filename) {
            return false;
        }

        public void putRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        }

        public void logError(String message) {
            this.errors.add(new KettleException(message));
        }

        public void logError(String message, Throwable thr) {
            this.errors.add(thr);
        }

        public void logError(String message, Object ... arguments) {
            this.errors.add(new KettleException(message));
        }
    }
}

