/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.transexecutor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;

public class TransExecutorMetaTest {
    LoadSaveTester loadSaveTester;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)ValueMetaPluginType.getInstance());
        PluginRegistry.init((boolean)true);
    }

    @Before
    public void setUp() throws Exception {
        List<String> attributes = Arrays.asList("fileName", "transName", "directoryPath", "groupSize", "groupField", "groupTime", "executionTimeField", "executionFilesRetrievedField", "executionLogTextField", "executionLogChannelIdField", "executionResultField", "executionNrErrorsField", "executionLinesReadField", "executionLinesWrittenField", "executionLinesInputField", "executionLinesOutputField", "executionLinesRejectedField", "executionLinesUpdatedField", "executionLinesDeletedField", "executionExitStatusField", "outputRowsField", "outputRowsType", "outputRowsLength", "outputRowsPrecision");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        HashMap attrValidatorMap = new HashMap();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 1);
        IntLoadSaveValidator intValidator = (IntLoadSaveValidator)Mockito.spy((Object)new IntLoadSaveValidator());
        ((IntLoadSaveValidator)Mockito.doReturn((Object)5).when((Object)intValidator)).getTestObject();
        PrimitiveIntArrayLoadSaveValidator intArrayLoadSaveValidator = new PrimitiveIntArrayLoadSaveValidator(intValidator, 1);
        attrValidatorMap.put("outputRowsField", stringArrayLoadSaveValidator);
        attrValidatorMap.put("outputRowsType", intArrayLoadSaveValidator);
        attrValidatorMap.put("outputRowsLength", intArrayLoadSaveValidator);
        attrValidatorMap.put("outputRowsPrecision", intArrayLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        typeValidatorMap.put(int[].class.getCanonicalName(), new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(), 1));
        this.loadSaveTester = new LoadSaveTester(TransExecutorMeta.class, attributes, getterMap, setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testLoadSaveXML() throws KettleException {
        this.loadSaveTester.testXmlRoundTrip();
    }

    @Test
    public void testLoadSaveRepo() throws KettleException {
        this.loadSaveTester.testRepoRoundTrip();
    }

    @Test
    public void firstStreamIsExecutionStatistics() throws Exception {
        StreamInterface stream = TransExecutorMetaTest.mockStream();
        StepIOMetaInterface stepIo = TransExecutorMetaTest.mockStepIo(stream, 0);
        TransExecutorMeta meta = new TransExecutorMeta();
        meta = (TransExecutorMeta)Mockito.spy((Object)meta);
        Mockito.when((Object)meta.getStepIOMeta()).thenReturn((Object)stepIo);
        ((TransExecutorMeta)Mockito.doCallRealMethod().when((Object)meta)).handleStreamSelection((StreamInterface)Mockito.any(StreamInterface.class));
        meta.handleStreamSelection(stream);
        Assert.assertEquals((Object)stream.getStepMeta(), (Object)meta.getExecutionResultTargetStepMeta());
    }

    @Test
    public void secondStreamIsInternalTransformationsOutput() throws Exception {
        StreamInterface stream = TransExecutorMetaTest.mockStream();
        StepIOMetaInterface stepIo = TransExecutorMetaTest.mockStepIo(stream, 1);
        TransExecutorMeta meta = new TransExecutorMeta();
        meta = (TransExecutorMeta)Mockito.spy((Object)meta);
        Mockito.when((Object)meta.getStepIOMeta()).thenReturn((Object)stepIo);
        ((TransExecutorMeta)Mockito.doCallRealMethod().when((Object)meta)).handleStreamSelection((StreamInterface)Mockito.any(StreamInterface.class));
        meta.handleStreamSelection(stream);
        Assert.assertEquals((Object)stream.getStepMeta(), (Object)meta.getOutputRowsSourceStepMeta());
    }

    @Test
    public void thirdStreamIsExecutionResultFiles() throws Exception {
        StreamInterface stream = TransExecutorMetaTest.mockStream();
        StepIOMetaInterface stepIo = TransExecutorMetaTest.mockStepIo(stream, 2);
        TransExecutorMeta meta = new TransExecutorMeta();
        meta = (TransExecutorMeta)Mockito.spy((Object)meta);
        Mockito.when((Object)meta.getStepIOMeta()).thenReturn((Object)stepIo);
        ((TransExecutorMeta)Mockito.doCallRealMethod().when((Object)meta)).handleStreamSelection((StreamInterface)Mockito.any(StreamInterface.class));
        meta.handleStreamSelection(stream);
        Assert.assertEquals((Object)stream.getStepMeta(), (Object)meta.getResultFilesTargetStepMeta());
    }

    @Test
    public void forthStreamIsExecutorsInput() throws Exception {
        StreamInterface stream = TransExecutorMetaTest.mockStream();
        StepIOMetaInterface stepIo = TransExecutorMetaTest.mockStepIo(stream, 3);
        TransExecutorMeta meta = new TransExecutorMeta();
        meta = (TransExecutorMeta)Mockito.spy((Object)meta);
        Mockito.when((Object)meta.getStepIOMeta()).thenReturn((Object)stepIo);
        ((TransExecutorMeta)Mockito.doCallRealMethod().when((Object)meta)).handleStreamSelection((StreamInterface)Mockito.any(StreamInterface.class));
        meta.handleStreamSelection(stream);
        Assert.assertEquals((Object)stream.getStepMeta(), (Object)meta.getExecutorsOutputStepMeta());
    }

    @Test
    public void testPrepareExecutionResultsFields() throws Exception {
        TransExecutorMeta meta = new TransExecutorMeta();
        meta = (TransExecutorMeta)Mockito.spy((Object)meta);
        RowMetaInterface row = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        StepMeta nextStep = (StepMeta)Mockito.mock(StepMeta.class);
        meta.setExecutionResultTargetStepMeta(nextStep);
        meta.setExecutionTimeField("time");
        StepMeta parent = (StepMeta)Mockito.mock(StepMeta.class);
        ((TransExecutorMeta)Mockito.doReturn((Object)parent).when((Object)meta)).getParentStepMeta();
        Mockito.when((Object)parent.getName()).thenReturn((Object)"parent step");
        meta.prepareExecutionResultsFields(row, nextStep);
        ((StepMeta)Mockito.verify((Object)parent)).getName();
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)row)).addValueMeta((ValueMetaInterface)argumentCaptor.capture());
        Assert.assertEquals((Object)"parent step", (Object)((ValueMetaInterface)argumentCaptor.getValue()).getOrigin());
    }

    @Test
    public void testPrepareExecutionResultsFileFields() throws Exception {
        TransExecutorMeta meta = new TransExecutorMeta();
        meta = (TransExecutorMeta)Mockito.spy((Object)meta);
        RowMetaInterface row = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        StepMeta nextStep = (StepMeta)Mockito.mock(StepMeta.class);
        meta.setResultFilesTargetStepMeta(nextStep);
        meta.setResultFilesFileNameField("file_name");
        StepMeta parent = (StepMeta)Mockito.mock(StepMeta.class);
        ((TransExecutorMeta)Mockito.doReturn((Object)parent).when((Object)meta)).getParentStepMeta();
        Mockito.when((Object)parent.getName()).thenReturn((Object)"parent step");
        meta.prepareExecutionResultsFileFields(row, nextStep);
        ((StepMeta)Mockito.verify((Object)parent)).getName();
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)row)).addValueMeta((ValueMetaInterface)argumentCaptor.capture());
        Assert.assertEquals((Object)"parent step", (Object)((ValueMetaInterface)argumentCaptor.getValue()).getOrigin());
    }

    @Test
    public void testPrepareResultsRowsFields() throws Exception {
        TransExecutorMeta meta = new TransExecutorMeta();
        String[] outputFieldNames = new String[]{"one", "two"};
        int[] outputFieldTypes = new int[]{0, 1};
        int[] outputFieldLength = new int[]{4, 8};
        int[] outputFieldPrecision = new int[]{2, 4};
        meta.setOutputRowsField(outputFieldNames);
        meta.setOutputRowsType(outputFieldTypes);
        meta.setOutputRowsLength(outputFieldLength);
        meta.setOutputRowsPrecision(outputFieldPrecision);
        meta = (TransExecutorMeta)Mockito.spy((Object)meta);
        RowMetaInterface row = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        StepMeta parent = (StepMeta)Mockito.mock(StepMeta.class);
        ((TransExecutorMeta)Mockito.doReturn((Object)parent).when((Object)meta)).getParentStepMeta();
        Mockito.when((Object)parent.getName()).thenReturn((Object)"parent step");
        meta.prepareResultsRowsFields(row);
        ((StepMeta)Mockito.verify((Object)parent, (VerificationMode)Mockito.times((int)outputFieldNames.length))).getName();
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)row, (VerificationMode)Mockito.times((int)outputFieldNames.length))).addValueMeta((ValueMetaInterface)argumentCaptor.capture());
        Assert.assertEquals((Object)"parent step", (Object)((ValueMetaInterface)argumentCaptor.getValue()).getOrigin());
    }

    @Test
    public void testGetFields() throws Exception {
        TransExecutorMeta meta = new TransExecutorMeta();
        meta = (TransExecutorMeta)Mockito.spy((Object)meta);
        StepMeta nextStep = (StepMeta)Mockito.mock(StepMeta.class);
        meta.getFields(null, null, null, nextStep, null, null, null);
        ((TransExecutorMeta)Mockito.verify((Object)meta, (VerificationMode)Mockito.never())).addFieldToRow((RowMetaInterface)Mockito.any(RowMetaInterface.class), Mockito.anyString(), Mockito.anyInt());
        RowMetaInterface rowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        meta.getFields(rowMeta, null, null, nextStep, null, null, null);
        ((RowMetaInterface)Mockito.verify((Object)rowMeta, (VerificationMode)Mockito.never())).clear();
        StepMeta executionResultTargetStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        meta.setExecutionResultTargetStepMeta(executionResultTargetStepMeta);
        meta.getFields(rowMeta, null, null, nextStep, null, null, null);
        ((RowMetaInterface)Mockito.verify((Object)rowMeta, (VerificationMode)Mockito.atMost((int)1))).clear();
        meta.setExecutionResultTargetStepMeta(null);
        StepMeta resultFilesTargetStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        meta.setResultFilesTargetStepMeta(resultFilesTargetStepMeta);
        meta.getFields(rowMeta, null, null, nextStep, null, null, null);
        ((RowMetaInterface)Mockito.verify((Object)rowMeta, (VerificationMode)Mockito.atMost((int)1))).clear();
        meta.setResultFilesTargetStepMeta(null);
        StepMeta outputRowsSourceStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        meta.setOutputRowsSourceStepMeta(outputRowsSourceStepMeta);
        meta.getFields(rowMeta, null, null, nextStep, null, null, null);
        ((RowMetaInterface)Mockito.verify((Object)rowMeta, (VerificationMode)Mockito.atMost((int)1))).clear();
        meta.setOutputRowsSourceStepMeta(null);
    }

    @Test
    public void testClone() throws Exception {
        TransExecutorMeta meta = new TransExecutorMeta();
        meta.setOutputRowsField(new String[]{"field1", "field2"});
        meta.setOutputRowsLength(new int[]{5, 5});
        meta.setOutputRowsPrecision(new int[]{5, 5});
        meta.setOutputRowsType(new int[]{0, 0});
        TransExecutorMeta cloned = (TransExecutorMeta)meta.clone();
        Assert.assertFalse((cloned.getOutputRowsField() == meta.getOutputRowsField() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(cloned.getOutputRowsField(), meta.getOutputRowsField()));
        Assert.assertFalse((cloned.getOutputRowsLength() == meta.getOutputRowsLength() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(cloned.getOutputRowsLength(), meta.getOutputRowsLength()));
        Assert.assertFalse((cloned.getOutputRowsPrecision() == meta.getOutputRowsPrecision() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(cloned.getOutputRowsPrecision(), meta.getOutputRowsPrecision()));
        Assert.assertFalse((cloned.getOutputRowsType() == meta.getOutputRowsType() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(cloned.getOutputRowsType(), meta.getOutputRowsType()));
    }

    private static StepIOMetaInterface mockStepIo(StreamInterface stream, int desiredIndex) {
        List list = (List)Mockito.mock(List.class);
        Mockito.when((Object)list.indexOf(stream)).thenReturn((Object)desiredIndex);
        Mockito.when(list.get(Mockito.eq((int)desiredIndex))).thenReturn((Object)stream);
        StepIOMetaInterface stepIo = (StepIOMetaInterface)Mockito.mock(StepIOMetaInterface.class);
        Mockito.when((Object)stepIo.getTargetStreams()).thenReturn((Object)list);
        return stepIo;
    }

    private static StreamInterface mockStream() {
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        StreamInterface stream = (StreamInterface)Mockito.mock(StreamInterface.class);
        Mockito.when((Object)stream.getStepMeta()).thenReturn((Object)stepMeta);
        return stream;
    }
}

