/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.transexecutor;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;

public class TransExecutorMeta_GetFields_Test {
    private TransExecutorMeta meta;
    private StepMeta executionResult;
    private StepMeta resultFiles;
    private StepMeta outputRows;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)ValueMetaPluginType.getInstance());
        PluginRegistry.init((boolean)true);
    }

    @Before
    public void setUp() {
        this.executionResult = (StepMeta)Mockito.mock(StepMeta.class);
        this.resultFiles = (StepMeta)Mockito.mock(StepMeta.class);
        this.outputRows = (StepMeta)Mockito.mock(StepMeta.class);
        this.meta = new TransExecutorMeta();
        this.meta.setExecutionResultTargetStepMeta(this.executionResult);
        this.meta.setResultFilesTargetStepMeta(this.resultFiles);
        this.meta.setOutputRowsSourceStepMeta(this.outputRows);
        this.meta.setExecutionTimeField("executionTime");
        this.meta.setExecutionResultField("true");
        this.meta.setExecutionNrErrorsField("1");
        this.meta.setResultFilesFileNameField("resultFileName");
        this.meta.setOutputRowsField(new String[]{"outputRow"});
        this.meta.setOutputRowsType(new int[]{0});
        this.meta.setOutputRowsLength(new int[]{0});
        this.meta.setOutputRowsPrecision(new int[]{0});
        this.meta = (TransExecutorMeta)Mockito.spy((Object)this.meta);
        StepMeta parent = (StepMeta)Mockito.mock(StepMeta.class);
        ((TransExecutorMeta)Mockito.doReturn((Object)parent).when((Object)this.meta)).getParentStepMeta();
        Mockito.when((Object)parent.getName()).thenReturn((Object)"parent step");
    }

    @Test
    public void getFieldsForExecutionResults() throws Exception {
        RowMetaInterface mock = this.invokeGetFieldsWith(this.executionResult);
        ((RowMetaInterface)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)3))).addValueMeta((ValueMetaInterface)Mockito.any(ValueMeta.class));
    }

    @Test
    public void getFieldsForResultFiles() throws Exception {
        RowMetaInterface mock = this.invokeGetFieldsWith(this.resultFiles);
        ((RowMetaInterface)Mockito.verify((Object)mock)).addValueMeta((ValueMetaInterface)Mockito.any(ValueMeta.class));
    }

    @Test
    public void getFieldsForInternalTransformationOutputRows() throws Exception {
        RowMetaInterface mock = this.invokeGetFieldsWith(this.outputRows);
        ((RowMetaInterface)Mockito.verify((Object)mock)).addValueMeta((ValueMetaInterface)Mockito.any(ValueMeta.class));
    }

    private RowMetaInterface invokeGetFieldsWith(StepMeta stepMeta) throws Exception {
        RowMetaInterface rowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        this.meta.getFields(rowMeta, "", null, stepMeta, null, null, null);
        return rowMeta;
    }
}

