/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.validator;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.validator.Validation;
import org.pentaho.di.trans.steps.validator.Validator;
import org.pentaho.di.trans.steps.validator.ValidatorData;
import org.pentaho.di.trans.steps.validator.ValidatorMeta;

public class ValidatorTest {
    private Validator validator;
    private StepMockHelper<ValidatorMeta, ValidatorData> mockHelper;

    @Before
    public void setUp() throws Exception {
        this.mockHelper = new StepMockHelper<ValidatorMeta, ValidatorData>("Validator", ValidatorMeta.class, ValidatorData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        Mockito.when((Object)this.mockHelper.trans.isRunning()).thenReturn((Object)true);
        this.validator = (Validator)Mockito.spy((Object)new Validator(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans));
    }

    @Test
    public void testPatternExpectedCompile() throws KettlePluginException {
        ValidatorData data = new ValidatorData();
        ValidatorMeta meta = new ValidatorMeta();
        data.regularExpression = new String[1];
        data.regularExpressionNotAllowed = new String[1];
        data.patternExpected = new Pattern[1];
        data.patternDisallowed = new Pattern[1];
        Validation v = new Validation();
        v.setFieldName("field");
        v.setDataType(1);
        v.setRegularExpression("${param}");
        v.setRegularExpressionNotAllowed("${param}");
        meta.setValidations(Collections.singletonList(v));
        this.validator.setVariable("param", "^(((0[1-9]|[12]\\d|3[01])\\/(0[13578]|1[02])\\/((1[6-9]|[2-9]\\d)\\d{2}))|((0[1-9]|[12]\\d|30)\\/(0[13456789]|1[012])\\/((1[6-9]|[2-9]\\d)\\d{2}))|((0[1-9]|1\\d|2[0-8])\\/02\\/((1[6-9]|[2-9]\\d)\\d{2}))|(29\\/02\\/((1[6-9]|[2-9]\\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))))$");
        ((Validator)Mockito.doReturn((Object)new ValueMetaString("field")).when((Object)this.validator)).createValueMeta(Matchers.anyString(), Matchers.anyInt());
        ((Validator)Mockito.doReturn((Object)new ValueMetaString("field")).when((Object)this.validator)).cloneValueMeta((ValueMetaInterface)Matchers.anyObject(), Matchers.anyInt());
        this.validator.init((StepMetaInterface)meta, (StepDataInterface)data);
    }

    @Test
    public void assertNumeric_Integer() throws Exception {
        this.assertNumericForNumberMeta((ValueMetaInterface)new ValueMetaInteger("int"), 1L);
    }

    @Test
    public void assertNumeric_Number() throws Exception {
        this.assertNumericForNumberMeta((ValueMetaInterface)new ValueMetaNumber("number"), 1.0);
    }

    @Test
    public void assertNumeric_BigNumber() throws Exception {
        this.assertNumericForNumberMeta((ValueMetaInterface)new ValueMetaBigNumber("big-number"), BigDecimal.ONE);
    }

    private void assertNumericForNumberMeta(ValueMetaInterface numeric, Object data) throws Exception {
        Assert.assertTrue((boolean)numeric.isNumeric());
        Assert.assertNull((Object)this.validator.assertNumeric(numeric, data, new Validation()));
    }

    @Test
    public void assertNumeric_StringWithDigits() throws Exception {
        ValueMetaString metaString = new ValueMetaString("string-with-digits");
        Assert.assertNull((String)"Strings with digits are allowed", (Object)this.validator.assertNumeric((ValueMetaInterface)metaString, (Object)"123", new Validation()));
    }

    @Test
    public void assertNumeric_String() throws Exception {
        ValueMetaString metaString = new ValueMetaString("string");
        Assert.assertNotNull((String)"General strings are not allowed", (Object)this.validator.assertNumeric((ValueMetaInterface)metaString, (Object)"qwerty", new Validation()));
    }
}

