/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebServer;

public class WebServerTest {
    private static final String EMPTY_STRING = "";
    private static final boolean SHOULD_JOIN = false;
    private static final String HOST_NAME = "localhost";
    private static final int PORT = 8099;
    private static final String ACCEPTORS = "5";
    private static final int EXPECTED_ACCEPTORS = 5;
    private static final String ACCEPT_QUEUE_SIZE = "5000";
    private static final int EXPECTED_ACCEPT_QUEUE_SIZE = 5000;
    private static final String RES_MAX_IDLE_TIME = "200";
    private static final int EXPECTED_RES_MAX_IDLE_TIME = 200;
    private static final int EXPECTED_CONNECTORS_SIZE = 1;
    private WebServer webServer;
    private WebServer webServerNg;
    private TransformationMap trMapMock = (TransformationMap)Mockito.mock(TransformationMap.class);
    private SlaveServerConfig sServerConfMock = (SlaveServerConfig)Mockito.mock(SlaveServerConfig.class);
    private SlaveServer sServer = (SlaveServer)Mockito.mock(SlaveServer.class);
    private JobMap jbMapMock = (JobMap)Mockito.mock(JobMap.class);
    private SocketRepository sRepoMock = (SocketRepository)Mockito.mock(SocketRepository.class);
    private List<SlaveServerDetection> detections = new ArrayList<SlaveServerDetection>();
    private LogChannelInterface logMock = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
    private static final SocketConnector defSocketConnector = new SocketConnector();

    @Before
    public void setup() throws Exception {
        System.setProperty("KETTLE_CARTE_JETTY_ACCEPTORS", ACCEPTORS);
        System.setProperty("KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE", ACCEPT_QUEUE_SIZE);
        System.setProperty("KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME", RES_MAX_IDLE_TIME);
        Mockito.when((Object)this.sServerConfMock.getSlaveServer()).thenReturn((Object)this.sServer);
        Mockito.when((Object)this.trMapMock.getSlaveServerConfig()).thenReturn((Object)this.sServerConfMock);
        Mockito.when((Object)this.sServer.getPassword()).thenReturn((Object)"cluster");
        Mockito.when((Object)this.sServer.getUsername()).thenReturn((Object)"cluster");
        this.webServer = new WebServer(this.logMock, this.trMapMock, this.jbMapMock, this.sRepoMock, this.detections, HOST_NAME, 8099, false, null);
    }

    @After
    public void tearDown() {
        this.webServer.setWebServerShutdownHandler(null);
        this.webServer.stopServer();
        System.getProperties().remove("KETTLE_CARTE_JETTY_ACCEPTORS");
        System.getProperties().remove("KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE");
        System.getProperties().remove("KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME");
    }

    @Test
    public void testJettyOption_AcceptorsSetUp() throws Exception {
        Assert.assertEquals((long)this.getSocketConnectors(this.webServer).size(), (long)1L);
        for (SocketConnector sc : this.getSocketConnectors(this.webServer)) {
            Assert.assertEquals((long)5L, (long)sc.getAcceptors());
        }
    }

    @Test
    public void testJettyOption_AcceptQueueSizeSetUp() throws Exception {
        Assert.assertEquals((long)this.getSocketConnectors(this.webServer).size(), (long)1L);
        for (SocketConnector sc : this.getSocketConnectors(this.webServer)) {
            Assert.assertEquals((long)5000L, (long)sc.getAcceptQueueSize());
        }
    }

    @Test
    public void testJettyOption_LowResourceMaxIdleTimeSetUp() throws Exception {
        Assert.assertEquals((long)this.getSocketConnectors(this.webServer).size(), (long)1L);
        for (SocketConnector sc : this.getSocketConnectors(this.webServer)) {
            Assert.assertEquals((long)200L, (long)sc.getLowResourceMaxIdleTime());
        }
    }

    @Test
    public void testNoExceptionAndUsingDefaultServerValue_WhenJettyOptionSetAsInvalidValue() throws Exception {
        System.setProperty("KETTLE_CARTE_JETTY_ACCEPTORS", "TEST");
        try {
            this.webServerNg = new WebServer(this.logMock, this.trMapMock, this.jbMapMock, this.sRepoMock, this.detections, HOST_NAME, 8100, false, null);
        }
        catch (NumberFormatException nmbfExc) {
            Assert.fail((String)("Should not have thrown any NumberFormatException but it does: " + nmbfExc));
        }
        Assert.assertEquals((long)this.getSocketConnectors(this.webServerNg).size(), (long)1L);
        for (SocketConnector sc : this.getSocketConnectors(this.webServerNg)) {
            Assert.assertEquals((long)defSocketConnector.getAcceptors(), (long)sc.getAcceptors());
        }
        this.webServerNg.setWebServerShutdownHandler(null);
        this.webServerNg.stopServer();
    }

    @Test
    public void testNoExceptionAndUsingDefaultServerValue_WhenJettyOptionSetAsEmpty() throws Exception {
        System.setProperty("KETTLE_CARTE_JETTY_ACCEPTORS", EMPTY_STRING);
        try {
            this.webServerNg = new WebServer(this.logMock, this.trMapMock, this.jbMapMock, this.sRepoMock, this.detections, HOST_NAME, 8100, false, null);
        }
        catch (NumberFormatException nmbfExc) {
            Assert.fail((String)("Should not have thrown any NumberFormatException but it does: " + nmbfExc));
        }
        Assert.assertEquals((long)this.getSocketConnectors(this.webServerNg).size(), (long)1L);
        for (SocketConnector sc : this.getSocketConnectors(this.webServerNg)) {
            Assert.assertEquals((long)defSocketConnector.getAcceptors(), (long)sc.getAcceptors());
        }
        this.webServerNg.setWebServerShutdownHandler(null);
        this.webServerNg.stopServer();
    }

    private List<SocketConnector> getSocketConnectors(WebServer wServer) {
        Connector[] connectors;
        ArrayList<SocketConnector> sConnectors = new ArrayList<SocketConnector>();
        for (Connector cn : connectors = wServer.getServer().getConnectors()) {
            if (!(cn instanceof SocketConnector)) continue;
            sConnectors.add((SocketConnector)cn);
        }
        return sConnectors;
    }
}

