/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.test.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.trans.steps.loadsave.getter.FieldGetter;
import org.pentaho.di.trans.steps.loadsave.getter.Getter;
import org.pentaho.di.trans.steps.loadsave.getter.MethodGetter;
import org.pentaho.di.trans.steps.loadsave.setter.FieldSetter;
import org.pentaho.di.trans.steps.loadsave.setter.MethodSetter;
import org.pentaho.di.trans.steps.loadsave.setter.Setter;

public class JavaBeanManipulator<T> {
    private final Class<? extends T> clazz;
    private final Map<String, String> getterMap;
    private final Map<String, Getter<?>> getterMethodMap;
    private final Map<String, String> setterMap;
    private final Map<String, Setter<?>> setterMethodMap;

    public JavaBeanManipulator(Class<? extends T> clazz, List<String> attributes, Map<String, String> getterMap, Map<String, String> setterMap) {
        this.clazz = clazz;
        this.getterMap = new HashMap<String, String>(getterMap);
        this.setterMap = new HashMap<String, String>(setterMap);
        this.getterMethodMap = new HashMap();
        this.setterMethodMap = new HashMap();
        this.populateGetters(attributes);
        this.populateSetters(attributes);
    }

    private String getPrefixedName(String prefix, String name) {
        String[] underScoreSplit = name.split("_");
        name = "";
        for (String part : underScoreSplit) {
            if (part.length() <= 0) continue;
            name = name + part.substring(0, 1).toUpperCase();
            if (part.length() <= 1) continue;
            name = name + part.substring(1);
        }
        return prefix + name;
    }

    private void populateGetters(List<String> attributes) {
        for (String attribute : attributes) {
            String getterMethodName = this.getterMap.get(attribute);
            try {
                Getter getter;
                if (getterMethodName != null) {
                    getter = new MethodGetter(this.clazz.getMethod(getterMethodName, new Class[0]));
                } else {
                    try {
                        getter = new MethodGetter(this.clazz.getMethod(this.getPrefixedName("get", attribute), new Class[0]));
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            getter = new MethodGetter(this.clazz.getMethod(this.getPrefixedName("is", attribute), new Class[0]));
                        }
                        catch (NoSuchMethodException e2) {
                            getter = new FieldGetter(this.clazz.getField(attribute));
                        }
                    }
                }
                this.getterMethodMap.put(attribute, getter);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to find getter for " + attribute, e);
            }
        }
    }

    private void populateSetters(List<String> attributes) {
        for (String attribute : attributes) {
            String setterMethodName = this.setterMap.get(attribute);
            try {
                Setter setter;
                if (setterMethodName != null) {
                    setter = new MethodSetter(this.clazz.getMethod(setterMethodName, this.getterMethodMap.get(attribute).getType()));
                } else {
                    try {
                        setter = new MethodSetter(this.clazz.getMethod(this.getPrefixedName("set", attribute), this.getterMethodMap.get(attribute).getType()));
                    }
                    catch (NoSuchMethodException e) {
                        setter = new FieldSetter(this.clazz.getField(attribute));
                    }
                }
                this.setterMethodMap.put(attribute, setter);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to find setter for " + attribute, e);
            }
        }
    }

    public Getter<?> getGetter(String attribute) {
        return this.getterMethodMap.get(attribute);
    }

    public Setter<?> getSetter(String attribute) {
        return this.setterMethodMap.get(attribute);
    }
}

