/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.test.util;

import java.util.ArrayList;
import java.util.Collection;
import org.pentaho.test.util.ObjectProvider;
import org.pentaho.test.util.ObjectTester;
import org.pentaho.test.util.ObjectValidator;
import org.pentaho.test.util.impl.CollectionObjectProvider;
import org.pentaho.test.util.impl.DefaultObjectTester;
import org.pentaho.test.util.impl.DotEqualsValidator;
import org.pentaho.test.util.impl.EqualsEqualsValidator;

public class ObjectTesterBuilder<T> {
    private Collection<T> objects;
    private ObjectProvider<T> provider;
    private boolean useEqualsEquals = false;
    private ObjectValidator<T> validator;

    public ObjectTester<T> build() {
        ObjectValidator<T> validator;
        ObjectProvider<T> provider = this.provider;
        if (provider == null && this.objects != null) {
            provider = new CollectionObjectProvider<T>(this.objects);
        }
        if ((validator = this.validator) == null) {
            validator = this.useEqualsEquals ? new EqualsEqualsValidator() : new DotEqualsValidator();
        }
        return new DefaultObjectTester<T>(provider, validator);
    }

    public ObjectTesterBuilder<T> setObjects(Collection<T> objects) {
        this.objects = objects;
        return this;
    }

    public ObjectTesterBuilder<T> addObject(T object) {
        if (this.objects == null) {
            this.objects = new ArrayList<T>();
        }
        this.objects.add(object);
        return this;
    }

    public ObjectTesterBuilder<T> setProvider(ObjectProvider<T> provider) {
        this.provider = provider;
        return this;
    }

    public ObjectTesterBuilder<T> setUseEqualsEquals(boolean useDotEquals) {
        this.useEqualsEquals = useDotEquals;
        return this;
    }

    public ObjectTesterBuilder<T> useEqualsEquals() {
        return this.setUseEqualsEquals(true);
    }

    public ObjectTesterBuilder<T> setValidator(ObjectValidator<T> validator) {
        this.validator = validator;
        return this;
    }
}

