/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.test.util;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.trans.SingleThreadedTransExecutor;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public abstract class SingleThreadedExecutionGuarder<Meta extends StepMetaInterface> {
    @BeforeClass
    public static void setUp() throws Exception {
        KettleEnvironment.init();
    }

    protected abstract Meta createMeta();

    @Test(expected=KettleException.class)
    public void failsWhenGivenNonSingleThreadSteps() throws Exception {
        Meta metaInterface = this.createMeta();
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String id = plugReg.getPluginId(StepPluginType.class, metaInterface);
        Assert.assertNotNull((String)"pluginId", (Object)id);
        StepMeta stepMeta = new StepMeta(id, "stepMetrics", metaInterface);
        stepMeta.setDraw(true);
        TransMeta transMeta = new TransMeta();
        transMeta.setName("failsWhenGivenNonSingleThreadSteps");
        transMeta.addStep(stepMeta);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        SingleThreadedTransExecutor executor = new SingleThreadedTransExecutor(trans);
        executor.init();
    }
}

