/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.Hive2DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.plugins.DatabaseMetaPlugin;
import org.pentaho.di.core.row.ValueMetaInterface;

@DatabaseMetaPlugin(type="IMPALA", typeDescription="Impala")
public class ImpalaDatabaseMeta
extends Hive2DatabaseMeta
implements DatabaseInterface {
    protected static final String JAR_FILE = "hive-jdbc-cdh4.2.0-release-pentaho.jar";
    protected static final String DRIVER_CLASS_NAME = "org.apache.hive.jdbc.HiveDriver";
    protected static final int DEFAULT_PORT = 21050;
    public static final String AUTH_NO_SASL = ";auth=noSasl";

    public ImpalaDatabaseMeta() throws Throwable {
    }

    ImpalaDatabaseMeta(int majorVersion, int minorVersion) throws Throwable {
        super(majorVersion, minorVersion);
    }

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    @Override
    public String getDriverClass() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean useAutoinc, boolean addFieldname, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 4: {
                retval = retval + "BOOLEAN";
                break;
            }
            case 3: 
            case 9: {
                if (this.isDriverVersion(0, 8)) {
                    retval = retval + "TIMESTAMP";
                    break;
                }
                throw new IllegalArgumentException("Timestamp types not supported in this version of Impala");
            }
            case 2: {
                retval = retval + "STRING";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval = retval + "BIGINT";
                            break;
                        }
                        retval = retval + "FLOAT";
                        break;
                    }
                    retval = retval + "INT";
                    break;
                }
                retval = length > 15 ? retval + "FLOAT" : retval + "DOUBLE";
            }
        }
        return retval;
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) throws KettleDatabaseException {
        if (Const.isEmpty((String)port)) {
            port = Integer.toString(this.getDefaultDatabasePort());
        }
        String principal = this.getAttributes().getProperty("principal");
        String extraPrincipal = this.getAttributes().getProperty("EXTRA_OPTION_" + this.getPluginId() + ".principal");
        if (principal != null || extraPrincipal != null) {
            return "jdbc:hive2://" + hostname + ":" + port + "/" + databaseName;
        }
        return "jdbc:hive2://" + hostname + ":" + port + "/" + databaseName + AUTH_NO_SASL;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{JAR_FILE};
    }

    public int getDefaultDatabasePort() {
        return 21050;
    }
}

