/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.partitioners;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.HDataType;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.partitioners.DiscreteProbabilitySampleGenerator;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.InternalMap;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.NullableBigDecimalWritable;
import org.apache.pig.impl.io.NullableBigIntegerWritable;
import org.apache.pig.impl.io.NullableBooleanWritable;
import org.apache.pig.impl.io.NullableBytesWritable;
import org.apache.pig.impl.io.NullableDateTimeWritable;
import org.apache.pig.impl.io.NullableDoubleWritable;
import org.apache.pig.impl.io.NullableFloatWritable;
import org.apache.pig.impl.io.NullableIntWritable;
import org.apache.pig.impl.io.NullableLongWritable;
import org.apache.pig.impl.io.NullableText;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.io.ReadToEndLoader;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedRangePartitioner
extends Partitioner<PigNullableWritable, Writable>
implements Configurable {
    protected Map<PigNullableWritable, DiscreteProbabilitySampleGenerator> weightedParts = new HashMap<PigNullableWritable, DiscreteProbabilitySampleGenerator>();
    protected PigNullableWritable[] quantiles;
    protected RawComparator<PigNullableWritable> comparator;
    private PigContext pigContext;
    protected Configuration job;
    protected boolean inited = false;

    public int getPartition(PigNullableWritable key, Writable value, int numPartitions) {
        if (!this.inited) {
            this.init();
        }
        if (this.comparator == null) {
            this.comparator = PigMapReduce.sJobContext.getSortComparator();
        }
        if (!this.weightedParts.containsKey(key)) {
            int index = Arrays.binarySearch(this.quantiles, key, this.comparator);
            index = index < 0 ? -index - 1 : ++index;
            return Math.min(index, numPartitions - 1);
        }
        DiscreteProbabilitySampleGenerator gen = this.weightedParts.get(key);
        return gen.getNext();
    }

    public void init() {
        this.weightedParts = new HashMap<PigNullableWritable, DiscreteProbabilitySampleGenerator>();
        try {
            this.pigContext = (PigContext)ObjectSerializer.deserialize(this.job.get("pig.pigContext"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize pig context: ", e);
        }
        String quantilesFile = this.job.get("pig.quantilesFile", "");
        if (quantilesFile.length() == 0) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " used but no quantiles found");
        }
        try {
            Map quantileMap = null;
            Configuration conf = !this.pigContext.getExecType().isLocal() ? ConfigurationUtil.toConfiguration(this.pigContext.getProperties()) : new Configuration(false);
            if (this.job.get("fs.file.impl") != null) {
                conf.set("fs.file.impl", this.job.get("fs.file.impl"));
            }
            if (this.job.get("fs.maprfs.impl") != null) {
                conf.set("fs.maprfs.impl", this.job.get("fs.maprfs.impl"));
            }
            MapRedUtil.copyTmpFileConfigurationValues(this.job, conf);
            conf.set("fs.default.name", "file:///");
            ReadToEndLoader loader = new ReadToEndLoader((LoadFunc)Utils.getTmpFileStorageObject(conf), conf, quantilesFile, 0);
            Tuple t = loader.getNext();
            if (t != null) {
                quantileMap = (Map)t.get(0);
            }
            if (quantileMap != null) {
                DataBag quantilesList = (DataBag)quantileMap.get("quantiles.list");
                InternalMap weightedPartsData = (InternalMap)quantileMap.get("weighted.parts");
                this.convertToArray(quantilesList);
                for (Map.Entry ent : weightedPartsData.entrySet()) {
                    Tuple key = (Tuple)ent.getKey();
                    float[] probVec = this.getProbVec((Tuple)ent.getValue());
                    this.weightedParts.put(this.getPigNullableWritable(key), new DiscreteProbabilitySampleGenerator(probVec));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.inited = true;
    }

    public void setConf(Configuration configuration) {
        this.job = configuration;
    }

    protected float[] getProbVec(Tuple values) throws ExecException {
        float[] probVec = new float[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            probVec[i] = ((Float)values.get(i)).floatValue();
        }
        return probVec;
    }

    protected PigNullableWritable getPigNullableWritable(Tuple t) {
        try {
            if ("true".equals(this.job.get("pig.usercomparator")) || t.size() > 1) {
                return new NullableTuple(t);
            }
            Object o = t.get(0);
            String kts = this.job.get("pig.reduce.key.type");
            if (kts == null) {
                throw new RuntimeException("Didn't get reduce key type from config file.");
            }
            return HDataType.getWritableComparableTypes(o, Byte.valueOf(kts));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void convertToArray(DataBag quantilesListAsBag) {
        ArrayList<PigNullableWritable> quantilesList = this.getList(quantilesListAsBag);
        if ("true".equals(this.job.get("pig.usercomparator")) || quantilesList.get(0).getClass().equals(NullableTuple.class)) {
            this.quantiles = quantilesList.toArray(new NullableTuple[0]);
        } else if (quantilesList.get(0).getClass().equals(NullableBytesWritable.class)) {
            this.quantiles = quantilesList.toArray(new NullableBytesWritable[0]);
        } else if (quantilesList.get(0).getClass().equals(NullableDoubleWritable.class)) {
            this.quantiles = quantilesList.toArray(new NullableDoubleWritable[0]);
        } else if (quantilesList.get(0).getClass().equals(NullableBigIntegerWritable.class)) {
            this.quantiles = quantilesList.toArray(new NullableBigIntegerWritable[0]);
        } else if (quantilesList.get(0).getClass().equals(NullableBigDecimalWritable.class)) {
            this.quantiles = quantilesList.toArray(new NullableBigDecimalWritable[0]);
        } else if (quantilesList.get(0).getClass().equals(NullableFloatWritable.class)) {
            this.quantiles = quantilesList.toArray(new NullableFloatWritable[0]);
        } else if (quantilesList.get(0).getClass().equals(NullableBooleanWritable.class)) {
            this.quantiles = quantilesList.toArray(new NullableBooleanWritable[0]);
        } else if (quantilesList.get(0).getClass().equals(NullableIntWritable.class)) {
            this.quantiles = quantilesList.toArray(new NullableIntWritable[0]);
        } else if (quantilesList.get(0).getClass().equals(NullableLongWritable.class)) {
            this.quantiles = quantilesList.toArray(new NullableLongWritable[0]);
        } else if (quantilesList.get(0).getClass().equals(NullableDateTimeWritable.class)) {
            this.quantiles = quantilesList.toArray(new NullableDateTimeWritable[0]);
        } else if (quantilesList.get(0).getClass().equals(NullableText.class)) {
            this.quantiles = quantilesList.toArray(new NullableText[0]);
        } else {
            throw new RuntimeException("Unexpected class in " + ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    private ArrayList<PigNullableWritable> getList(DataBag quantilesListAsBag) {
        ArrayList<PigNullableWritable> list = new ArrayList<PigNullableWritable>();
        for (Tuple tuple : quantilesListAsBag) {
            list.add(this.getPigNullableWritable(tuple));
        }
        return list;
    }

    public Configuration getConf() {
        return this.job;
    }
}

