/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.pig.Accumulator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.AlgebraicMathBase;
import org.apache.pig.builtin.BigIntegerWrapper;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AlgebraicBigIntegerMathBase
extends AlgebraicMathBase<BigInteger>
implements Accumulator<BigInteger> {
    private BigInteger intermediateVal = null;

    protected static BigInteger getSeed(AlgebraicMathBase.KNOWN_OP op) {
        switch (op) {
            case SUM: {
                return BigInteger.ZERO;
            }
            case MAX: {
                return BigIntegerWrapper.NEGATIVE_INFINITY();
            }
            case MIN: {
                return BigIntegerWrapper.POSITIVE_INFINITY();
            }
        }
        return null;
    }

    private static BigInteger doWork(BigInteger arg1, BigInteger arg2, AlgebraicMathBase.KNOWN_OP op) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        BigInteger retVal = null;
        switch (op) {
            case SUM: {
                retVal = arg1.add(arg2);
                break;
            }
            case MAX: {
                if (BigIntegerWrapper.class.isInstance(arg1) && ((BigIntegerWrapper)arg1).isNegativeInfinity()) {
                    retVal = arg2;
                    break;
                }
                if (BigIntegerWrapper.class.isInstance(arg2) && ((BigIntegerWrapper)arg2).isNegativeInfinity()) {
                    retVal = arg1;
                    break;
                }
                retVal = arg1.max(arg2);
                break;
            }
            case MIN: {
                if (BigIntegerWrapper.class.isInstance(arg1) && ((BigIntegerWrapper)arg1).isPositiveInfinity()) {
                    retVal = arg2;
                    break;
                }
                if (BigIntegerWrapper.class.isInstance(arg2) && ((BigIntegerWrapper)arg2).isPositiveInfinity()) {
                    retVal = arg1;
                    break;
                }
                retVal = arg1.min(arg2);
                break;
            }
            default: {
                retVal = null;
            }
        }
        return retVal;
    }

    protected static BigInteger doTupleWork(Tuple input, AlgebraicMathBase.KnownOpProvider opProvider) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        BigInteger sofar = AlgebraicBigIntegerMathBase.getSeed(opProvider.getOp());
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Number n = (Number)t.get(0);
                if (n == null) continue;
                BigInteger d = (BigInteger)n;
                sawNonNull = true;
                sofar = AlgebraicBigIntegerMathBase.doWork(sofar, d, opProvider.getOp());
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                throw new ExecException("Problem doing work on BigInteger", errCode, 4, exp);
            }
        }
        return sawNonNull ? sofar : null;
    }

    @Override
    public BigInteger exec(Tuple input) throws IOException {
        try {
            return AlgebraicBigIntegerMathBase.doTupleWork(input, this.opProvider);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            throw new ExecException("Error executing function on BigInteger", errCode, 4, e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 65));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            BigInteger curVal = AlgebraicBigIntegerMathBase.doTupleWork(b, this.opProvider);
            if (curVal == null) {
                return;
            }
            if (this.intermediateVal == null) {
                this.intermediateVal = AlgebraicBigIntegerMathBase.getSeed(this.opProvider.getOp());
            }
            this.intermediateVal = AlgebraicBigIntegerMathBase.doWork(this.intermediateVal, curVal, this.opProvider.getOp());
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            throw new ExecException("Error executing function on BigInteger", errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateVal = null;
    }

    @Override
    public BigInteger getValue() {
        return this.intermediateVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Final
    extends AlgebraicMathBase.Final<BigInteger> {
        @Override
        public BigInteger exec(Tuple input) throws IOException {
            try {
                return AlgebraicBigIntegerMathBase.doTupleWork(input, this);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing function on BigInteger", errCode, 4, e);
            }
        }
    }

    public static abstract class Intermediate
    extends AlgebraicMathBase.Intermediate {
        private static TupleFactory tfact = TupleFactory.getInstance();

        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(AlgebraicBigIntegerMathBase.doTupleWork(input, this));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing function on BigInteger", errCode, 4, e);
            }
        }
    }
}

