/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TOKENIZE
extends EvalFunc<DataBag> {
    TupleFactory mTupleFactory = TupleFactory.getInstance();
    BagFactory mBagFactory = BagFactory.getInstance();

    @Override
    public DataBag exec(Tuple input) throws IOException {
        if (input == null) {
            return null;
        }
        if (input.size() == 0) {
            return null;
        }
        Object o = input.get(0);
        if (o == null) {
            return null;
        }
        DataBag output = this.mBagFactory.newDefaultBag();
        if (!(o instanceof String)) {
            int errCode = 2114;
            String msg = "Expected input to be chararray, but got " + o.getClass().getName();
            throw new ExecException(msg, errCode, 4);
        }
        String delim = " \",()*";
        if (input.size() == 2) {
            Object d = input.get(1);
            if (!(d instanceof String)) {
                int errCode = 2114;
                String msg = "Expected delim to be chararray, but got " + d.getClass().getName();
                throw new ExecException(msg, errCode, 4);
            }
            delim = (String)d;
        }
        StringTokenizer tok = new StringTokenizer((String)o, delim, false);
        while (tok.hasMoreTokens()) {
            output.add(this.mTupleFactory.newTuple(tok.nextToken()));
        }
        return output;
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            Schema.FieldSchema tokenFs = new Schema.FieldSchema("token", 55);
            Schema tupleSchema = new Schema(tokenFs);
            Schema.FieldSchema tupleFs = new Schema.FieldSchema("tuple_of_tokens", tupleSchema, 110);
            Schema bagSchema = new Schema(tupleFs);
            bagSchema.setTwoLevelAccessRequired(true);
            Schema.FieldSchema bagFs = new Schema.FieldSchema("bag_of_tokenTuples_from_" + input.getField((int)0).alias, bagSchema, 120);
            return new Schema(bagFs);
        }
        catch (FrontendException e) {
            throw new RuntimeException("Unable to compute TOKENIZE schema.");
        }
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        return funcList;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

