/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static String unescapeInputString(String input) {
        if (input == null) {
            return "";
        }
        int inputlength = input.length();
        StringBuilder unicode = new StringBuilder(4);
        StringBuilder output = new StringBuilder(inputlength);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < inputlength; ++i) {
            char ch = input.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    output.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        output.append('\\');
                        break;
                    }
                    case '\'': {
                        output.append('\'');
                        break;
                    }
                    case 'r': {
                        output.append('\r');
                        break;
                    }
                    case 'f': {
                        output.append('\f');
                        break;
                    }
                    case 't': {
                        output.append('\t');
                        break;
                    }
                    case 'n': {
                        output.append('\n');
                        break;
                    }
                    case 'b': {
                        output.append('\b');
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        output.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String join(AbstractCollection<String> s, String delimiter) {
        if (s.isEmpty()) {
            return "";
        }
        Iterator<String> iter = s.iterator();
        StringBuffer buffer = new StringBuffer(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter);
            buffer.append(iter.next());
        }
        return buffer.toString();
    }

    public static String[] getPathStrings(String commaSeparatedPaths) {
        int length = commaSeparatedPaths.length();
        int curlyOpen = 0;
        int pathStart = 0;
        boolean globPattern = false;
        ArrayList<String> pathStrings = new ArrayList<String>();
        block5: for (int i = 0; i < length; ++i) {
            char ch = commaSeparatedPaths.charAt(i);
            switch (ch) {
                case '{': {
                    ++curlyOpen;
                    if (globPattern) continue block5;
                    globPattern = true;
                    continue block5;
                }
                case '}': {
                    if (--curlyOpen != 0 || !globPattern) continue block5;
                    globPattern = false;
                    continue block5;
                }
                case ',': {
                    if (globPattern) continue block5;
                    pathStrings.add(commaSeparatedPaths.substring(pathStart, i));
                    pathStart = i + 1;
                }
            }
        }
        pathStrings.add(commaSeparatedPaths.substring(pathStart, length));
        return pathStrings.toArray(new String[0]);
    }
}

