/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.rules.OptimizerUtils;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public class FilterAboveForeach
extends Rule {
    public FilterAboveForeach(String n) {
        super(n, false);
    }

    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LOForEach foreach = new LOForEach(plan);
        LOFilter filter = new LOFilter(plan);
        plan.add(foreach);
        plan.add(filter);
        plan.connect(foreach, filter);
        return plan;
    }

    public Transformer getNewTransformer() {
        return new FilterAboveForEachTransformer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FilterAboveForEachTransformer
    extends Transformer {
        LOFilter filter = null;
        LOForEach foreach = null;
        LogicalRelationalOperator forEachPred = null;
        OperatorSubPlan subPlan = null;

        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            Operator op;
            Iterator<Operator> iter = matched.getOperators();
            while (iter.hasNext()) {
                op = iter.next();
                if (!(op instanceof LOForEach)) continue;
                this.foreach = (LOForEach)op;
                break;
            }
            if (this.foreach == null) {
                return false;
            }
            iter = matched.getOperators();
            while (iter.hasNext()) {
                op = iter.next();
                if (!(op instanceof LOFilter)) continue;
                this.filter = (LOFilter)op;
                break;
            }
            while (this.filter != null) {
                Pair<List<Long>, List<Byte>> uidWithTypes = this.getFilterProjectionUids(this.filter);
                List<Operator> preds = FilterAboveForeach.this.currentPlan.getPredecessors(this.foreach);
                for (int j = 0; j < preds.size(); ++j) {
                    LogicalRelationalOperator logRelOp = (LogicalRelationalOperator)preds.get(j);
                    if (!this.hasAll(logRelOp, uidWithTypes)) continue;
                    this.forEachPred = (LogicalRelationalOperator)preds.get(j);
                    return !OptimizerUtils.planHasNonDeterministicUdf(this.filter.getFilterPlan());
                }
                List<Operator> successors = FilterAboveForeach.this.currentPlan.getSuccessors(this.filter);
                if (successors != null && successors.size() > 0 && successors.get(0) instanceof LOFilter) {
                    this.filter = (LOFilter)successors.get(0);
                    continue;
                }
                this.filter = null;
            }
            return false;
        }

        private Pair<List<Long>, List<Byte>> getFilterProjectionUids(LOFilter filter) throws FrontendException {
            ArrayList<Long> uids = new ArrayList<Long>();
            ArrayList<Byte> types = new ArrayList<Byte>();
            if (filter != null) {
                LogicalExpressionPlan filterPlan = filter.getFilterPlan();
                Iterator<Operator> iter = filterPlan.getOperators();
                Operator op = null;
                while (iter.hasNext()) {
                    op = iter.next();
                    if (!(op instanceof ProjectExpression)) continue;
                    ProjectExpression proj = (ProjectExpression)op;
                    if (proj.isProjectStar()) {
                        LogicalRelationalOperator pred = (LogicalRelationalOperator)filter.getPlan().getPredecessors(filter).get(0);
                        LogicalSchema predSchema = pred.getSchema();
                        if (predSchema == null) continue;
                        for (int i = 0; i < predSchema.size(); ++i) {
                            uids.add(predSchema.getField((int)i).uid);
                            types.add(predSchema.getField((int)i).type);
                        }
                        continue;
                    }
                    uids.add(proj.getFieldSchema().uid);
                    types.add(proj.getFieldSchema().type);
                }
            }
            Pair<List<Long>, List<Byte>> result = new Pair<List<Long>, List<Byte>>(uids, types);
            return result;
        }

        private boolean hasAll(LogicalRelationalOperator op, Pair<List<Long>, List<Byte>> uidWithTypes) throws FrontendException {
            LogicalSchema schema = op.getSchema();
            if (schema == null) {
                return false;
            }
            List uids = (List)uidWithTypes.first;
            List types = (List)uidWithTypes.second;
            for (int i = 0; i < uids.size(); ++i) {
                boolean found = false;
                for (LogicalSchema.LogicalFieldSchema fs : schema.getFields()) {
                    if (fs.uid != (Long)uids.get(i) || fs.type != (Byte)types.get(i)) continue;
                    found = true;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        @Override
        public OperatorPlan reportChanges() {
            return this.subPlan;
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            List<Operator> opSet = FilterAboveForeach.this.currentPlan.getPredecessors(this.filter);
            if (opSet == null || opSet.size() <= 0) {
                return;
            }
            Operator filterPred = opSet.get(0);
            opSet = FilterAboveForeach.this.currentPlan.getSuccessors(this.filter);
            if (opSet == null || opSet.size() <= 0) {
                return;
            }
            Operator filterSuc = opSet.get(0);
            this.subPlan = new OperatorSubPlan(FilterAboveForeach.this.currentPlan);
            Pair<Integer, Integer> forEachPredPlaces = FilterAboveForeach.this.currentPlan.disconnect(this.forEachPred, this.foreach);
            Pair<Integer, Integer> filterPredPlaces = FilterAboveForeach.this.currentPlan.disconnect(filterPred, this.filter);
            Pair<Integer, Integer> filterSucPlaces = FilterAboveForeach.this.currentPlan.disconnect(this.filter, filterSuc);
            FilterAboveForeach.this.currentPlan.connect(this.forEachPred, (Integer)forEachPredPlaces.first, this.filter, (Integer)filterPredPlaces.second);
            FilterAboveForeach.this.currentPlan.connect(this.filter, (Integer)filterSucPlaces.first, this.foreach, (Integer)forEachPredPlaces.second);
            FilterAboveForeach.this.currentPlan.connect(filterPred, (Integer)filterPredPlaces.first, filterSuc, (Integer)filterSucPlaces.second);
            this.subPlan.add(this.forEachPred);
            this.subPlan.add(this.foreach);
            this.subPlan.add(filterPred);
            this.subPlan.add(this.filter);
            this.subPlan.add(filterSuc);
        }
    }
}

