/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.plus.annotation.PostConstructCallback;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class LifeCycleCallbackCollection {
    private static final Logger LOG = Log.getLogger(LifeCycleCallbackCollection.class);
    public static final String LIFECYCLE_CALLBACK_COLLECTION = "org.eclipse.jetty.lifecyleCallbackCollection";
    private HashMap<String, List<LifeCycleCallback>> postConstructCallbacksMap = new HashMap();
    private HashMap<String, List<LifeCycleCallback>> preDestroyCallbacksMap = new HashMap();

    public void add(LifeCycleCallback callback) {
        if (callback == null || callback.getTargetClassName() == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding callback for class=" + callback.getTargetClass() + " on " + callback.getTarget(), new Object[0]);
        }
        HashMap<String, List<LifeCycleCallback>> map = null;
        if (callback instanceof PreDestroyCallback) {
            map = this.preDestroyCallbacksMap;
        }
        if (callback instanceof PostConstructCallback) {
            map = this.postConstructCallbacksMap;
        }
        if (map == null) {
            throw new IllegalArgumentException("Unsupported lifecycle callback type: " + callback);
        }
        ArrayList<LifeCycleCallback> callbacks = (ArrayList<LifeCycleCallback>)map.get(callback.getTargetClassName());
        if (callbacks == null) {
            callbacks = new ArrayList<LifeCycleCallback>();
            map.put(callback.getTargetClassName(), callbacks);
        }
        if (!callbacks.contains(callback)) {
            callbacks.add(callback);
        }
    }

    public List<LifeCycleCallback> getPreDestroyCallbacks(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> clazz = o.getClass();
        return this.preDestroyCallbacksMap.get(clazz.getName());
    }

    public List<LifeCycleCallback> getPostConstructCallbacks(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> clazz = o.getClass();
        return this.postConstructCallbacksMap.get(clazz.getName());
    }

    public void callPostConstructCallback(Object o) throws Exception {
        if (o == null) {
            return;
        }
        Class<?> clazz = o.getClass();
        List<LifeCycleCallback> callbacks = this.postConstructCallbacksMap.get(clazz.getName());
        if (callbacks == null) {
            return;
        }
        for (int i = 0; i < callbacks.size(); ++i) {
            callbacks.get(i).callback(o);
        }
    }

    public void callPreDestroyCallback(Object o) throws Exception {
        if (o == null) {
            return;
        }
        Class<?> clazz = o.getClass();
        List<LifeCycleCallback> callbacks = this.preDestroyCallbacksMap.get(clazz.getName());
        if (callbacks == null) {
            return;
        }
        for (int i = 0; i < callbacks.size(); ++i) {
            callbacks.get(i).callback(o);
        }
    }
}

