/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.ResourceFinderIClassLoader;
import org.codehaus.janino.util.resource.JarDirectoriesResourceFinder;
import org.codehaus.janino.util.resource.PathResourceFinder;

public abstract class IClassLoader {
    private static final boolean DEBUG = false;
    public IClass OBJECT;
    public IClass STRING;
    public IClass CLASS;
    public IClass THROWABLE;
    public IClass RUNTIME_EXCEPTION;
    public IClass ERROR;
    public IClass CLONEABLE;
    public IClass SERIALIZABLE;
    public IClass BOOLEAN;
    public IClass BYTE;
    public IClass CHARACTER;
    public IClass SHORT;
    public IClass INTEGER;
    public IClass LONG;
    public IClass FLOAT;
    public IClass DOUBLE;
    private final IClassLoader optionalParentIClassLoader;
    private final Map loadedIClasses = new HashMap();
    private final Set unloadableIClasses = new HashSet();

    public IClassLoader(IClassLoader optionalParentIClassLoader) {
        this.optionalParentIClassLoader = optionalParentIClassLoader;
    }

    protected final void postConstruct() {
        try {
            this.OBJECT = this.loadIClass("Ljava/lang/Object;");
            this.STRING = this.loadIClass("Ljava/lang/String;");
            this.CLASS = this.loadIClass("Ljava/lang/Class;");
            this.THROWABLE = this.loadIClass("Ljava/lang/Throwable;");
            this.RUNTIME_EXCEPTION = this.loadIClass("Ljava/lang/RuntimeException;");
            this.ERROR = this.loadIClass("Ljava/lang/Error;");
            this.CLONEABLE = this.loadIClass("Ljava/lang/Cloneable;");
            this.SERIALIZABLE = this.loadIClass("Ljava/io/Serializable;");
            this.BOOLEAN = this.loadIClass("Ljava/lang/Boolean;");
            this.BYTE = this.loadIClass("Ljava/lang/Byte;");
            this.CHARACTER = this.loadIClass("Ljava/lang/Character;");
            this.SHORT = this.loadIClass("Ljava/lang/Short;");
            this.INTEGER = this.loadIClass("Ljava/lang/Integer;");
            this.LONG = this.loadIClass("Ljava/lang/Long;");
            this.FLOAT = this.loadIClass("Ljava/lang/Float;");
            this.DOUBLE = this.loadIClass("Ljava/lang/Double;");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot load simple types");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IClass loadIClass(String fieldDescriptor) throws ClassNotFoundException {
        IClass result;
        IClass res;
        if (Descriptor.isPrimitive(fieldDescriptor)) {
            return fieldDescriptor.equals("V") ? IClass.VOID : (fieldDescriptor.equals("B") ? IClass.BYTE : (fieldDescriptor.equals("C") ? IClass.CHAR : (fieldDescriptor.equals("D") ? IClass.DOUBLE : (fieldDescriptor.equals("F") ? IClass.FLOAT : (fieldDescriptor.equals("I") ? IClass.INT : (fieldDescriptor.equals("J") ? IClass.LONG : (fieldDescriptor.equals("S") ? IClass.SHORT : (fieldDescriptor.equals("Z") ? IClass.BOOLEAN : null))))))));
        }
        if (this.optionalParentIClassLoader != null && (res = this.optionalParentIClassLoader.loadIClass(fieldDescriptor)) != null) {
            return res;
        }
        IClassLoader iClassLoader = this;
        synchronized (iClassLoader) {
            if (this.unloadableIClasses.contains(fieldDescriptor)) {
                return null;
            }
            result = (IClass)this.loadedIClasses.get(fieldDescriptor);
            if (result != null) {
                return result;
            }
            if (Descriptor.isArrayReference(fieldDescriptor)) {
                IClass componentIClass = this.loadIClass(Descriptor.getComponentDescriptor(fieldDescriptor));
                if (componentIClass == null) {
                    return null;
                }
                IClass arrayIClass = componentIClass.getArrayIClass(this.OBJECT);
                this.loadedIClasses.put(fieldDescriptor, arrayIClass);
                return arrayIClass;
            }
            result = this.findIClass(fieldDescriptor);
            if (result == null) {
                this.unloadableIClasses.add(fieldDescriptor);
                return null;
            }
        }
        if (!result.getDescriptor().equalsIgnoreCase(fieldDescriptor)) {
            throw new RuntimeException("\"findIClass()\" returned \"" + result.getDescriptor() + "\" instead of \"" + fieldDescriptor + "\"");
        }
        return result;
    }

    protected abstract IClass findIClass(String var1) throws ClassNotFoundException;

    protected final void defineIClass(IClass iClass) {
        String descriptor = iClass.getDescriptor();
        IClass loadedIClass = (IClass)this.loadedIClasses.get(descriptor);
        if (loadedIClass != null) {
            if (loadedIClass == iClass) {
                return;
            }
            throw new RuntimeException("Non-identical definition of IClass \"" + descriptor + "\"");
        }
        this.loadedIClasses.put(descriptor, iClass);
    }

    public static IClassLoader createJavacLikePathIClassLoader(File[] optionalBootClassPath, File[] optionalExtDirs, File[] classPath) {
        PathResourceFinder bootClassPathResourceFinder = new PathResourceFinder(optionalBootClassPath == null ? PathResourceFinder.parsePath(System.getProperty("sun.boot.class.path")) : optionalBootClassPath);
        JarDirectoriesResourceFinder extensionDirectoriesResourceFinder = new JarDirectoriesResourceFinder(optionalExtDirs == null ? PathResourceFinder.parsePath(System.getProperty("java.ext.dirs")) : optionalExtDirs);
        PathResourceFinder classPathResourceFinder = new PathResourceFinder(classPath);
        ResourceFinderIClassLoader icl = new ResourceFinderIClassLoader(bootClassPathResourceFinder, null);
        icl = new ResourceFinderIClassLoader(extensionDirectoriesResourceFinder, icl);
        icl = new ResourceFinderIClassLoader(classPathResourceFinder, icl);
        return icl;
    }
}

