/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.StringReader;
import java.net.URI;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionInputCheckXCommand;
import org.apache.oozie.coord.CoordELEvaluator;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.coord.CoordinatorJobException;
import org.apache.oozie.coord.SyncCoordAction;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.dependency.ActionDependency;
import org.apache.oozie.dependency.DependencyChecker;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.quartz.CronExpression;

public class CoordCommandUtils {
    public static int CURRENT = 0;
    public static int LATEST = 1;
    public static int FUTURE = 2;
    public static int OFFSET = 3;
    public static int ABSOLUTE = 4;
    public static int UNEXPECTED = -1;
    public static final String RESOLVED_UNRESOLVED_SEPARATOR = "!!";
    public static final String UNRESOLVED_INST_TAG = "unresolved-instances";

    public static int getInstanceNumber(String function, StringBuilder restArg) throws Exception {
        int funcType = CoordCommandUtils.getFuncType(function);
        if (funcType == ABSOLUTE) {
            return ABSOLUTE;
        }
        if (funcType == CURRENT || funcType == LATEST) {
            return CoordCommandUtils.parseOneArg(function);
        }
        return CoordCommandUtils.parseMoreArgs(function, restArg);
    }

    private static String evaluateInstanceFunction(Element event, SyncCoordAction appInst, Configuration conf, String function) throws Exception {
        ELEvaluator eval = CoordELEvaluator.createInstancesELEvaluator("coord-action-create-inst", event, appInst, conf);
        return CoordELFunctions.evalAndWrap(eval, function);
    }

    public static int parseOneArg(String funcName) throws Exception {
        String tmp;
        int firstPos = funcName.indexOf("(");
        int lastPos = funcName.lastIndexOf(")");
        if (firstPos >= 0 && lastPos > firstPos && (tmp = funcName.substring(firstPos + 1, lastPos).trim()).length() > 0) {
            return (int)Double.parseDouble(tmp);
        }
        throw new RuntimeException("Unformatted function :" + funcName);
    }

    public static String parseOneStringArg(String funcName) throws Exception {
        int firstPos = funcName.indexOf("(");
        int lastPos = funcName.lastIndexOf(")");
        if (firstPos >= 0 && lastPos > firstPos) {
            return funcName.substring(firstPos + 1, lastPos).trim();
        }
        throw new RuntimeException("Unformatted function :" + funcName);
    }

    private static int parseMoreArgs(String funcName, StringBuilder restArg) throws Exception {
        String tmp;
        int firstPos = funcName.indexOf("(");
        int secondPos = funcName.lastIndexOf(",");
        int lastPos = funcName.lastIndexOf(")");
        if (firstPos >= 0 && secondPos > firstPos && (tmp = funcName.substring(firstPos + 1, secondPos).trim()).length() > 0) {
            restArg.append(funcName.substring(secondPos + 1, lastPos).trim());
            return (int)Double.parseDouble(tmp);
        }
        throw new RuntimeException("Unformatted function :" + funcName);
    }

    public static int getFuncType(String function) {
        if (function.indexOf("current") >= 0) {
            return CURRENT;
        }
        if (function.indexOf("latest") >= 0) {
            return LATEST;
        }
        if (function.indexOf("future") >= 0) {
            return FUTURE;
        }
        if (function.indexOf("offset") >= 0) {
            return OFFSET;
        }
        if (function.indexOf("absolute") >= 0) {
            return ABSOLUTE;
        }
        return UNEXPECTED;
    }

    public static void checkIfBothSameType(String startInst, String endInst) throws CommandException {
        if (CoordCommandUtils.getFuncType(startInst) != CoordCommandUtils.getFuncType(endInst)) {
            if (CoordCommandUtils.getFuncType(startInst) == ABSOLUTE) {
                if (CoordCommandUtils.getFuncType(endInst) != CURRENT) {
                    throw new CommandException(ErrorCode.E1010, "Only start-instance as absolute and end-instance as current is supported. start = " + startInst + "  end = " + endInst);
                }
            } else {
                throw new CommandException(ErrorCode.E1010, " start-instance and end-instance both should be either latest or current or future or offset\n start " + startInst + " and end " + endInst);
            }
        }
    }

    public static void resolveInstances(Element event, StringBuilder instances, SyncCoordAction actionInst, Configuration conf, ELEvaluator eval) throws Exception {
        for (Element eInstance : event.getChildren("instance", event.getNamespace())) {
            if (instances.length() > 0) {
                instances.append("#");
            }
            instances.append(CoordCommandUtils.materializeInstance(event, eInstance.getTextTrim(), actionInst, conf, eval));
        }
        event.removeChildren("instance", event.getNamespace());
    }

    public static void resolveInstanceRange(Element event, StringBuilder instances, SyncCoordAction appInst, Configuration conf, ELEvaluator eval) throws Exception {
        Element eStartInst = event.getChild("start-instance", event.getNamespace());
        Element eEndInst = event.getChild("end-instance", event.getNamespace());
        if (eStartInst != null && eEndInst != null) {
            String strStart = CoordCommandUtils.evaluateInstanceFunction(event, appInst, conf, eStartInst.getTextTrim());
            String strEnd = CoordCommandUtils.evaluateInstanceFunction(event, appInst, conf, eEndInst.getTextTrim());
            CoordCommandUtils.checkIfBothSameType(strStart, strEnd);
            StringBuilder restArg = new StringBuilder();
            int startIndex = CoordCommandUtils.getInstanceNumber(strStart, restArg);
            String startRestArg = restArg.toString();
            restArg.delete(0, restArg.length());
            int endIndex = CoordCommandUtils.getInstanceNumber(strEnd, restArg);
            String endRestArg = restArg.toString();
            int funcType = CoordCommandUtils.getFuncType(strStart);
            if (funcType == ABSOLUTE) {
                StringBuffer bf = new StringBuffer();
                bf.append("${coord:absoluteRange(\"").append(CoordCommandUtils.parseOneStringArg(strStart)).append("\",").append(endIndex).append(")}");
                String matInstance = CoordCommandUtils.materializeInstance(event, bf.toString(), appInst, conf, eval);
                if (matInstance != null && !matInstance.isEmpty()) {
                    if (instances.length() > 0) {
                        instances.append("#");
                    }
                    instances.append(matInstance);
                }
            } else if (funcType == OFFSET) {
                TimeUnit startU = TimeUnit.valueOf(startRestArg);
                TimeUnit endU = TimeUnit.valueOf(endRestArg);
                if (startU.getCalendarUnit() * startIndex > endU.getCalendarUnit() * endIndex) {
                    throw new CommandException(ErrorCode.E1010, " start-instance should be equal or earlier than the end-instance \n" + XmlUtils.prettyPrint(event));
                }
                Calendar startCal = CoordELFunctions.resolveOffsetRawTime(startIndex, startU, eval);
                Calendar endCal = CoordELFunctions.resolveOffsetRawTime(endIndex, endU, eval);
                if (startCal != null && endCal != null) {
                    String matInstance;
                    List<Integer> expandedFreqs = CoordELFunctions.expandOffsetTimes(startCal, endCal, eval);
                    for (int i = expandedFreqs.size() - 1; i >= 0 && (matInstance = CoordCommandUtils.materializeInstance(event, "${coord:offset(" + expandedFreqs.get(i) + ", \"" + startRestArg + "\")}", appInst, conf, eval)) != null && matInstance.length() != 0; --i) {
                        if (instances.length() > 0) {
                            instances.append("#");
                        }
                        instances.append(matInstance);
                    }
                }
            } else {
                if (startIndex > endIndex) {
                    throw new CommandException(ErrorCode.E1010, " start-instance should be equal or earlier than the end-instance \n" + XmlUtils.prettyPrint(event));
                }
                if (funcType == CURRENT) {
                    String matInstance = CoordCommandUtils.materializeInstance(event, "${coord:currentRange(" + startIndex + "," + endIndex + ")}", appInst, conf, eval);
                    if (matInstance != null && !matInstance.isEmpty()) {
                        if (instances.length() > 0) {
                            instances.append("#");
                        }
                        instances.append(matInstance);
                    }
                } else if (funcType == LATEST) {
                    instances.append("${coord:latestRange(").append(startIndex).append(",").append(endIndex).append(")}");
                } else if (funcType == FUTURE) {
                    instances.append("${coord:futureRange(").append(startIndex).append(",").append(endIndex).append(",'").append(endRestArg).append("')}");
                }
            }
            event.removeChild("start-instance", event.getNamespace());
            event.removeChild("end-instance", event.getNamespace());
        }
    }

    public static String materializeInstance(Element event, String expr, SyncCoordAction appInst, Configuration conf, ELEvaluator evalInst) throws Exception {
        if (event == null) {
            return null;
        }
        return CoordELFunctions.evalAndWrap(evalInst, expr);
    }

    private static String separateResolvedAndUnresolved(Element event, StringBuilder instances) throws Exception {
        StringBuilder unresolvedInstances = new StringBuilder();
        StringBuilder urisWithDoneFlag = new StringBuilder();
        StringBuilder depList = new StringBuilder();
        String uris = CoordCommandUtils.createEarlyURIs(event, instances.toString(), unresolvedInstances, urisWithDoneFlag);
        if (uris.length() > 0) {
            Element uriInstance = new Element("uris", event.getNamespace());
            uriInstance.addContent(uris);
            event.getContent().add(1, uriInstance);
            if (depList.length() > 0) {
                depList.append("#");
            }
            depList.append((CharSequence)urisWithDoneFlag);
        }
        if (unresolvedInstances.length() > 0) {
            Element elemInstance = new Element(UNRESOLVED_INST_TAG, event.getNamespace());
            elemInstance.addContent(unresolvedInstances.toString());
            event.getContent().add(1, elemInstance);
        }
        return depList.toString();
    }

    public static String createEarlyURIs(Element event, String instances, StringBuilder unresolvedInstances, StringBuilder urisWithDoneFlag) throws Exception {
        if (instances == null || instances.length() == 0) {
            return "";
        }
        String[] instanceList = instances.split("#");
        StringBuilder uris = new StringBuilder();
        Element doneFlagElement = event.getChild("dataset", event.getNamespace()).getChild("done-flag", event.getNamespace());
        URIHandlerService uriService = Services.get().get(URIHandlerService.class);
        for (int i = 0; i < instanceList.length; ++i) {
            if (instanceList[i].trim().length() == 0) continue;
            int funcType = CoordCommandUtils.getFuncType(instanceList[i]);
            if (funcType == LATEST || funcType == FUTURE) {
                if (unresolvedInstances.length() > 0) {
                    unresolvedInstances.append("#");
                }
                unresolvedInstances.append(instanceList[i]);
                continue;
            }
            ELEvaluator eval = CoordELEvaluator.createURIELEvaluator(instanceList[i]);
            if (uris.length() > 0) {
                uris.append("#");
                urisWithDoneFlag.append("#");
            }
            String uriPath = CoordELFunctions.evalAndWrap(eval, event.getChild("dataset", event.getNamespace()).getChild("uri-template", event.getNamespace()).getTextTrim());
            URIHandler uriHandler = uriService.getURIHandler(uriPath);
            uriHandler.validate(uriPath);
            uris.append(uriPath);
            urisWithDoneFlag.append(uriHandler.getURIWithDoneFlag(uriPath, CoordUtils.getDoneFlag(doneFlagElement)));
        }
        return uris.toString();
    }

    public static boolean materializeSLA(Element eAction, CoordinatorActionBean coordAction, Configuration conf) throws CoordinatorJobException {
        Element eSla = eAction.getChild("action", eAction.getNamespace()).getChild("info", eAction.getNamespace("sla"));
        if (eSla == null) {
            return false;
        }
        try {
            ELEvaluator evalSla = CoordELEvaluator.createSLAEvaluator(eAction, coordAction, conf);
            List elemList = eSla.getChildren();
            for (Element elem : elemList) {
                String updated;
                try {
                    updated = CoordELFunctions.evalAndWrap(evalSla, elem.getText().trim());
                }
                catch (Exception e) {
                    throw new CoordinatorJobException(ErrorCode.E1004, e.getMessage(), e);
                }
                elem.removeContent();
                elem.addContent(updated);
            }
        }
        catch (Exception e) {
            throw new CoordinatorJobException(ErrorCode.E1004, e.getMessage(), e);
        }
        return true;
    }

    public static String materializeOneInstance(String jobId, boolean dryrun, Element eAction, Date nominalTime, Date actualTime, int instanceCount, Configuration conf, CoordinatorActionBean actionBean) throws Exception {
        String actionId = Services.get().get(UUIDService.class).generateChildId(jobId, instanceCount + "");
        SyncCoordAction appInst = new SyncCoordAction();
        appInst.setActionId(actionId);
        appInst.setName(eAction.getAttributeValue("name"));
        appInst.setNominalTime(nominalTime);
        appInst.setActualTime(actualTime);
        String frequency = eAction.getAttributeValue("frequency");
        appInst.setFrequency(frequency);
        appInst.setTimeUnit(TimeUnit.valueOf(eAction.getAttributeValue("freq_timeunit")));
        appInst.setTimeZone(DateUtils.getTimeZone(eAction.getAttributeValue("timezone")));
        appInst.setEndOfDuration(TimeUnit.valueOf(eAction.getAttributeValue("end_of_duration")));
        Map<String, StringBuilder> dependencyMap = null;
        Element inputList = eAction.getChild("input-events", eAction.getNamespace());
        List dataInList = null;
        if (inputList != null) {
            dataInList = inputList.getChildren("data-in", eAction.getNamespace());
            dependencyMap = CoordCommandUtils.materializeDataEvents(dataInList, appInst, conf);
        }
        Element outputList = eAction.getChild("output-events", eAction.getNamespace());
        List dataOutList = null;
        if (outputList != null) {
            dataOutList = outputList.getChildren("data-out", eAction.getNamespace());
            CoordCommandUtils.materializeDataEvents(dataOutList, appInst, conf);
        }
        eAction.removeAttribute("start");
        eAction.removeAttribute("end");
        eAction.setAttribute("instance-number", Integer.toString(instanceCount));
        eAction.setAttribute("action-nominal-time", DateUtils.formatDateOozieTZ(nominalTime));
        eAction.setAttribute("action-actual-time", DateUtils.formatDateOozieTZ(actualTime));
        actionBean.setCreatedConf(XmlUtils.prettyPrint(conf).toString());
        actionBean.setRunConf(XmlUtils.prettyPrint(conf).toString());
        actionBean.setCreatedTime(actualTime);
        actionBean.setJobId(jobId);
        actionBean.setId(actionId);
        actionBean.setLastModifiedTime(new Date());
        actionBean.setStatus(CoordinatorAction.Status.WAITING);
        actionBean.setActionNumber(instanceCount);
        if (dependencyMap != null) {
            StringBuilder sbPush;
            StringBuilder sbPull = dependencyMap.get(URIHandler.DependencyType.PULL.name());
            if (sbPull != null) {
                actionBean.setMissingDependencies(sbPull.toString());
            }
            if ((sbPush = dependencyMap.get(URIHandler.DependencyType.PUSH.name())) != null) {
                actionBean.setPushMissingDependencies(sbPush.toString());
            }
        }
        actionBean.setNominalTime(nominalTime);
        boolean isSla = CoordCommandUtils.materializeSLA(eAction, actionBean, conf);
        if (isSla) {
            actionBean.setSlaXml(XmlUtils.prettyPrint(eAction.getChild("action", eAction.getNamespace()).getChild("info", eAction.getNamespace("sla"))).toString());
        }
        if (!dryrun) {
            return XmlUtils.prettyPrint(eAction).toString();
        }
        return CoordCommandUtils.dryRunCoord(eAction, actionBean);
    }

    static String dryRunCoord(Element eAction, CoordinatorActionBean actionBean) throws Exception {
        boolean isLatestFutureDepAvailable;
        ActionDependency actionDep;
        String action = XmlUtils.prettyPrint(eAction).toString();
        StringBuilder actionXml = new StringBuilder(action);
        XConfiguration actionConf = new XConfiguration(new StringReader(actionBean.getRunConf()));
        boolean isPushDepAvailable = true;
        if (actionBean.getPushMissingDependencies() != null && (actionDep = DependencyChecker.checkForAvailability(actionBean.getPushMissingDependencies(), (Configuration)actionConf, true)).getMissingDependencies().size() != 0) {
            isPushDepAvailable = false;
        }
        boolean isPullDepAvailable = true;
        CoordActionInputCheckXCommand coordActionInput = new CoordActionInputCheckXCommand(actionBean.getId(), actionBean.getJobId());
        if (actionBean.getMissingDependencies() != null) {
            StringBuilder existList = new StringBuilder();
            StringBuilder nonExistList = new StringBuilder();
            StringBuilder nonResolvedList = new StringBuilder();
            CoordCommandUtils.getResolvedList(actionBean.getMissingDependencies(), nonExistList, nonResolvedList);
            isPullDepAvailable = coordActionInput.checkInput(actionXml, existList, nonExistList, actionConf);
        }
        if (isPullDepAvailable && isPushDepAvailable && (isLatestFutureDepAvailable = coordActionInput.checkUnResolvedInput(actionXml, actionConf))) {
            String newActionXml = CoordActionInputCheckXCommand.resolveCoordConfiguration(actionXml, actionConf, actionBean.getId());
            actionXml.replace(0, actionXml.length(), newActionXml);
        }
        return actionXml.toString();
    }

    public static Map<String, StringBuilder> materializeDataEvents(List<Element> events, SyncCoordAction appInst, Configuration conf) throws Exception {
        if (events == null) {
            return null;
        }
        StringBuilder unresolvedList = new StringBuilder();
        HashMap<String, StringBuilder> dependencyMap = new HashMap<String, StringBuilder>();
        URIHandlerService uriService = Services.get().get(URIHandlerService.class);
        StringBuilder pullMissingDep = null;
        StringBuilder pushMissingDep = null;
        for (Element event : events) {
            String tmpUnresolved;
            StringBuilder instances = new StringBuilder();
            ELEvaluator eval = CoordELEvaluator.createInstancesELEvaluator(event, appInst, conf);
            CoordCommandUtils.resolveInstances(event, instances, appInst, conf, eval);
            CoordCommandUtils.resolveInstanceRange(event, instances, appInst, conf, eval);
            String resolvedList = CoordCommandUtils.separateResolvedAndUnresolved(event, instances);
            if (!resolvedList.isEmpty()) {
                Element uri = event.getChild("dataset", event.getNamespace()).getChild("uri-template", event.getNamespace());
                String uriTemplate = uri.getText();
                URI baseURI = uriService.getAuthorityWithScheme(uriTemplate);
                URIHandler handler = uriService.getURIHandler(baseURI);
                if (handler.getDependencyType(baseURI).equals((Object)URIHandler.DependencyType.PULL)) {
                    pullMissingDep = pullMissingDep == null ? new StringBuilder(resolvedList) : pullMissingDep.append("#").append(resolvedList);
                } else {
                    StringBuilder stringBuilder = pushMissingDep = pushMissingDep == null ? new StringBuilder(resolvedList) : pushMissingDep.append("#").append(resolvedList);
                }
            }
            if ((tmpUnresolved = event.getChildTextTrim(UNRESOLVED_INST_TAG, event.getNamespace())) == null) continue;
            if (unresolvedList.length() > 0) {
                unresolvedList.append("#");
            }
            unresolvedList.append(tmpUnresolved);
        }
        if (unresolvedList.length() > 0) {
            if (pullMissingDep == null) {
                pullMissingDep = new StringBuilder();
            }
            pullMissingDep.append(RESOLVED_UNRESOLVED_SEPARATOR).append((CharSequence)unresolvedList);
        }
        dependencyMap.put(URIHandler.DependencyType.PULL.name(), pullMissingDep);
        dependencyMap.put(URIHandler.DependencyType.PUSH.name(), pushMissingDep);
        return dependencyMap;
    }

    public static String getResolvedList(String missDepList, StringBuilder resolved, StringBuilder unresolved) {
        if (missDepList != null) {
            int index = missDepList.indexOf(RESOLVED_UNRESOLVED_SEPARATOR);
            if (index < 0) {
                resolved.append(missDepList);
            } else {
                resolved.append(missDepList.substring(0, index));
                unresolved.append(missDepList.substring(index + RESOLVED_UNRESOLVED_SEPARATOR.length()));
            }
        }
        return resolved.toString();
    }

    public static Date getNextValidActionTimeForCronFrequency(Date targetDate, CoordinatorJobBean coordJob) throws ParseException {
        String freq = coordJob.getFrequency();
        TimeZone tz = DateUtils.getOozieProcessingTimeZone();
        Object[] cronArray = freq.split(" ");
        Date nextTime = null;
        if (!cronArray[2].trim().equals("?") && !cronArray[4].trim().equals("?")) {
            if (cronArray[2].trim().equals("*") || cronArray[4].trim().equals("*")) {
                if (cronArray[2].trim().equals("*")) {
                    cronArray[2] = "?";
                } else {
                    cronArray[4] = "?";
                }
                freq = StringUtils.join((Object[])cronArray, (String)" ");
                CronExpression expr = new CronExpression("0 " + freq);
                expr.setTimeZone(tz);
                nextTime = expr.getNextValidTimeAfter(targetDate);
            } else {
                Object[] cronArray1 = freq.split(" ");
                Object[] cronArray2 = freq.split(" ");
                cronArray1[2] = "?";
                cronArray2[4] = "?";
                String freq1 = StringUtils.join((Object[])cronArray1, (String)" ");
                String freq2 = StringUtils.join((Object[])cronArray2, (String)" ");
                CronExpression expr1 = new CronExpression("0 " + freq1);
                expr1.setTimeZone(tz);
                CronExpression expr2 = new CronExpression("0 " + freq2);
                expr2.setTimeZone(tz);
                nextTime = expr1.getNextValidTimeAfter(targetDate);
                Date nextTime2 = expr2.getNextValidTimeAfter(targetDate);
                nextTime = nextTime.compareTo(nextTime2) < 0 ? nextTime : nextTime2;
            }
        } else {
            CronExpression expr = new CronExpression("0 " + freq);
            expr.setTimeZone(tz);
            nextTime = expr.getNextValidTimeAfter(targetDate);
        }
        return nextTime;
    }
}

