/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.AppType;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.StartXCommand;
import org.apache.oozie.command.wf.SubmitXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.sla.SLAOperations;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.util.ConfigUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.ELUtils;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.WorkflowLib;
import org.apache.oozie.workflow.lite.NodeHandler;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ReRunXCommand
extends WorkflowXCommand<Void> {
    private final String jobId;
    private Configuration conf;
    private final Set<String> nodesToSkip = new HashSet<String>();
    public static final String TO_SKIP = "TO_SKIP";
    private WorkflowJobBean wfBean;
    private List<WorkflowActionBean> actions;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    private List<JsonBean> deleteList = new ArrayList<JsonBean>();
    private static final Set<String> DISALLOWED_DEFAULT_PROPERTIES = new HashSet<String>();
    private static final Set<String> DISALLOWED_USER_PROPERTIES = new HashSet<String>();

    public ReRunXCommand(String jobId, Configuration conf) {
        super("rerun", "rerun", 1);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
        this.conf = ParamChecker.notNull(conf, "conf");
    }

    @Override
    protected Void execute() throws CommandException {
        this.setupReRun();
        this.startWorkflow(this.jobId);
        return null;
    }

    private void startWorkflow(String jobId) throws CommandException {
        new StartXCommand(jobId).call();
    }

    private void setupReRun() throws CommandException {
        WorkflowInstance newWfInstance;
        InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
        LogUtils.setLogInfo(this.wfBean, this.logInfo);
        WorkflowInstance oldWfInstance = this.wfBean.getWorkflowInstance();
        String appPath = null;
        WorkflowAppService wps = Services.get().get(WorkflowAppService.class);
        try {
            XLog.Info.get().setParameter("TOKEN", this.conf.get("oozie.wf.log.token"));
            WorkflowApp app = wps.parseDef(this.conf, null);
            XConfiguration protoActionConf = wps.createProtoActionConf(this.conf, true);
            WorkflowLib workflowLib = Services.get().get(WorkflowStoreService.class).getWorkflowLibWithNoDB();
            appPath = this.conf.get("oozie.wf.application.path");
            URI uri = new URI(appPath);
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            JobConf fsConf = has.createJobConf(uri.getAuthority());
            FileSystem fs = has.createFileSystem(this.wfBean.getUser(), uri, (Configuration)fsConf);
            Path configDefault = null;
            Path path = new Path(uri.getPath());
            configDefault = !fs.isFile(path) ? new Path(path, "config-default.xml") : new Path(path.getParent(), "config-default.xml");
            if (fs.exists(configDefault)) {
                XConfiguration defaultConf = new XConfiguration((InputStream)fs.open(configDefault));
                PropertiesUtils.checkDisallowedProperties(defaultConf, DISALLOWED_DEFAULT_PROPERTIES);
                XConfiguration.injectDefaults(defaultConf, this.conf);
            }
            PropertiesUtils.checkDisallowedProperties(this.conf, DISALLOWED_USER_PROPERTIES);
            this.conf = ((XConfiguration)this.conf).resolve();
            HashMap<String, Date> actionEndTimes = new HashMap<String, Date>();
            for (WorkflowActionBean action : this.actions) {
                if (action.getEndTime() == null) continue;
                actionEndTimes.put(action.getName(), action.getEndTime());
            }
            try {
                newWfInstance = workflowLib.createInstance(app, this.conf, this.jobId, actionEndTimes);
            }
            catch (WorkflowException e) {
                throw new CommandException(e);
            }
            String appName = ELUtils.resolveAppName(app.getName(), this.conf);
            if (SLAService.isEnabled()) {
                Element wfElem = XmlUtils.parseXml(app.getDefinition());
                ELEvaluator evalSla = SubmitXCommand.createELEvaluatorForGroup(this.conf, "wf-sla-submit");
                Element eSla = XmlUtils.getSLAElement(wfElem);
                String jobSlaXml = null;
                if (eSla != null) {
                    jobSlaXml = SubmitXCommand.resolveSla(eSla, evalSla);
                }
                this.writeSLARegistration(wfElem, jobSlaXml, newWfInstance.getId(), this.conf.get("oozie.wf.parent.id"), this.conf.get("user.name"), appName, evalSla);
            }
            this.wfBean.setAppName(appName);
            this.wfBean.setProtoActionConf(protoActionConf.toXmlString());
        }
        catch (WorkflowException ex) {
            throw new CommandException(ex);
        }
        catch (IOException ex) {
            throw new CommandException(ErrorCode.E0803, ex.getMessage(), ex);
        }
        catch (HadoopAccessorException ex) {
            throw new CommandException(ex);
        }
        catch (URISyntaxException ex) {
            throw new CommandException(ErrorCode.E0711, appPath, ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E1007, ex.getMessage(), ex);
        }
        for (int i = 0; i < this.actions.size(); ++i) {
            if (!this.nodesToSkip.contains(this.actions.get(i).getName())) {
                this.deleteList.add(this.actions.get(i));
                this.LOG.info("Deleting Action[{0}] for re-run", this.actions.get(i).getId());
                continue;
            }
            this.copyActionData(newWfInstance, oldWfInstance);
        }
        this.wfBean.setAppPath(this.conf.get("oozie.wf.application.path"));
        this.wfBean.setConf(XmlUtils.prettyPrint(this.conf).toString());
        this.wfBean.setLogToken(this.conf.get("oozie.wf.log.token", ""));
        this.wfBean.setUser(this.conf.get("user.name"));
        String group = ConfigUtils.getWithDeprecatedCheck(this.conf, "oozie.job.acl", "group.name", null);
        this.wfBean.setGroup(group);
        this.wfBean.setExternalId(this.conf.get("oozie.wf.external.id"));
        this.wfBean.setEndTime(null);
        this.wfBean.setRun(this.wfBean.getRun() + 1);
        this.wfBean.setStatus(WorkflowJob.Status.PREP);
        this.wfBean.setWorkflowInstance(newWfInstance);
        try {
            this.wfBean.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_RERUN, this.wfBean));
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, this.deleteList);
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
    }

    private void writeSLARegistration(Element wfElem, String jobSlaXml, String id, String parentId, String user, String appName, ELEvaluator evalSla) throws JDOMException, CommandException {
        if (jobSlaXml != null && jobSlaXml.length() > 0) {
            Element eSla = XmlUtils.parseXml(jobSlaXml);
            SLAOperations.createSlaRegistrationEvent(eSla, this.jobId, parentId, AppType.WORKFLOW_JOB, user, appName, this.LOG, true);
        }
        for (Element action : wfElem.getChildren("action", wfElem.getNamespace())) {
            Element actionSla = XmlUtils.getSLAElement(action);
            if (actionSla == null) continue;
            String actionSlaXml = SubmitXCommand.resolveSla(actionSla, evalSla);
            actionSla = XmlUtils.parseXml(actionSlaXml);
            if (this.nodesToSkip.contains(action.getAttributeValue("name"))) continue;
            String actionId = Services.get().get(UUIDService.class).generateChildId(this.jobId, action.getAttributeValue("name") + "");
            SLAOperations.createSlaRegistrationEvent(actionSla, actionId, this.jobId, AppType.WORKFLOW_ACTION, user, appName, this.LOG, true);
        }
    }

    @Override
    protected void eagerLoadState() throws CommandException {
        try {
            this.wfBean = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_STATUS, this.jobId);
            this.actions = WorkflowActionQueryExecutor.getInstance().getList(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTIONS_FOR_WORKFLOW_RERUN, this.jobId);
            if (this.conf != null) {
                if (!this.conf.getBoolean("oozie.wf.rerun.failnodes", false)) {
                    Collection skipNodes = this.conf.getStringCollection("oozie.wf.rerun.skip.nodes");
                    for (String str : skipNodes) {
                        this.nodesToSkip.add(str.trim());
                    }
                    this.LOG.debug("Skipnode size :" + this.nodesToSkip.size());
                } else {
                    for (WorkflowActionBean action : this.actions) {
                        if (action.getStatus() != WorkflowAction.Status.OK) continue;
                        this.nodesToSkip.add(action.getName());
                    }
                    this.LOG.debug("Skipnode size are to rerun from FAIL nodes :" + this.nodesToSkip.size());
                }
                StringBuilder tmp = new StringBuilder();
                for (String node : this.nodesToSkip) {
                    tmp.append(node).append(",");
                }
                this.LOG.debug("SkipNode List :" + tmp);
            }
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex.getMessage(), ex);
        }
    }

    @Override
    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
        if (!(this.wfBean.getStatus().equals((Object)WorkflowJob.Status.FAILED) || this.wfBean.getStatus().equals((Object)WorkflowJob.Status.KILLED) || this.wfBean.getStatus().equals((Object)WorkflowJob.Status.SUCCEEDED))) {
            throw new CommandException(ErrorCode.E0805, this.wfBean.getStatus());
        }
        HashSet<String> unmachedNodes = new HashSet<String>(this.nodesToSkip);
        for (WorkflowActionBean action : this.actions) {
            if (!this.nodesToSkip.contains(action.getName())) continue;
            if (!action.getStatus().equals((Object)WorkflowAction.Status.OK) && !action.getStatus().equals((Object)WorkflowAction.Status.ERROR)) {
                throw new CommandException(ErrorCode.E0806, action.getName());
            }
            unmachedNodes.remove(action.getName());
        }
        if (unmachedNodes.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (String s : unmachedNodes) {
                sb.append(separator).append(s);
                separator = ",";
            }
            throw new CommandException(ErrorCode.E0807, sb);
        }
    }

    private void copyActionData(WorkflowInstance newWfInstance, WorkflowInstance oldWfInstance) {
        Map<Object, Object> oldVars = new HashMap();
        HashMap<String, String> newVars = new HashMap<String, String>();
        oldVars = oldWfInstance.getAllVars();
        for (String string : oldVars.keySet()) {
            String actionName = string.split("#")[0];
            if (!this.nodesToSkip.contains(actionName)) continue;
            newVars.put(string, (String)oldVars.get(string));
        }
        for (String string : this.nodesToSkip) {
            newVars.put(string + "#" + TO_SKIP, "true");
            String visitedFlag = NodeHandler.getLoopFlag(string);
            if (!newVars.containsKey(visitedFlag)) continue;
            newVars.remove(visitedFlag);
        }
        newWfInstance.setAllVars(newVars);
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.wfBean = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_RERUN, this.jobId);
            this.actions = WorkflowActionQueryExecutor.getInstance().getList(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTIONS_FOR_WORKFLOW_RERUN, this.jobId);
        }
        catch (JPAExecutorException jpe) {
            throw new CommandException(jpe);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        this.eagerVerifyPrecondition();
    }

    static {
        String[] badUserProps = new String[]{"DAYS", "HOURS", "MINUTES", "KB", "MB", "GB", "TB", "PB", "RECORDS", "MAP_IN", "MAP_OUT", "REDUCE_IN", "REDUCE_OUT", "GROUPS"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_USER_PROPERTIES);
        String[] badDefaultProps = new String[]{"user.name"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_DEFAULT_PROPERTIES);
        PropertiesUtils.createPropertySet(badDefaultProps, DISALLOWED_DEFAULT_PROPERTIES);
    }
}

