/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.trans;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannelFileWriter;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.util.CurrentDirectoryResolver;
import org.pentaho.di.core.util.FileUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.DelegationListener;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImportLocation;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.cluster.TransSplitter;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryTrans
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryTrans.class;
    private String transname;
    private String filename;
    private String directory;
    private ObjectId transObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    public String[] arguments;
    public boolean argFromPrevious;
    public boolean paramsFromPrevious;
    public boolean execPerRow;
    public String[] parameters;
    public String[] parameterFieldNames;
    public String[] parameterValues;
    public boolean clearResultRows;
    public boolean clearResultFiles;
    public boolean createParentFolder;
    public boolean setLogfile;
    public boolean setAppendLogfile;
    public String logfile;
    public String logext;
    public boolean addDate;
    public boolean addTime;
    public LogLevel logFileLevel;
    private String directoryPath;
    private boolean clustering;
    public boolean waitingToFinish = true;
    public boolean followingAbortRemotely;
    private String remoteSlaveServerName;
    private boolean passingAllParameters = true;
    private boolean loggingRemoteWork;
    private Trans trans;

    public JobEntryTrans(String name) {
        super(name, "");
    }

    public JobEntryTrans() {
        this("");
        this.clear();
    }

    private void allocateArgs(int nrArgs) {
        this.arguments = new String[nrArgs];
    }

    private void allocateParams(int nrParameters) {
        this.parameters = new String[nrParameters];
        this.parameterFieldNames = new String[nrParameters];
        this.parameterValues = new String[nrParameters];
    }

    @Override
    public Object clone() {
        JobEntryTrans je = (JobEntryTrans)super.clone();
        if (this.arguments != null) {
            int nrArgs = this.arguments.length;
            je.allocateArgs(nrArgs);
            System.arraycopy(this.arguments, 0, je.arguments, 0, nrArgs);
        }
        if (this.parameters != null) {
            int nrParameters = this.parameters.length;
            je.allocateParams(nrParameters);
            System.arraycopy(this.parameters, 0, je.parameters, 0, nrParameters);
            System.arraycopy(this.parameterFieldNames, 0, je.parameterFieldNames, 0, nrParameters);
            System.arraycopy(this.parameterValues, 0, je.parameterValues, 0, nrParameters);
        }
        return je;
    }

    public void setFileName(String n) {
        this.filename = n;
    }

    @Deprecated
    public String getFileName() {
        return this.filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    public void setTransname(String transname) {
        this.transname = transname;
    }

    public String getTransname() {
        return this.transname;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getLogFilename() {
        String retval = "";
        if (this.setLogfile) {
            SimpleDateFormat sdf;
            retval = retval + (this.logfile == null ? "" : this.logfile);
            Calendar cal = Calendar.getInstance();
            if (this.addDate) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.addTime) {
                sdf = new SimpleDateFormat("HHmmss");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.logext != null && this.logext.length() > 0) {
                retval = retval + "." + this.logext;
            }
        }
        return retval;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"trans_object_id", this.transObjectId == null ? null : this.transObjectId.toString()));
        if (this.rep != null && this.transObjectId != null) {
            try {
                RepositoryObject objectInformation = this.rep.getObjectInformation(this.transObjectId, RepositoryObjectType.TRANSFORMATION);
                if (objectInformation != null) {
                    this.transname = objectInformation.getName();
                    this.directory = objectInformation.getRepositoryDirectory().getPath();
                }
            }
            catch (KettleException objectInformation) {
                // empty catch block
            }
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"transname", (String)this.transname));
        if (this.directory != null) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directory));
        } else if (this.directoryPath != null) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directoryPath));
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"params_from_previous", (boolean)this.paramsFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"exec_per_row", (boolean)this.execPerRow));
        retval.append("      ").append(XMLHandler.addTagValue((String)"clear_rows", (boolean)this.clearResultRows));
        retval.append("      ").append(XMLHandler.addTagValue((String)"clear_files", (boolean)this.clearResultFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"set_logfile", (boolean)this.setLogfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logfile", (String)this.logfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logext", (String)this.logext));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.addDate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.addTime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"loglevel", this.logFileLevel != null ? this.logFileLevel.getCode() : null));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cluster", (boolean)this.clustering));
        retval.append("      ").append(XMLHandler.addTagValue((String)"slave_server_name", (String)this.remoteSlaveServerName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"set_append_logfile", (boolean)this.setAppendLogfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wait_until_finished", (boolean)this.waitingToFinish));
        retval.append("      ").append(XMLHandler.addTagValue((String)"follow_abort_remote", (boolean)this.followingAbortRemotely));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_parent_folder", (boolean)this.createParentFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logging_remote_work", (boolean)this.loggingRemoteWork));
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("      ").append(XMLHandler.addTagValue((String)("argument" + i), (String)this.arguments[i]));
            }
        }
        if (this.parameters != null) {
            retval.append("      ").append(XMLHandler.openTag((String)"parameters"));
            retval.append("        ").append(XMLHandler.addTagValue((String)"pass_all_parameters", (boolean)this.passingAllParameters));
            for (int i = 0; i < this.parameters.length; ++i) {
                retval.append("            ").append(XMLHandler.openTag((String)"parameter"));
                retval.append("            ").append(XMLHandler.addTagValue((String)"name", (String)this.parameters[i]));
                retval.append("            ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.parameterFieldNames[i]));
                retval.append("            ").append(XMLHandler.addTagValue((String)"value", (String)this.parameterValues[i]));
                retval.append("            ").append(XMLHandler.closeTag((String)"parameter"));
            }
            retval.append("      ").append(XMLHandler.closeTag((String)"parameters"));
        }
        return retval.toString();
    }

    private void checkObjectLocationSpecificationMethod() {
        if (this.specificationMethod == null) {
            this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
            if (!Const.isEmpty((String)this.filename)) {
                this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
            } else if (this.transObjectId != null) {
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
            } else if (!Const.isEmpty((String)this.transname)) {
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
            }
        }
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            String method = XMLHandler.getTagValue((Node)entrynode, (String)"specification_method");
            this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
            String transId = XMLHandler.getTagValue((Node)entrynode, (String)"trans_object_id");
            this.transObjectId = Const.isEmpty((String)transId) ? null : new StringObjectId(transId);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.transname = XMLHandler.getTagValue((Node)entrynode, (String)"transname");
            this.directory = XMLHandler.getTagValue((Node)entrynode, (String)"directory");
            if (rep != null && rep.isConnected() && !Const.isEmpty((String)this.transname)) {
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
            }
            this.checkObjectLocationSpecificationMethod();
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.paramsFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"params_from_previous"));
            this.execPerRow = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"exec_per_row"));
            this.clearResultRows = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"clear_rows"));
            this.clearResultFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"clear_files"));
            this.setLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"set_logfile"));
            this.addDate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.addTime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.logfile = XMLHandler.getTagValue((Node)entrynode, (String)"logfile");
            this.logext = XMLHandler.getTagValue((Node)entrynode, (String)"logext");
            this.logFileLevel = LogLevel.getLogLevelForCode((String)XMLHandler.getTagValue((Node)entrynode, (String)"loglevel"));
            this.clustering = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"cluster"));
            this.createParentFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_parent_folder"));
            this.loggingRemoteWork = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"logging_remote_work"));
            this.remoteSlaveServerName = XMLHandler.getTagValue((Node)entrynode, (String)"slave_server_name");
            this.setAppendLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"set_append_logfile"));
            String wait = XMLHandler.getTagValue((Node)entrynode, (String)"wait_until_finished");
            this.waitingToFinish = Const.isEmpty((String)wait) ? true : "Y".equalsIgnoreCase(wait);
            this.followingAbortRemotely = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"follow_abort_remote"));
            int argnr = 0;
            while (XMLHandler.getTagValue((Node)entrynode, (String)("argument" + argnr)) != null) {
                ++argnr;
            }
            this.allocateArgs(argnr);
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = XMLHandler.getTagValue((Node)entrynode, (String)("argument" + a));
            }
            Node parametersNode = XMLHandler.getSubNode((Node)entrynode, (String)"parameters");
            String passAll = XMLHandler.getTagValue((Node)parametersNode, (String)"pass_all_parameters");
            this.passingAllParameters = Const.isEmpty((String)passAll) || "Y".equalsIgnoreCase(passAll);
            int nrParameters = XMLHandler.countNodes((Node)parametersNode, (String)"parameter");
            this.allocateParams(nrParameters);
            for (int i = 0; i < nrParameters; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)parametersNode, (String)"parameter", (int)i);
                this.parameters[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.parameterFieldNames[i] = XMLHandler.getTagValue((Node)knode, (String)"stream_name");
                this.parameterValues[i] = XMLHandler.getTagValue((Node)knode, (String)"value");
            }
        }
        catch (KettleException e) {
            throw new KettleXMLException("Unable to load job entry of type 'trans' from XML node", (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            String method = rep.getJobEntryAttributeString(id_jobentry, "specification_method");
            this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
            String transId = rep.getJobEntryAttributeString(id_jobentry, "trans_object_id");
            this.transObjectId = Const.isEmpty((String)transId) ? null : new StringObjectId(transId);
            this.transname = rep.getJobEntryAttributeString(id_jobentry, "name");
            this.directory = rep.getJobEntryAttributeString(id_jobentry, "dir_path");
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "file_name");
            this.checkObjectLocationSpecificationMethod();
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.paramsFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "params_from_previous");
            this.execPerRow = rep.getJobEntryAttributeBoolean(id_jobentry, "exec_per_row");
            this.clearResultRows = rep.getJobEntryAttributeBoolean(id_jobentry, "clear_rows", true);
            this.clearResultFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "clear_files", true);
            this.setLogfile = rep.getJobEntryAttributeBoolean(id_jobentry, "set_logfile");
            this.addDate = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.addTime = rep.getJobEntryAttributeBoolean(id_jobentry, "add_time");
            this.logfile = rep.getJobEntryAttributeString(id_jobentry, "logfile");
            this.logext = rep.getJobEntryAttributeString(id_jobentry, "logext");
            this.logFileLevel = LogLevel.getLogLevelForCode((String)rep.getJobEntryAttributeString(id_jobentry, "loglevel"));
            this.clustering = rep.getJobEntryAttributeBoolean(id_jobentry, "cluster");
            this.createParentFolder = rep.getJobEntryAttributeBoolean(id_jobentry, "create_parent_folder");
            this.remoteSlaveServerName = rep.getJobEntryAttributeString(id_jobentry, "slave_server_name");
            this.setAppendLogfile = rep.getJobEntryAttributeBoolean(id_jobentry, "set_append_logfile");
            this.waitingToFinish = rep.getJobEntryAttributeBoolean(id_jobentry, "wait_until_finished", true);
            this.followingAbortRemotely = rep.getJobEntryAttributeBoolean(id_jobentry, "follow_abort_remote");
            this.loggingRemoteWork = rep.getJobEntryAttributeBoolean(id_jobentry, "logging_remote_work");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "argument");
            this.allocateArgs(argnr);
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "argument");
            }
            int parameternr = rep.countNrJobEntryAttributes(id_jobentry, "parameter_name");
            this.allocateParams(parameternr);
            for (int a = 0; a < parameternr; ++a) {
                this.parameters[a] = rep.getJobEntryAttributeString(id_jobentry, a, "parameter_name");
                this.parameterFieldNames[a] = rep.getJobEntryAttributeString(id_jobentry, a, "parameter_stream_name");
                this.parameterValues[a] = rep.getJobEntryAttributeString(id_jobentry, a, "parameter_value");
            }
            this.passingAllParameters = rep.getJobEntryAttributeBoolean(id_jobentry, "pass_all_parameters", true);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'trans' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            int i;
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "trans_object_id", this.transObjectId == null ? null : this.transObjectId.toString());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "name", this.getTransname());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "dir_path", this.getDirectory() != null ? this.getDirectory() : "");
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "file_name", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "params_from_previous", this.paramsFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "exec_per_row", this.execPerRow);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "clear_rows", this.clearResultRows);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "clear_files", this.clearResultFiles);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "set_logfile", this.setLogfile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_date", this.addDate);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_time", this.addTime);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logfile", this.logfile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logext", this.logext);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "loglevel", this.logFileLevel != null ? this.logFileLevel.getCode() : null);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "cluster", this.clustering);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "slave_server_name", this.remoteSlaveServerName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "set_append_logfile", this.setAppendLogfile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wait_until_finished", this.waitingToFinish);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "follow_abort_remote", this.followingAbortRemotely);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "create_parent_folder", this.createParentFolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logging_remote_work", this.loggingRemoteWork);
            if (this.arguments != null) {
                for (i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "argument", this.arguments[i]);
                }
            }
            if (this.parameters != null) {
                for (i = 0; i < this.parameters.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "parameter_name", this.parameters[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "parameter_stream_name", Const.NVL((String)this.parameterFieldNames[i], (String)""));
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "parameter_value", Const.NVL((String)this.parameterValues[i], (String)""));
                }
            }
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "pass_all_parameters", this.passingAllParameters);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'trans' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
        this.transname = null;
        this.filename = null;
        this.directory = null;
        this.arguments = null;
        this.argFromPrevious = false;
        this.execPerRow = false;
        this.addDate = false;
        this.addTime = false;
        this.logfile = null;
        this.logext = null;
        this.setLogfile = false;
        this.clearResultRows = false;
        this.clearResultFiles = false;
        this.remoteSlaveServerName = null;
        this.setAppendLogfile = false;
        this.waitingToFinish = true;
        this.followingAbortRemotely = false;
        this.createParentFolder = false;
        this.logFileLevel = LogLevel.BASIC;
    }

    @Override
    public Result execute(Result result, int nr) throws KettleException {
        result.setEntryNr((long)nr);
        LogChannelFileWriter logChannelFileWriter = null;
        LogLevel transLogLevel = this.parentJob.getLogLevel();
        String realLogFilename = "";
        if (this.setLogfile) {
            transLogLevel = this.logFileLevel;
            realLogFilename = this.environmentSubstitute(this.getLogFilename());
            if (Const.isEmpty((String)realLogFilename)) {
                this.logError(BaseMessages.getString(PKG, (String)"JobTrans.Exception.LogFilenameMissing", (String[])new String[0]));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            if (!FileUtil.createParentFolder(PKG, realLogFilename, this.createParentFolder, this.getLogChannel(), this)) {
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            try {
                logChannelFileWriter = new LogChannelFileWriter(this.getLogChannelId(), KettleVFS.getFileObject((String)realLogFilename), this.setAppendLogfile);
                logChannelFileWriter.startLogging();
            }
            catch (KettleException e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobTrans.Error.UnableOpenAppender", (String[])new String[]{realLogFilename, e.toString()}));
                this.logError(Const.getStackTracker((Throwable)e));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
        }
        SlaveServer remoteSlaveServer = null;
        if (!Const.isEmpty((String)this.remoteSlaveServerName)) {
            String realRemoteSlaveServerName = this.environmentSubstitute(this.remoteSlaveServerName);
            remoteSlaveServer = this.parentJob.getJobMeta().findSlaveServer(realRemoteSlaveServerName);
            if (remoteSlaveServer == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JobTrans.Exception.UnableToFindRemoteSlaveServer", (String[])new String[]{realRemoteSlaveServerName}));
            }
        }
        switch (this.specificationMethod) {
            case FILENAME: {
                if (!this.isDetailed()) break;
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobTrans.Log.OpeningTrans", (String[])new String[]{this.environmentSubstitute(this.getFilename())}));
                break;
            }
            case REPOSITORY_BY_NAME: {
                if (!this.isDetailed()) break;
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobTrans.Log.OpeningTransInDirec", (String[])new String[]{this.environmentSubstitute(this.getFilename()), this.environmentSubstitute(this.directory)}));
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                if (!this.isDetailed()) break;
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobTrans.Log.OpeningTransByReference", (Object[])new Object[]{this.transObjectId}));
                break;
            }
        }
        TransMeta transMeta = null;
        try {
            transMeta = this.getTransMeta(this.rep, this.metaStore, this);
        }
        catch (KettleException e) {
            this.logError(Const.getStackTracker((Throwable)e));
            result.setNrErrors(1L);
            result.setResult(false);
            return result;
        }
        int iteration = 0;
        String[] args1 = this.arguments;
        if (args1 == null || args1.length == 0) {
            args1 = this.parentJob.getArguments();
        }
        String[] args = null;
        if (args1 != null) {
            args = new String[args1.length];
            for (int idx = 0; idx < args1.length; ++idx) {
                args[idx] = this.environmentSubstitute(args1[idx]);
            }
        }
        RowMetaAndData resultRow = null;
        boolean first = true;
        ArrayList rows = new ArrayList(result.getRows());
        while (first && !this.execPerRow || this.execPerRow && rows != null && iteration < rows.size() && result.getNrErrors() == 0L && !this.parentJob.isStopped()) {
            block83: {
                if (this.execPerRow) {
                    result.getRows().clear();
                }
                resultRow = rows != null && this.execPerRow ? (RowMetaAndData)rows.get(iteration) : null;
                NamedParamsDefault namedParam = new NamedParamsDefault();
                if (this.parameters != null) {
                    for (int idx = 0; idx < this.parameters.length; ++idx) {
                        String value;
                        if (Const.isEmpty((String)this.parameters[idx])) continue;
                        namedParam.addParameterDefinition(this.parameters[idx], "", "Job entry runtime");
                        if (Const.isEmpty((String)Const.trim((String)this.parameterFieldNames[idx]))) {
                            value = Const.NVL((String)this.environmentSubstitute(this.parameterValues[idx]), (String)"");
                            namedParam.setParameterValue(this.parameters[idx], value);
                            continue;
                        }
                        value = "";
                        if (resultRow != null) {
                            value = resultRow.getString(this.parameterFieldNames[idx], "");
                        }
                        namedParam.setParameterValue(this.parameters[idx], value);
                    }
                }
                first = false;
                Result previousResult = result;
                try {
                    String fieldValue;
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobTrans.StartingTrans", (String[])new String[]{this.getFilename(), this.getName(), this.getDescription()}));
                    }
                    if (this.clearResultRows) {
                        previousResult.setRows(new ArrayList());
                    }
                    if (this.clearResultFiles) {
                        previousResult.getResultFiles().clear();
                    }
                    if (this.execPerRow) {
                        if (this.argFromPrevious) {
                            args = null;
                            if (resultRow != null) {
                                args = new String[resultRow.size()];
                                for (int i = 0; i < resultRow.size(); ++i) {
                                    args[i] = resultRow.getString(i, null);
                                }
                            }
                        } else {
                            ArrayList<RowMetaAndData> newList = new ArrayList<RowMetaAndData>();
                            newList.add(resultRow);
                            previousResult.getRows().addAll(newList);
                        }
                        if (this.paramsFromPrevious && this.parameters != null) {
                            for (int idx = 0; idx < this.parameters.length; ++idx) {
                                if (Const.isEmpty((String)this.parameters[idx])) continue;
                                if (Const.isEmpty((String)Const.trim((String)this.parameterFieldNames[idx]))) {
                                    namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.environmentSubstitute(this.parameterValues[idx]), (String)""));
                                    continue;
                                }
                                fieldValue = "";
                                if (resultRow != null) {
                                    fieldValue = resultRow.getString(this.parameterFieldNames[idx], "");
                                }
                                namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)fieldValue, (String)""));
                            }
                        }
                    } else {
                        if (this.argFromPrevious) {
                            args = null;
                            if (resultRow != null) {
                                args = new String[resultRow.size()];
                                for (int i = 0; i < resultRow.size(); ++i) {
                                    args[i] = resultRow.getString(i, null);
                                }
                            }
                        }
                        if (this.paramsFromPrevious && this.parameters != null) {
                            for (int idx = 0; idx < this.parameters.length; ++idx) {
                                if (Const.isEmpty((String)this.parameters[idx])) continue;
                                if (Const.isEmpty((String)Const.trim((String)this.parameterFieldNames[idx]))) {
                                    namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.environmentSubstitute(this.parameterValues[idx]), (String)""));
                                    continue;
                                }
                                fieldValue = "";
                                if (resultRow != null) {
                                    fieldValue = resultRow.getString(this.parameterFieldNames[idx], "");
                                }
                                namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)fieldValue, (String)""));
                            }
                        }
                    }
                    transMeta.clearParameters();
                    String[] parameterNames = transMeta.listParameters();
                    for (int idx = 0; idx < parameterNames.length; ++idx) {
                        String parentValue;
                        String thisValue = namedParam.getParameterValue(parameterNames[idx]);
                        if (!Const.isEmpty((String)thisValue)) {
                            transMeta.setParameterValue(parameterNames[idx], thisValue);
                            continue;
                        }
                        if (!this.isPassingAllParameters() || Const.isEmpty((String)(parentValue = this.parentJob.getParameterValue(parameterNames[idx])))) continue;
                        transMeta.setParameterValue(parameterNames[idx], parentValue);
                    }
                    if (this.clustering) {
                        long errors;
                        TransSplitter transSplitter;
                        block82: {
                            TransExecutionConfiguration executionConfiguration = new TransExecutionConfiguration();
                            executionConfiguration.setClusterPosting(true);
                            executionConfiguration.setClusterPreparing(true);
                            executionConfiguration.setClusterStarting(true);
                            executionConfiguration.setClusterShowingTransformation(false);
                            executionConfiguration.setSafeModeEnabled(false);
                            executionConfiguration.setRepository(this.rep);
                            executionConfiguration.setLogLevel(transLogLevel);
                            executionConfiguration.setPreviousResult(previousResult);
                            executionConfiguration.setVariables(transMeta);
                            executionConfiguration.setArgumentStrings(args);
                            if (this.parentJob.getJobMeta().isBatchIdPassed()) {
                                executionConfiguration.setPassedBatchId(this.parentJob.getPassedBatchId());
                            }
                            transSplitter = null;
                            errors = 0L;
                            try {
                                transSplitter = Trans.executeClustered(transMeta, executionConfiguration);
                                errors += Trans.monitorClusteredTransformation(this.log, transSplitter, this.parentJob);
                            }
                            catch (Exception e) {
                                this.logError("Error during clustered execution. Cleaning up clustered execution.", e);
                                ++errors;
                                if (transSplitter != null) {
                                    Trans.cleanupCluster(this.log, transSplitter);
                                }
                                SlaveServer master = null;
                                block29: for (StepMeta stepMeta : transMeta.getSteps()) {
                                    if (!stepMeta.isClustered()) continue;
                                    for (SlaveServer slaveServer : stepMeta.getClusterSchema().getSlaveServers()) {
                                        if (!slaveServer.isMaster()) continue;
                                        master = slaveServer;
                                        continue block29;
                                    }
                                }
                                if (master == null) break block82;
                                master.deAllocateServerSockets(transMeta.getName(), null);
                            }
                        }
                        result.clear();
                        if (transSplitter != null) {
                            Result clusterResult = Trans.getClusteredTransformationResult(this.log, transSplitter, this.parentJob, this.loggingRemoteWork);
                            result.add(clusterResult);
                        }
                        result.setNrErrors(result.getNrErrors() + errors);
                        break block83;
                    }
                    if (remoteSlaveServer != null) {
                        remoteSlaveServer.shareVariablesWith(this);
                        TransExecutionConfiguration transExecutionConfiguration = new TransExecutionConfiguration();
                        transExecutionConfiguration.setPreviousResult(previousResult.clone());
                        transExecutionConfiguration.setArgumentStrings(args);
                        transExecutionConfiguration.setVariables(this);
                        transExecutionConfiguration.setRemoteServer(remoteSlaveServer);
                        transExecutionConfiguration.setLogLevel(transLogLevel);
                        transExecutionConfiguration.setRepository(this.rep);
                        transExecutionConfiguration.setLogFileName(realLogFilename);
                        transExecutionConfiguration.setSetAppendLogfile(this.setAppendLogfile);
                        transExecutionConfiguration.setSetLogfile(this.setLogfile);
                        Map<String, String> params = transExecutionConfiguration.getParams();
                        for (String param : transMeta.listParameters()) {
                            String value = Const.NVL((String)transMeta.getParameterValue(param), (String)Const.NVL((String)transMeta.getParameterDefault(param), (String)transMeta.getVariable(param)));
                            params.put(param, value);
                        }
                        if (this.parentJob.getJobMeta().isBatchIdPassed()) {
                            transExecutionConfiguration.setPassedBatchId(this.parentJob.getPassedBatchId());
                        }
                        String carteObjectId = Trans.sendToSlaveServer(transMeta, transExecutionConfiguration, this.rep, this.metaStore);
                        SlaveServerTransStatus transStatus = null;
                        while (!this.parentJob.isStopped() && this.waitingToFinish) {
                            block84: {
                                try {
                                    transStatus = remoteSlaveServer.getTransStatus(transMeta.getName(), carteObjectId, 0);
                                    if (!transStatus.isRunning()) {
                                        Result remoteResult = transStatus.getResult();
                                        result.clear();
                                        result.add(remoteResult);
                                        if (remoteResult.isStopped()) {
                                            result.setNrErrors(result.getNrErrors() + 1L);
                                        }
                                        remoteSlaveServer.cleanupTransformation(transMeta.getName(), carteObjectId);
                                    }
                                    break block84;
                                }
                                catch (Exception e1) {
                                    this.logError(BaseMessages.getString(PKG, (String)"JobTrans.Error.UnableContactSlaveServer", (String[])new String[]{"" + remoteSlaveServer, transMeta.getName()}), e1);
                                    result.setNrErrors(result.getNrErrors() + 1L);
                                }
                                break;
                            }
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (this.parentJob.isStopped() && (transStatus == null || transStatus.isRunning())) {
                            remoteSlaveServer.stopTransformation(transMeta.getName(), transStatus.getId());
                            remoteSlaveServer.cleanupTransformation(transMeta.getName(), transStatus.getId());
                            result.setNrErrors(result.getNrErrors() + 1L);
                        }
                        break block83;
                    }
                    this.trans = new Trans(transMeta, this);
                    this.trans.setSocketRepository(this.parentJob.getSocketRepository());
                    if (this.parentJob.getJobMeta().isBatchIdPassed()) {
                        this.trans.setPassedBatchId(this.parentJob.getPassedBatchId());
                    }
                    this.trans.setParentJob(this.parentJob);
                    this.trans.setParentVariableSpace(this.parentJob);
                    this.trans.setLogLevel(transLogLevel);
                    this.trans.setPreviousResult(previousResult);
                    this.trans.setArguments(this.arguments);
                    this.trans.setRepository(this.rep);
                    this.trans.setMetaStore(this.metaStore);
                    Job rootJob = this.parentJob;
                    while (rootJob.getParentJob() != null) {
                        rootJob = rootJob.getParentJob();
                    }
                    this.trans.setJobStartDate(rootJob.getStartDate());
                    this.trans.setJobEndDate(rootJob.getEndDate());
                    for (DelegationListener delegationListener : this.parentJob.getDelegationListeners()) {
                        delegationListener.transformationDelegationStarted(this.trans, new TransExecutionConfiguration());
                    }
                    try {
                        this.trans.execute(args);
                        while (!this.trans.isFinished() && this.trans.getErrors() == 0) {
                            if (this.parentJob.isStopped()) {
                                this.trans.stopAll();
                                break;
                            }
                            try {
                                Thread.sleep(0L, 500);
                            }
                            catch (InterruptedException i$) {}
                        }
                        this.trans.waitUntilFinished();
                        if (this.parentJob.isStopped() || this.trans.getErrors() != 0) {
                            this.trans.stopAll();
                            result.setNrErrors(1L);
                        }
                        Result newResult = this.trans.getResult();
                        result.clear();
                        result.add(newResult);
                        if (!Const.isEmpty((List)newResult.getRows())) {
                            result.setRows(newResult.getRows());
                        }
                        if (this.setLogfile) {
                            ResultFile resultFile = new ResultFile(1, KettleVFS.getFileObject((String)realLogFilename, (VariableSpace)this), this.parentJob.getJobname(), this.toString());
                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        }
                    }
                    catch (KettleException e) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobTrans.Error.UnablePrepareExec", (String[])new String[0]), e);
                        result.setNrErrors(1L);
                    }
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobTrans.ErrorUnableOpenTrans", (String[])new String[]{e.getMessage()}));
                    this.logError(Const.getStackTracker((Throwable)e));
                    result.setNrErrors(1L);
                }
            }
            ++iteration;
        }
        if (this.setLogfile && logChannelFileWriter != null) {
            logChannelFileWriter.stopLogging();
            ResultFile resultFile = new ResultFile(1, logChannelFileWriter.getLogFile(), this.parentJob.getJobname(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (logChannelFileWriter.getException() != null) {
                this.logError("Unable to open log file [" + this.getLogFilename() + "] : ");
                this.logError(Const.getStackTracker((Throwable)logChannelFileWriter.getException()));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
        }
        if (result.getNrErrors() == 0L) {
            result.setResult(true);
        } else {
            result.setResult(false);
        }
        return result;
    }

    @Deprecated
    public TransMeta getTransMeta(Repository rep, VariableSpace space) throws KettleException {
        return this.getTransMeta(rep, null, space);
    }

    /*
     * Unable to fully structure code
     */
    public TransMeta getTransMeta(Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        try {
            transMeta = null;
            r = new CurrentDirectoryResolver();
            tmpSpace = r.resolveCurrentDirectory(this.specificationMethod, space, rep, this.parentJob, this.getFilename());
            switch (1.$SwitchMap$org$pentaho$di$core$ObjectLocationSpecificationMethod[this.specificationMethod.ordinal()]) {
                case 1: {
                    realFilename = tmpSpace.environmentSubstitute(this.getFilename());
                    if (rep == null) ** GOTO lbl26
                    realFilename = r.normalizeSlashes(realFilename);
                    try {
                        dirStr = realFilename.substring(0, realFilename.lastIndexOf("/"));
                        tmpFilename = realFilename.substring(realFilename.lastIndexOf("/") + 1);
                        dir = rep.findDirectory(dirStr);
                        transMeta = rep.loadTransformation(tmpFilename, dir, null, true, null);
                    }
                    catch (KettleException ke) {
                        if (!realFilename.endsWith("ktr")) ** GOTO lbl26
                        try {
                            tmpFilename = realFilename.substring(realFilename.lastIndexOf("/") + 1, realFilename.indexOf(".ktr"));
                            dirStr = realFilename.substring(0, realFilename.lastIndexOf("/"));
                            dir = rep.findDirectory(dirStr);
                            transMeta = rep.loadTransformation(tmpFilename, dir, null, true, null);
                        }
                        catch (KettleException tmpFilename) {
                            // empty catch block
                        }
                    }
lbl26:
                    // 5 sources

                    if (transMeta != null) break;
                    this.logBasic("Loading transformation from XML file [" + realFilename + "]");
                    transMeta = new TransMeta(realFilename, metaStore, null, true, this, null);
                    break;
                }
                case 2: {
                    transname = tmpSpace.environmentSubstitute(this.getTransname());
                    realDirectory = tmpSpace.environmentSubstitute(this.getDirectory());
                    this.logBasic(BaseMessages.getString(JobEntryTrans.PKG, (String)"JobTrans.Log.LoadingTransRepDirec", (String[])new String[]{transname, realDirectory}));
                    if (rep != null) {
                        realDirectory = r.normalizeSlashes(realDirectory);
                        repositoryDirectory = rep.findDirectory(realDirectory);
                        transMeta = rep.loadTransformation(transname, repositoryDirectory, null, true, null);
                        break;
                    }
                    try {
                        transMeta = new TransMeta(realDirectory + "/" + transname, metaStore, null, true, this, null);
                        break;
                    }
                    catch (KettleException ke) {
                        try {
                            transMeta = new TransMeta(realDirectory + "/" + transname + "." + "ktr", metaStore, null, true, this, null);
                            break;
                        }
                        catch (KettleException ke2) {
                            throw new KettleException(BaseMessages.getString(JobEntryTrans.PKG, (String)"JobTrans.Exception.NoRepDefined", (String[])new String[0]), (Throwable)ke2);
                        }
                    }
                }
                case 3: {
                    if (this.transObjectId == null) {
                        throw new KettleException(BaseMessages.getString(JobEntryTrans.PKG, (String)"JobTrans.Exception.ReferencedTransformationIdIsNull", (String[])new String[0]));
                    }
                    if (rep == null) break;
                    transMeta = rep.loadTransformation(this.transObjectId, null);
                    break;
                }
                default: {
                    throw new KettleException("The specified object location specification method '" + this.specificationMethod + "' is not yet supported in this job entry.");
                }
            }
            if (transMeta != null) {
                transMeta.copyVariablesFrom(this);
                transMeta.setRepository(rep);
                transMeta.setMetaStore(metaStore);
            }
            return transMeta;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(JobEntryTrans.PKG, (String)"JobTrans.Exception.MetaDataLoad", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    @Override
    public List<SQLStatement> getSQLStatements(Repository repository, IMetaStore metaStore, VariableSpace space) throws KettleException {
        this.copyVariablesFrom(space);
        TransMeta transMeta = this.getTransMeta(repository, metaStore, this);
        return transMeta.getSQLStatements();
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public boolean isClustering() {
        return this.clustering;
    }

    public void setClustering(boolean clustering) {
        this.clustering = clustering;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (this.setLogfile) {
            JobEntryValidatorUtils.andValidator().validate(this, "logfile", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
        if (!Const.isEmpty((String)this.filename)) {
            JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        } else {
            JobEntryValidatorUtils.andValidator().validate(this, "transname", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
            JobEntryValidatorUtils.andValidator().validate(this, "directory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.filename)) {
            String realFileName = jobMeta.environmentSubstitute(this.filename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.ACTIONFILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        this.copyVariablesFrom(space);
        TransMeta transMeta = this.getTransMeta(repository, space);
        String proposedNewFilename = transMeta.exportResources(transMeta, definitions, namingInterface, repository, metaStore);
        String newFilename = "${Internal.Job.Filename.Directory}/" + proposedNewFilename;
        transMeta.setFilename(newFilename);
        transMeta.setRepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory());
        this.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
        this.filename = newFilename;
        return proposedNewFilename;
    }

    protected String getLogfile() {
        return this.logfile;
    }

    public String getRemoteSlaveServerName() {
        return this.remoteSlaveServerName;
    }

    public void setRemoteSlaveServerName(String remoteSlaveServerName) {
        this.remoteSlaveServerName = remoteSlaveServerName;
    }

    public boolean isWaitingToFinish() {
        return this.waitingToFinish;
    }

    public void setWaitingToFinish(boolean waitingToFinish) {
        this.waitingToFinish = waitingToFinish;
    }

    public boolean isFollowingAbortRemotely() {
        return this.followingAbortRemotely;
    }

    public void setFollowingAbortRemotely(boolean followingAbortRemotely) {
        this.followingAbortRemotely = followingAbortRemotely;
    }

    public boolean isLoggingRemoteWork() {
        return this.loggingRemoteWork;
    }

    public void setLoggingRemoteWork(boolean loggingRemoteWork) {
        this.loggingRemoteWork = loggingRemoteWork;
    }

    public boolean isPassingAllParameters() {
        return this.passingAllParameters;
    }

    public void setPassingAllParameters(boolean passingAllParameters) {
        this.passingAllParameters = passingAllParameters;
    }

    public Trans getTrans() {
        return this.trans;
    }

    public ObjectId getTransObjectId() {
        return this.transObjectId;
    }

    public void setTransObjectId(ObjectId transObjectId) {
        this.transObjectId = transObjectId;
    }

    public ObjectLocationSpecificationMethod getSpecificationMethod() {
        return this.specificationMethod;
    }

    public void setSpecificationMethod(ObjectLocationSpecificationMethod specificationMethod) {
        this.specificationMethod = specificationMethod;
    }

    @Override
    public boolean hasRepositoryReferences() {
        return this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
    }

    @Override
    public void lookupRepositoryReferences(Repository repository) throws KettleException {
        RepositoryDirectoryInterface repositoryDirectoryInterface = RepositoryImportLocation.getRepositoryImportLocation().findDirectory(this.directory);
        this.transObjectId = repository.getTransformationID(this.transname, repositoryDirectoryInterface);
    }

    @Override
    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"JobEntryTrans.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isTransformationDefined() {
        return !Const.isEmpty((String)this.filename) || this.transObjectId != null || !Const.isEmpty((String)this.directory) && !Const.isEmpty((String)this.transname);
    }

    @Override
    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isTransformationDefined()};
    }

    @Override
    public Object loadReferencedObject(int index, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        return this.getTransMeta(rep, metaStore, space);
    }
}

