/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.httppost;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.httppost.HTTPPOST;
import org.pentaho.di.trans.steps.httppost.HTTPPOSTData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class HTTPPOSTMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = HTTPPOSTMeta.class;
    public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_CLOSE_CONNECTIONS_TIME = -1;
    private String socketTimeout;
    private String connectionTimeout;
    private String closeIdleConnectionsTime;
    private static final String YES = "Y";
    private String url;
    private String[] argumentField;
    private String[] queryField;
    private String[] argumentParameter;
    private boolean[] argumentHeader;
    private String[] queryParameter;
    private String fieldName;
    private String resultCodeFieldName;
    private boolean urlInField;
    private String urlField;
    private String requestEntity;
    private String encoding;
    private boolean postafile;
    private String proxyHost;
    private String proxyPort;
    private String httpLogin;
    private String httpPassword;
    private String responseTimeFieldName;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String[] getArgumentField() {
        return this.argumentField;
    }

    public void setArgumentField(String[] argument) {
        this.argumentField = argument;
    }

    public String[] getQueryField() {
        return this.queryField;
    }

    public void setQueryField(String[] queryfield) {
        this.queryField = queryfield;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getCloseIdleConnectionsTime() {
        return this.closeIdleConnectionsTime;
    }

    public void setCloseIdleConnectionsTime(String closeIdleConnectionsTime) {
        this.closeIdleConnectionsTime = closeIdleConnectionsTime;
    }

    public String getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(String socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String[] getArgumentParameter() {
        return this.argumentParameter;
    }

    public void setArgumentParameter(String[] argumentDirection) {
        this.argumentParameter = argumentDirection;
    }

    public String[] getQueryParameter() {
        return this.queryParameter;
    }

    public void setQueryParameter(String[] queryParameter) {
        this.queryParameter = queryParameter;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String procedure) {
        this.url = procedure;
    }

    public boolean isUrlInField() {
        return this.urlInField;
    }

    public boolean isPostAFile() {
        return this.postafile;
    }

    public void setPostAFile(boolean postafile) {
        this.postafile = postafile;
    }

    public void setUrlInField(boolean urlInField) {
        this.urlInField = urlInField;
    }

    public String getUrlField() {
        return this.urlField;
    }

    public void setUrlField(String urlField) {
        this.urlField = urlField;
    }

    public void setRequestEntity(String requestEntity) {
        this.requestEntity = requestEntity;
    }

    public String getRequestEntity() {
        return this.requestEntity;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String resultName) {
        this.fieldName = resultName;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrargs) {
        this.argumentField = new String[nrargs];
        this.argumentParameter = new String[nrargs];
        this.argumentHeader = new boolean[nrargs];
    }

    public void allocateQuery(int nrqueryparams) {
        this.queryField = new String[nrqueryparams];
        this.queryParameter = new String[nrqueryparams];
    }

    @Override
    public Object clone() {
        HTTPPOSTMeta retval = (HTTPPOSTMeta)super.clone();
        int nrargs = this.argumentField.length;
        retval.allocate(nrargs);
        System.arraycopy(this.argumentField, 0, retval.argumentField, 0, nrargs);
        System.arraycopy(this.argumentParameter, 0, retval.argumentParameter, 0, nrargs);
        System.arraycopy(this.argumentHeader, 0, retval.argumentHeader, 0, nrargs);
        int nrqueryparams = this.queryField.length;
        retval.allocateQuery(nrqueryparams);
        System.arraycopy(this.queryField, 0, retval.queryField, 0, nrqueryparams);
        System.arraycopy(this.queryParameter, 0, retval.queryParameter, 0, nrqueryparams);
        return retval;
    }

    @Override
    public void setDefault() {
        int i;
        int nrargs = 0;
        this.allocate(nrargs);
        for (i = 0; i < nrargs; ++i) {
            this.argumentField[i] = "arg" + i;
            this.argumentParameter[i] = "arg";
            this.argumentHeader[i] = false;
        }
        int nrquery = 0;
        this.allocateQuery(nrquery);
        for (i = 0; i < nrquery; ++i) {
            this.queryField[i] = "query" + i;
            this.queryParameter[i] = "query";
        }
        this.fieldName = "result";
        this.resultCodeFieldName = "";
        this.responseTimeFieldName = "";
        this.postafile = false;
        this.socketTimeout = String.valueOf(10000);
        this.connectionTimeout = String.valueOf(10000);
        this.closeIdleConnectionsTime = String.valueOf(-1);
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaString v;
        if (!Const.isEmpty((String)this.fieldName)) {
            v = new ValueMetaString(space.environmentSubstitute(this.fieldName));
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
        if (!Const.isEmpty((String)this.resultCodeFieldName)) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.resultCodeFieldName));
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
        if (!Const.isEmpty((String)this.responseTimeFieldName)) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.responseTimeFieldName));
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"postafile", (boolean)this.postafile));
        retval.append("    " + XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XMLHandler.addTagValue((String)"url", (String)this.url));
        retval.append("    " + XMLHandler.addTagValue((String)"urlInField", (boolean)this.urlInField));
        retval.append("    " + XMLHandler.addTagValue((String)"urlField", (String)this.urlField));
        retval.append("    " + XMLHandler.addTagValue((String)"requestEntity", (String)this.requestEntity));
        retval.append("    " + XMLHandler.addTagValue((String)"httpLogin", (String)this.httpLogin));
        retval.append("    " + XMLHandler.addTagValue((String)"httpPassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.httpPassword)));
        retval.append("    " + XMLHandler.addTagValue((String)"proxyHost", (String)this.proxyHost));
        retval.append("    " + XMLHandler.addTagValue((String)"proxyPort", (String)this.proxyPort));
        retval.append("    " + XMLHandler.addTagValue((String)"socketTimeout", (String)this.socketTimeout));
        retval.append("    " + XMLHandler.addTagValue((String)"connectionTimeout", (String)this.connectionTimeout));
        retval.append("    " + XMLHandler.addTagValue((String)"closeIdleConnectionsTime", (String)this.closeIdleConnectionsTime));
        retval.append("    <lookup>" + Const.CR);
        for (i = 0; i < this.argumentField.length; ++i) {
            retval.append("      <arg>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.argumentField[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"parameter", (String)this.argumentParameter[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"header", (boolean)this.argumentHeader[i], (boolean)false));
            retval.append("        </arg>" + Const.CR);
        }
        for (i = 0; i < this.queryField.length; ++i) {
            retval.append("      <query>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.queryField[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"parameter", (String)this.queryParameter[i]));
            retval.append("        </query>" + Const.CR);
        }
        retval.append("      </lookup>" + Const.CR);
        retval.append("    <result>" + Const.CR);
        retval.append("      " + XMLHandler.addTagValue((String)"name", (String)this.fieldName));
        retval.append("      " + XMLHandler.addTagValue((String)"code", (String)this.resultCodeFieldName));
        retval.append("      " + XMLHandler.addTagValue((String)"response_time", (String)this.responseTimeFieldName));
        retval.append("      </result>" + Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.postafile = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"postafile"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.url = XMLHandler.getTagValue((Node)stepnode, (String)"url");
            this.urlInField = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"urlInField"));
            this.urlField = XMLHandler.getTagValue((Node)stepnode, (String)"urlField");
            this.requestEntity = XMLHandler.getTagValue((Node)stepnode, (String)"requestEntity");
            this.httpLogin = XMLHandler.getTagValue((Node)stepnode, (String)"httpLogin");
            this.httpPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"httpPassword"));
            this.proxyHost = XMLHandler.getTagValue((Node)stepnode, (String)"proxyHost");
            this.proxyPort = XMLHandler.getTagValue((Node)stepnode, (String)"proxyPort");
            this.socketTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"socketTimeout");
            this.connectionTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"connectionTimeout");
            this.closeIdleConnectionsTime = XMLHandler.getTagValue((Node)stepnode, (String)"closeIdleConnectionsTime");
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrargs = XMLHandler.countNodes((Node)lookup, (String)"arg");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                Node anode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"arg", (int)i);
                this.argumentField[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
                this.argumentParameter[i] = XMLHandler.getTagValue((Node)anode, (String)"parameter");
                this.argumentHeader[i] = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)anode, (String)"header"));
            }
            int nrquery = XMLHandler.countNodes((Node)lookup, (String)"query");
            this.allocateQuery(nrquery);
            for (int i = 0; i < nrquery; ++i) {
                Node anode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"query", (int)i);
                this.queryField[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
                this.queryParameter[i] = XMLHandler.getTagValue((Node)anode, (String)"parameter");
            }
            this.fieldName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"name");
            this.resultCodeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"code");
            this.responseTimeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"response_time");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.postafile = rep.getStepAttributeBoolean(id_step, "postafile");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.url = rep.getStepAttributeString(id_step, "url");
            this.urlInField = rep.getStepAttributeBoolean(id_step, "urlInField");
            this.urlField = rep.getStepAttributeString(id_step, "urlField");
            this.requestEntity = rep.getStepAttributeString(id_step, "requestEntity");
            this.httpLogin = rep.getStepAttributeString(id_step, "httpLogin");
            this.httpPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "httpPassword"));
            this.proxyHost = rep.getStepAttributeString(id_step, "proxyHost");
            this.proxyPort = rep.getStepAttributeString(id_step, "proxyPort");
            this.socketTimeout = rep.getStepAttributeString(id_step, "socketTimeout");
            this.connectionTimeout = rep.getStepAttributeString(id_step, "connectionTimeout");
            this.closeIdleConnectionsTime = rep.getStepAttributeString(id_step, "closeIdleConnectionsTime");
            int nrargs = rep.countNrStepAttributes(id_step, "arg_name");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                this.argumentField[i] = rep.getStepAttributeString(id_step, i, "arg_name");
                this.argumentParameter[i] = rep.getStepAttributeString(id_step, i, "arg_parameter");
                this.argumentHeader[i] = rep.getStepAttributeBoolean(id_step, i, "arg_header");
            }
            int nrquery = rep.countNrStepAttributes(id_step, "query_name");
            this.allocateQuery(nrquery);
            for (int i = 0; i < nrquery; ++i) {
                this.queryField[i] = rep.getStepAttributeString(id_step, i, "query_name");
                this.queryParameter[i] = rep.getStepAttributeString(id_step, i, "query_parameter");
            }
            this.fieldName = rep.getStepAttributeString(id_step, "result_name");
            this.resultCodeFieldName = rep.getStepAttributeString(id_step, "result_code");
            this.responseTimeFieldName = rep.getStepAttributeString(id_step, "response_time");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "postafile", this.postafile);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "url", this.url);
            rep.saveStepAttribute(id_transformation, id_step, "urlInField", this.urlInField);
            rep.saveStepAttribute(id_transformation, id_step, "urlField", this.urlField);
            rep.saveStepAttribute(id_transformation, id_step, "requestEntity", this.requestEntity);
            rep.saveStepAttribute(id_transformation, id_step, "httpLogin", this.httpLogin);
            rep.saveStepAttribute(id_transformation, id_step, "httpPassword", Encr.encryptPasswordIfNotUsingVariables((String)this.httpPassword));
            rep.saveStepAttribute(id_transformation, id_step, "proxyHost", this.proxyHost);
            rep.saveStepAttribute(id_transformation, id_step, "proxyPort", this.proxyPort);
            rep.saveStepAttribute(id_transformation, id_step, "socketTimeout", this.socketTimeout);
            rep.saveStepAttribute(id_transformation, id_step, "connectionTimeout", this.connectionTimeout);
            rep.saveStepAttribute(id_transformation, id_step, "closeIdleConnectionsTime", this.closeIdleConnectionsTime);
            for (i = 0; i < this.argumentField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "arg_name", this.argumentField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "arg_parameter", this.argumentParameter[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "arg_header", this.argumentHeader[i]);
            }
            for (i = 0; i < this.queryField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "query_name", this.queryField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "query_parameter", this.queryParameter[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "result_name", this.fieldName);
            rep.saveStepAttribute(id_transformation, id_step, "result_code", this.resultCodeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "response_time", this.responseTimeFieldName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = this.urlInField ? (Const.isEmpty((String)this.urlField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.CheckResult.UrlfieldMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.CheckResult.UrlfieldOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta)) : (Const.isEmpty((String)this.url) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.CheckResult.UrlMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.CheckResult.UrlOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta));
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new HTTPPOST(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new HTTPPOSTData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean[] getArgumentHeader() {
        return this.argumentHeader;
    }

    public void setArgumentHeader(boolean[] argumentHeader) {
        this.argumentHeader = argumentHeader;
    }

    public String getResultCodeFieldName() {
        return this.resultCodeFieldName;
    }

    public void setResultCodeFieldName(String resultCodeFieldName) {
        this.resultCodeFieldName = resultCodeFieldName;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setHttpLogin(String httpLogin) {
        this.httpLogin = httpLogin;
    }

    public String getHttpLogin() {
        return this.httpLogin;
    }

    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public String getResponseTimeFieldName() {
        return this.responseTimeFieldName;
    }

    public void setResponseTimeFieldName(String responseTimeFieldName) {
        this.responseTimeFieldName = responseTimeFieldName;
    }
}

