/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rowgenerator;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rowgenerator.RowGenerator;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class RowGeneratorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = RowGeneratorMeta.class;
    private boolean neverEnding;
    private String intervalInMs;
    private String rowTimeField;
    private String lastTimeField;
    private String rowLimit;
    private String[] currency;
    private String[] decimal;
    private String[] group;
    private String[] value;
    private String[] fieldName;
    private String[] fieldType;
    private String[] fieldFormat;
    private int[] fieldLength;
    private int[] fieldPrecision;
    private boolean[] setEmptyString;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldType = new String[nrfields];
        this.fieldFormat = new String[nrfields];
        this.fieldLength = new int[nrfields];
        this.fieldPrecision = new int[nrfields];
        this.currency = new String[nrfields];
        this.decimal = new String[nrfields];
        this.group = new String[nrfields];
        this.value = new String[nrfields];
        this.setEmptyString = new boolean[nrfields];
    }

    @Override
    public Object clone() {
        RowGeneratorMeta retval = (RowGeneratorMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, nrfields);
        System.arraycopy(this.fieldType, 0, retval.fieldType, 0, nrfields);
        System.arraycopy(this.fieldFormat, 0, retval.fieldFormat, 0, nrfields);
        System.arraycopy(this.fieldLength, 0, retval.fieldLength, 0, nrfields);
        System.arraycopy(this.fieldPrecision, 0, retval.fieldPrecision, 0, nrfields);
        System.arraycopy(this.currency, 0, retval.currency, 0, nrfields);
        System.arraycopy(this.decimal, 0, retval.decimal, 0, nrfields);
        System.arraycopy(this.group, 0, retval.group, 0, nrfields);
        System.arraycopy(this.value, 0, retval.value, 0, nrfields);
        System.arraycopy(this.setEmptyString, 0, retval.setEmptyString, 0, nrfields);
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldType[i] = XMLHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldFormat[i] = XMLHandler.getTagValue((Node)fnode, (String)"format");
                this.currency[i] = XMLHandler.getTagValue((Node)fnode, (String)"currency");
                this.decimal[i] = XMLHandler.getTagValue((Node)fnode, (String)"decimal");
                this.group[i] = XMLHandler.getTagValue((Node)fnode, (String)"group");
                this.value[i] = XMLHandler.getTagValue((Node)fnode, (String)"nullif");
                String slength = XMLHandler.getTagValue((Node)fnode, (String)"length");
                String sprecision = XMLHandler.getTagValue((Node)fnode, (String)"precision");
                this.fieldLength[i] = Const.toInt((String)slength, (int)-1);
                this.fieldPrecision[i] = Const.toInt((String)sprecision, (int)-1);
                String emptyString = XMLHandler.getTagValue((Node)fnode, (String)"set_empty_string");
                this.setEmptyString[i] = !Const.isEmpty((String)emptyString) && "Y".equalsIgnoreCase(emptyString);
            }
            this.rowLimit = XMLHandler.getTagValue((Node)stepnode, (String)"limit");
            this.neverEnding = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"never_ending"));
            this.intervalInMs = XMLHandler.getTagValue((Node)stepnode, (String)"interval_in_ms");
            this.rowTimeField = XMLHandler.getTagValue((Node)stepnode, (String)"row_time_field");
            this.lastTimeField = XMLHandler.getTagValue((Node)stepnode, (String)"last_time_field");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.allocate(nrfields);
        DecimalFormat decimalFormat = new DecimalFormat();
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = "Number";
            this.fieldFormat[i] = "\u00a40,000,000.00;\u00a4-0,000,000.00";
            this.fieldLength[i] = 9;
            this.fieldPrecision[i] = 2;
            this.currency[i] = decimalFormat.getDecimalFormatSymbols().getCurrencySymbol();
            this.decimal[i] = new String(new char[]{decimalFormat.getDecimalFormatSymbols().getDecimalSeparator()});
            this.group[i] = new String(new char[]{decimalFormat.getDecimalFormatSymbols().getGroupingSeparator()});
            this.value[i] = "-";
            this.setEmptyString[i] = false;
        }
        this.rowLimit = "10";
        this.neverEnding = false;
        this.intervalInMs = "5000";
        this.rowTimeField = "now";
        this.lastTimeField = "FiveSecondsAgo";
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        try {
            ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
            RowMetaAndData rowMetaAndData = RowGenerator.buildRow(this, remarks, origin);
            if (!remarks.isEmpty()) {
                StringBuffer stringRemarks = new StringBuffer();
                for (CheckResultInterface remark : remarks) {
                    stringRemarks.append(remark.toString()).append(Const.CR);
                }
                throw new KettleStepException(stringRemarks.toString());
            }
            for (ValueMetaInterface valueMeta : rowMetaAndData.getRowMeta().getValueMetaList()) {
                valueMeta.setOrigin(origin);
            }
            row.mergeRowMeta(rowMetaAndData.getRowMeta());
        }
        catch (Exception e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.fieldType[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.fieldFormat[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.currency[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.decimal[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.group[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullif", (String)this.value[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.fieldLength[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.fieldPrecision[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"set_empty_string", (boolean)this.setEmptyString[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (String)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"never_ending", (String)(this.neverEnding ? "Y" : "N")));
        retval.append("    ").append(XMLHandler.addTagValue((String)"interval_in_ms", (String)this.intervalInMs));
        retval.append("    ").append(XMLHandler.addTagValue((String)"row_time_field", (String)this.rowTimeField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"last_time_field", (String)this.lastTimeField));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldType[i] = rep.getStepAttributeString(id_step, i, "field_type");
                this.fieldFormat[i] = rep.getStepAttributeString(id_step, i, "field_format");
                this.currency[i] = rep.getStepAttributeString(id_step, i, "field_currency");
                this.decimal[i] = rep.getStepAttributeString(id_step, i, "field_decimal");
                this.group[i] = rep.getStepAttributeString(id_step, i, "field_group");
                this.value[i] = rep.getStepAttributeString(id_step, i, "field_nullif");
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
                this.setEmptyString[i] = rep.getStepAttributeBoolean(id_step, i, "set_empty_string", false);
            }
            this.rowLimit = rep.getStepAttributeString(id_step, "limit");
            this.neverEnding = rep.getStepAttributeBoolean(id_step, "never_ending");
            this.intervalInMs = rep.getStepAttributeString(id_step, "interval_in_ms");
            this.rowTimeField = rep.getStepAttributeString(id_step, "row_time_field");
            this.lastTimeField = rep.getStepAttributeString(id_step, "last_time_field");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", this.fieldType[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", this.fieldFormat[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", this.currency[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", this.decimal[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", this.group[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_nullif", this.value[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", this.fieldLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", this.fieldPrecision[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "set_empty_string", this.setEmptyString[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "never_ending", this.neverEnding);
            rep.saveStepAttribute(id_transformation, id_step, "interval_in_ms", this.intervalInMs);
            rep.saveStepAttribute(id_transformation, id_step, "row_time_field", this.rowTimeField);
            rep.saveStepAttribute(id_transformation, id_step, "last_time_field", this.lastTimeField);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RowGeneratorMeta.CheckResult.NoInputStreamsError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RowGeneratorMeta.CheckResult.NoInputStreamOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String strLimit = transMeta.environmentSubstitute(this.rowLimit);
            if (Const.toLong((String)strLimit, (long)-1L) <= 0L) {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"RowGeneratorMeta.CheckResult.WarnNoRows", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RowGeneratorMeta.CheckResult.WillReturnRows", (String[])new String[]{strLimit}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RowGeneratorMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RowGeneratorMeta.CheckResult.NoInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new RowGenerator(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new RowGeneratorData();
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        return new StepIOMeta(false, true, false, false, false, false);
    }

    public boolean isNeverEnding() {
        return this.neverEnding;
    }

    public void setNeverEnding(boolean neverEnding) {
        this.neverEnding = neverEnding;
    }

    public String getIntervalInMs() {
        return this.intervalInMs;
    }

    public void setIntervalInMs(String intervalInMs) {
        this.intervalInMs = intervalInMs;
    }

    public String getRowTimeField() {
        return this.rowTimeField;
    }

    public void setRowTimeField(String rowTimeField) {
        this.rowTimeField = rowTimeField;
    }

    public String getLastTimeField() {
        return this.lastTimeField;
    }

    public void setLastTimeField(String lastTimeField) {
        this.lastTimeField = lastTimeField;
    }

    public boolean[] getSetEmptyString() {
        return this.setEmptyString;
    }

    public void setSetEmptyString(boolean[] setEmptyString) {
        this.setEmptyString = setEmptyString;
    }

    public String[] getCurrency() {
        return this.currency;
    }

    public void setCurrency(String[] currency) {
        this.currency = currency;
    }

    public String[] getDecimal() {
        return this.decimal;
    }

    public void setDecimal(String[] decimal) {
        this.decimal = decimal;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public String[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String[] fieldType) {
        this.fieldType = fieldType;
    }

    public String[] getGroup() {
        return this.group;
    }

    public void setGroup(String[] group) {
        this.group = group;
    }

    public boolean[] isSetEmptyString() {
        return this.setEmptyString;
    }

    public void setEmptyString(boolean[] setEmptyString) {
        this.setEmptyString = setEmptyString;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }
}

