/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.core;

import com.microsoft.windowsazure.storage.StorageExtendedErrorInformation;
import com.microsoft.windowsazure.storage.core.DeserializationHelper;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class StorageErrorDeserializer {
    public static StorageExtendedErrorInformation getExtendedErrorInformation(Reader reader) throws XMLStreamException {
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromReader(reader);
        return StorageErrorDeserializer.parseResponse(xmlr);
    }

    public static StorageExtendedErrorInformation getExtendedErrorInformation(InputStream stream) throws XMLStreamException {
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromStream(stream);
        return StorageErrorDeserializer.parseResponse(xmlr);
    }

    private static StorageExtendedErrorInformation parseResponse(XMLStreamReader xmlr) throws XMLStreamException {
        StorageExtendedErrorInformation errorInfo = new StorageExtendedErrorInformation();
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "Error");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) continue;
            if (eventType == 2) break;
            String name = xmlr.getName().getLocalPart().toString();
            if (eventType != 1) continue;
            if (name.equals("Code")) {
                errorInfo.setErrorCode(DeserializationHelper.readElementFromXMLReader(xmlr, "Code"));
                continue;
            }
            if (name.equals("Message")) {
                errorInfo.setErrorMessage(DeserializationHelper.readElementFromXMLReader(xmlr, "Message"));
                continue;
            }
            if (name.equals("ExceptionDetails")) {
                errorInfo.getAdditionalDetails().putAll(StorageErrorDeserializer.parseErrorException(xmlr));
                xmlr.require(2, null, "ExceptionDetails");
                continue;
            }
            String tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, name);
            errorInfo.getAdditionalDetails().put(name, new String[]{tempParseString});
            xmlr.require(2, null, null);
        }
        return errorInfo;
    }

    private static HashMap<String, String[]> parseErrorException(XMLStreamReader xmlr) throws XMLStreamException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "ExceptionDetails");
        HashMap<String, String[]> additionalDetails = new HashMap<String, String[]>();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("ExceptionMessage")) {
                String errorExceptionMessage = DeserializationHelper.readElementFromXMLReader(xmlr, "ExceptionMessage");
                additionalDetails.put("ExceptionMessage", new String[]{errorExceptionMessage});
                continue;
            }
            if (eventType == 1 && name.equals("StackTrace")) {
                String errorExceptionStack = DeserializationHelper.readElementFromXMLReader(xmlr, "StackTrace");
                additionalDetails.put("StackTrace", new String[]{errorExceptionStack});
                continue;
            }
            if (eventType != 2) continue;
            break;
        }
        xmlr.require(2, null, "ExceptionDetails");
        return additionalDetails;
    }
}

