/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.pentaho.capabilities.api.ICapability;
import org.pentaho.capabilities.impl.DefaultCapabilityManager;
import org.pentaho.osgi.api.IKarafFeatureWatcher;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.servicecoordination.api.IServiceBarrier;
import org.pentaho.platform.servicecoordination.api.IServiceBarrierManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafFeatureWatcherImpl
implements IKarafFeatureWatcher {
    private BundleContext bundleContext;
    private long timeout;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String KARAF_TIMEOUT_PROPERTY = "karafWaitForBoot";

    public KarafFeatureWatcherImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.timeout = PentahoSystem.getApplicationContext().getProperty(KARAF_TIMEOUT_PROPERTY) == null ? 120000L : Long.valueOf(PentahoSystem.getApplicationContext().getProperty(KARAF_TIMEOUT_PROPERTY));
    }

    public void waitForFeatures() throws IKarafFeatureWatcher.FeatureWatcherException {
        long entryTime = System.currentTimeMillis();
        ServiceTracker serviceTracker = new ServiceTracker(this.bundleContext, FeaturesService.class.getName(), null);
        serviceTracker.open();
        try {
            serviceTracker.waitForService(this.timeout);
        }
        catch (InterruptedException e) {
            this.logger.debug("FeaturesService " + FeaturesService.class.getName() + " ServiceTracker Interrupted");
        }
        ServiceReference serviceReference = this.bundleContext.getServiceReference(FeaturesService.class);
        if (serviceReference != null) {
            FeaturesService featuresService = (FeaturesService)this.bundleContext.getService(serviceReference);
            ServiceReference serviceReference1 = this.bundleContext.getServiceReference(ConfigurationAdmin.class);
            ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(serviceReference1);
            try {
                String[] fs;
                ArrayList<String> requiredFeatures = new ArrayList<String>();
                Configuration configuration = configurationAdmin.getConfiguration("org.pentaho.features");
                if (configuration != null && configuration.getProperties() != null) {
                    DefaultCapabilityManager manager;
                    String extraFeatures = (String)configuration.getProperties().get("runtimeFeatures");
                    if (extraFeatures != null) {
                        fs = extraFeatures.split(",");
                        requiredFeatures.addAll(Arrays.asList(fs));
                    }
                    if ((manager = DefaultCapabilityManager.getInstance()) != null) {
                        for (String requiredFeature : requiredFeatures) {
                            ICapability capability = manager.getCapabilityById(requiredFeature);
                            if (capability == null) continue;
                            capability.install();
                        }
                    }
                }
                configuration = configurationAdmin.getConfiguration("org.apache.karaf.features");
                String featuresBoot = (String)configuration.getProperties().get("featuresBoot");
                fs = featuresBoot.split(",");
                requiredFeatures.addAll(Arrays.asList(fs));
                while (true) {
                    ArrayList<String> uninstalledFeatures = new ArrayList<String>();
                    for (String requiredFeature : requiredFeatures) {
                        Feature feature = featuresService.getFeature(requiredFeature = requiredFeature.trim());
                        if (feature == null || featuresService.isInstalled(feature)) continue;
                        uninstalledFeatures.add(requiredFeature);
                    }
                    if (uninstalledFeatures.size() > 0) {
                        if (System.currentTimeMillis() - this.timeout > entryTime) {
                            IServiceBarrier serviceBarrier = IServiceBarrierManager.LOCATOR.getManager().getServiceBarrier("KarafFeatureWatcherBarrier");
                            if (serviceBarrier == null || serviceBarrier.isAvailable()) {
                                throw new IKarafFeatureWatcher.FeatureWatcherException("Timed out waiting for Karaf features to install: " + StringUtils.join(uninstalledFeatures, (String)","));
                            }
                            entryTime = System.currentTimeMillis();
                        }
                        this.logger.debug("KarafFeatureWatcher is waiting for the following features to install: " + StringUtils.join(uninstalledFeatures, (String)","));
                        Thread.sleep(100L);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new IKarafFeatureWatcher.FeatureWatcherException("Error accessing ConfigurationAdmin", (Throwable)e);
            }
            catch (Exception e) {
                throw new IKarafFeatureWatcher.FeatureWatcherException("Unknown error in KarafWatcher", (Throwable)e);
            }
        }
    }
}

