/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Iterator;
import java.util.List;
import javolution.context.ConcurrentContext;
import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.util.FastTable;
import org.jscience.mathematics.number.Float64;
import org.jscience.mathematics.vector.DenseMatrix;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Float64Vector;
import org.jscience.mathematics.vector.LUDecomposition;
import org.jscience.mathematics.vector.Matrix;
import org.jscience.mathematics.vector.Vector;

public final class Float64Matrix
extends Matrix<Float64> {
    int _n;
    boolean _transposed;
    final FastTable<Float64Vector> _rows = new FastTable();
    private static ObjectFactory<Float64Matrix> FACTORY = new ObjectFactory<Float64Matrix>(){

        @Override
        protected Float64Matrix create() {
            return new Float64Matrix();
        }

        @Override
        protected void cleanup(Float64Matrix matrix) {
            matrix._rows.reset();
        }
    };
    private static final long serialVersionUID = 1L;

    public static Float64Matrix valueOf(double[][] values) {
        int m = values.length;
        int n = values[0].length;
        Float64Matrix M = Float64Matrix.newInstance(n, false);
        for (int i = 0; i < m; ++i) {
            Float64Vector row = Float64Vector.valueOf(values[i]);
            if (row.getDimension() != n) {
                throw new DimensionException();
            }
            M._rows.add(row);
        }
        return M;
    }

    public static Float64Matrix valueOf(Float64Vector ... rows) {
        int n = rows[0].getDimension();
        Float64Matrix M = Float64Matrix.newInstance(n, false);
        for (Float64Vector rowi : rows) {
            if (rowi.getDimension() != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            M._rows.add(rowi);
        }
        return M;
    }

    public static Float64Matrix valueOf(List<Float64Vector> rows) {
        int n = rows.get(0).getDimension();
        Float64Matrix M = Float64Matrix.newInstance(n, false);
        Iterator<Float64Vector> iterator = rows.iterator();
        int m = rows.size();
        for (int i = 0; i < m; ++i) {
            Float64Vector rowi = iterator.next();
            if (rowi.getDimension() != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            M._rows.add(rowi);
        }
        return M;
    }

    public static Float64Matrix valueOf(Matrix<Float64> that) {
        if (that instanceof Float64Matrix) {
            return (Float64Matrix)that;
        }
        int n = that.getNumberOfColumns();
        int m = that.getNumberOfRows();
        Float64Matrix M = Float64Matrix.newInstance(n, false);
        for (int i = 0; i < m; ++i) {
            Float64Vector rowi = Float64Vector.valueOf(that.getRow(i));
            M._rows.add(rowi);
        }
        return M;
    }

    @Override
    public int getNumberOfRows() {
        return this._transposed ? this._n : this._rows.size();
    }

    @Override
    public int getNumberOfColumns() {
        return this._transposed ? this._rows.size() : this._n;
    }

    @Override
    public Float64 get(int i, int j) {
        return this._transposed ? this._rows.get(j).get(i) : this._rows.get(i).get(j);
    }

    public Float64Vector getRow(int i) {
        if (!this._transposed) {
            return this._rows.get(i);
        }
        int n = this._rows.size();
        int m = this._n;
        if (i < 0 || i >= m) {
            throw new DimensionException();
        }
        Float64Vector V = Float64Vector.newInstance(n);
        for (int j = 0; j < n; ++j) {
            V.set(j, this._rows.get(j).get(i).doubleValue());
        }
        return V;
    }

    public Float64Vector getColumn(int j) {
        if (this._transposed) {
            return this._rows.get(j);
        }
        int m = this._rows.size();
        if (j < 0 || j >= this._n) {
            throw new DimensionException();
        }
        Float64Vector V = Float64Vector.newInstance(m);
        for (int i = 0; i < m; ++i) {
            V.set(i, this._rows.get(i).get(j).doubleValue());
        }
        return V;
    }

    public Float64Vector getDiagonal() {
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        int dimension = MathLib.min(m, n);
        Float64Vector V = Float64Vector.newInstance(dimension);
        for (int i = 0; i < dimension; ++i) {
            V.set(i, this.get(i, i).doubleValue());
        }
        return V;
    }

    @Override
    public Float64Matrix opposite() {
        Float64Matrix M = Float64Matrix.newInstance(this._n, this._transposed);
        int p = this._rows.size();
        for (int i = 0; i < p; ++i) {
            M._rows.add(this._rows.get(i).opposite());
        }
        return M;
    }

    @Override
    public Float64Matrix plus(Matrix<Float64> that) {
        if (this.getNumberOfRows() != that.getNumberOfRows()) {
            throw new DimensionException();
        }
        Float64Matrix M = Float64Matrix.newInstance(this._n, this._transposed);
        int p = this._rows.size();
        for (int i = 0; i < p; ++i) {
            M._rows.add((Float64Vector)this._rows.get(i).plus((Vector)(this._transposed ? that.getColumn(i) : that.getRow(i))));
        }
        return M;
    }

    public Float64Matrix minus(Matrix<Float64> that) {
        return this.plus((Matrix)that.opposite());
    }

    @Override
    public Float64Matrix times(Float64 k) {
        Float64Matrix M = Float64Matrix.newInstance(this._n, this._transposed);
        int p = this._rows.size();
        for (int i = 0; i < p; ++i) {
            M._rows.add(this._rows.get(i).times(k));
        }
        return M;
    }

    @Override
    public Float64Vector times(Vector<Float64> v) {
        if (v.getDimension() != this.getNumberOfColumns()) {
            throw new DimensionException();
        }
        int m = this.getNumberOfRows();
        Float64Vector V = Float64Vector.newInstance(m);
        for (int i = 0; i < m; ++i) {
            V.set(i, ((Float64)this.getRow(i).times((Vector)v)).doubleValue());
        }
        return V;
    }

    @Override
    public Float64Matrix times(Matrix<Float64> that) {
        int n = this.getNumberOfColumns();
        int m = this.getNumberOfRows();
        int p = that.getNumberOfColumns();
        if (that.getNumberOfRows() != n) {
            throw new DimensionException();
        }
        Float64Matrix M = Float64Matrix.newInstance(m, true);
        M._rows.setSize(p);
        Multiply multiply = Multiply.valueOf(this, that, 0, p, M._rows);
        multiply.run();
        Multiply.recycle(multiply);
        return M;
    }

    private FastTable<Float64Vector> getRows() {
        if (!this._transposed) {
            return this._rows;
        }
        FastTable<Float64Vector> rows = FastTable.newInstance();
        for (int i = 0; i < this._n; ++i) {
            rows.add(this.getRow(i));
        }
        return rows;
    }

    public Float64Matrix inverse() {
        if (!this.isSquare()) {
            throw new DimensionException("Matrix not square");
        }
        return Float64Matrix.valueOf(LUDecomposition.valueOf(this).inverse());
    }

    @Override
    public Float64 determinant() {
        return LUDecomposition.valueOf(this).determinant();
    }

    public Float64Matrix transpose() {
        Float64Matrix M = Float64Matrix.newInstance(this._n, !this._transposed);
        M._rows.addAll(this._rows);
        return M;
    }

    @Override
    public Float64 cofactor(int i, int j) {
        if (this._transposed) {
            int k = i;
            i = j;
            j = k;
        }
        int m = this._rows.size();
        Float64Matrix M = Float64Matrix.newInstance(m - 1, this._transposed);
        for (int k1 = 0; k1 < m; ++k1) {
            if (k1 == i) continue;
            Float64Vector row = this._rows.get(k1);
            Float64Vector V = Float64Vector.newInstance(this._n - 1);
            M._rows.add(V);
            int k = 0;
            for (int k2 = 0; k2 < this._n; ++k2) {
                if (k2 == j) continue;
                V.set(k++, row.get(k2).doubleValue());
            }
        }
        return M.determinant();
    }

    public Float64Matrix adjoint() {
        Float64Matrix M = Float64Matrix.newInstance(this._n, this._transposed);
        int m = this._rows.size();
        for (int i = 0; i < m; ++i) {
            Float64Vector row = Float64Vector.newInstance(this._n);
            M._rows.add(row);
            for (int j = 0; j < this._n; ++j) {
                Float64 cofactor = this._transposed ? this.cofactor(j, i) : this.cofactor(i, j);
                row.set(j, (i + j) % 2 == 0 ? cofactor.doubleValue() : cofactor.opposite().doubleValue());
            }
        }
        return M.transpose();
    }

    public Float64Matrix tensor(Matrix<Float64> that) {
        return Float64Matrix.valueOf(DenseMatrix.valueOf(this).tensor(that));
    }

    public Float64Vector vectorization() {
        return Float64Vector.valueOf(DenseMatrix.valueOf(this).vectorization());
    }

    @Override
    public Float64Matrix copy() {
        Float64Matrix M = Float64Matrix.newInstance(this._n, this._transposed);
        for (Float64Vector row : this._rows) {
            M._rows.add(row.copy());
        }
        return M;
    }

    static Float64Matrix newInstance(int n, boolean transposed) {
        Float64Matrix M = FACTORY.object();
        M._n = n;
        M._transposed = transposed;
        return M;
    }

    private Float64Matrix() {
    }

    private static class Multiply
    implements Runnable {
        private static final ObjectFactory<Multiply> FACTORY = new ObjectFactory<Multiply>(){

            @Override
            protected Multiply create() {
                return new Multiply();
            }
        };
        private Float64Matrix _left;
        private Matrix<Float64> _right;
        private int _rightColumnStart;
        private int _rightColumnEnd;
        private FastTable<Float64Vector> _columnsResult;

        private Multiply() {
        }

        static Multiply valueOf(Float64Matrix left, Matrix<Float64> right, int rightColumnStart, int rightColumnEnd, FastTable<Float64Vector> columnsResult) {
            Multiply multiply = FACTORY.object();
            multiply._left = left;
            multiply._right = right;
            multiply._rightColumnStart = rightColumnStart;
            multiply._rightColumnEnd = rightColumnEnd;
            multiply._columnsResult = columnsResult;
            return multiply;
        }

        static void recycle(Multiply multiply) {
            multiply._left = null;
            multiply._right = null;
            multiply._columnsResult = null;
            FACTORY.recycle(multiply);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this._rightColumnEnd - this._rightColumnStart < 32) {
                FastTable rows = this._left.getRows();
                int m = rows.size();
                for (int j = this._rightColumnStart; j < this._rightColumnEnd; ++j) {
                    Vector<Float64> thatColj = this._right.getColumn(j);
                    Float64Vector column = Float64Vector.newInstance(m);
                    this._columnsResult.set(j, column);
                    for (int i = 0; i < m; ++i) {
                        column.set(i, ((Float64)((Float64Vector)rows.get(i)).times((Vector)thatColj)).doubleValue());
                    }
                }
            } else {
                int halfIndex = this._rightColumnStart + this._rightColumnEnd >> 1;
                Multiply firstHalf = Multiply.valueOf(this._left, this._right, this._rightColumnStart, halfIndex, this._columnsResult);
                Multiply secondHalf = Multiply.valueOf(this._left, this._right, halfIndex, this._rightColumnEnd, this._columnsResult);
                ConcurrentContext.enter();
                try {
                    ConcurrentContext.execute(firstHalf);
                    ConcurrentContext.execute(secondHalf);
                }
                finally {
                    ConcurrentContext.exit();
                }
                Multiply.recycle(firstHalf);
                Multiply.recycle(secondHalf);
            }
        }
    }
}

