/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.publish.agilebi;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.jfree.util.Log;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.refinery.publish.agilebi.ModelServerAction;
import org.pentaho.di.core.refinery.publish.model.DataSourceAclModel;
import org.pentaho.di.core.refinery.publish.util.JAXBUtils;

public class ModelServerPublish
extends ModelServerAction {
    public static final int PUBLISH_FAILED = 2;
    public static final int PUBLISH_SUCCESS = 3;
    public static final int PUBLISH_CATALOG_EXISTS = 8;
    private static final String REST_NAME_PARM = "?name=";
    private static final String MONDRIAN_POST_ANALYSIS_URL = "plugin/data-access/api/mondrian/postAnalysis";
    private static final String PLUGIN_DATA_ACCESS_API_CONNECTION_ADD = "plugin/data-access/api/connection/add";
    private static final String PLUGIN_DATA_ACCESS_API_CONNECTION_UPDATE = "plugin/data-access/api/connection/update";
    private static final String PLUGIN_DATA_ACCESS_API_CONNECTION_DELETE = "plugin/data-access/api/connection/deletebyname";
    private static final String DATA_ACCESS_API_CONNECTION_GET = "plugin/data-access/api/connection/getresponse";
    private static Logger logger = Logger.getLogger(ModelServerPublish.class.getName());
    private boolean forceOverwrite;
    private DataSourceAclModel aclModel;

    public boolean publishDataSource(boolean update, String connectionId) throws KettleDatabaseException {
        DatabaseConnection connection = new DatabaseConnection();
        DatabaseInterface intf = this.getDatabaseMeta().getDatabaseInterface();
        connection.setId(connectionId);
        connection.setName(this.databaseMeta.getName());
        connection.setPassword(this.getDatabaseMeta().environmentSubstitute(this.getDatabaseMeta().getPassword()));
        connection.setUsername(this.getDatabaseMeta().environmentSubstitute(this.getDatabaseMeta().getUsername()));
        connection.setDatabaseName(this.getDatabaseMeta().environmentSubstitute(intf.getDatabaseName()));
        connection.setDatabasePort(this.getDatabaseMeta().environmentSubstitute(String.valueOf(intf.getAttributes().getProperty("PORT_NUMBER"))));
        connection.setHostname(this.getDatabaseMeta().environmentSubstitute(this.getDatabaseMeta().getHostname()));
        connection.setForcingIdentifiersToLowerCase(!"N".equals(intf.getAttributes().getProperty("FORCE_IDENTIFIERS_TO_LOWERCASE")));
        connection.setQuoteAllFields(!"N".equals(intf.getAttributes().getProperty("QUOTE_ALL_FIELDS")));
        connection.setAccessType(DatabaseAccessType.NATIVE);
        connection.setExtraOptions(this.getDatabaseMeta().getExtraOptions());
        connection.setDatabaseType(this.getDatabaseType(intf));
        return this.updateConnection(connection, update);
    }

    protected boolean updateConnection(DatabaseConnection connection, boolean update) {
        try {
            String storeDomainUrl = update ? this.biServerConnection.getUrl() + PLUGIN_DATA_ACCESS_API_CONNECTION_UPDATE : this.biServerConnection.getUrl() + PLUGIN_DATA_ACCESS_API_CONNECTION_ADD;
            WebResource resource = this.getClient().resource(storeDomainUrl);
            WebResource.Builder builder = (WebResource.Builder)resource.type("application/json").entity((Object)connection);
            ClientResponse resp = this.httpPost(builder);
            if (resp == null || resp.getStatus() != 200) {
                return false;
            }
        }
        catch (Exception ex) {
            Log.error((Object)ex.getMessage());
            return false;
        }
        return true;
    }

    public boolean deleteConnection(String connectionName) {
        return this.deleteEntity(this.biServerConnection.getUrl() + PLUGIN_DATA_ACCESS_API_CONNECTION_DELETE + REST_NAME_PARM + connectionName);
    }

    public boolean deleteMetadataXmi(String domainId) {
        return this.deleteEntity(this.biServerConnection.getUrl() + "plugin/data-access/api/datasource/metadata/domain/" + domainId);
    }

    public boolean deleteDSWXmi(String domainId) {
        return this.deleteEntity(this.biServerConnection.getUrl() + "plugin/data-access/api/datasource/dsw/domain/" + domainId);
    }

    protected boolean deleteEntity(String url) {
        try {
            WebResource resource = this.getClient().resource(url);
            WebResource.Builder builder = resource.type("application/json");
            ClientResponse resp = this.httpDelete(builder);
            if (resp == null || resp.getStatus() != 200) {
                return false;
            }
        }
        catch (Exception ex) {
            Log.error((Object)ex.getMessage());
            return false;
        }
        return true;
    }

    public int publishMondrianSchema(InputStream mondrianFile, String catalogName, String datasourceInfo, boolean overwriteInRepos) throws Exception {
        String storeDomainUrl = this.biServerConnection.getUrl() + MONDRIAN_POST_ANALYSIS_URL;
        WebResource resource = this.getClient().resource(storeDomainUrl);
        String parms = "Datasource=" + datasourceInfo + ";retainInlineAnnotations=true";
        int response = 2;
        FormDataMultiPart part = new FormDataMultiPart();
        part.field("parameters", (Object)parms, MediaType.MULTIPART_FORM_DATA_TYPE).field("uploadAnalysis", (Object)mondrianFile, MediaType.MULTIPART_FORM_DATA_TYPE).field("catalogName", (Object)catalogName, MediaType.MULTIPART_FORM_DATA_TYPE).field("overwrite", (Object)(overwriteInRepos ? "true" : "false"), MediaType.MULTIPART_FORM_DATA_TYPE).field("xmlaEnabledFlag", (Object)"true", MediaType.MULTIPART_FORM_DATA_TYPE);
        this.addAclToRequest(part);
        part.getField("uploadAnalysis").setContentDisposition((ContentDisposition)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"uploadAnalysis").fileName(catalogName)).build());
        try {
            WebResource.Builder builder = this.resourceBuilder(resource, part);
            ClientResponse resp = this.httpPost(builder);
            String entity = null;
            if (resp != null && resp.getStatus() == 200) {
                entity = (String)resp.getEntity(String.class);
                response = entity.equals(String.valueOf(8)) ? 8 : Integer.parseInt(entity);
            } else {
                Log.info((Object)resp);
            }
        }
        catch (Exception ex) {
            Log.error((Object)ex.getMessage());
        }
        return response;
    }

    WebResource.Builder resourceBuilder(WebResource resource, FormDataMultiPart part) {
        return (WebResource.Builder)resource.type(MediaType.MULTIPART_FORM_DATA_TYPE).entity((Object)part);
    }

    public int publishMetaDataFile(InputStream metadataFile, String domainId) throws Exception {
        String storeDomainUrl = this.biServerConnection.getUrl() + "plugin/data-access/api/metadata/import";
        WebResource resource = this.getClient().resource(storeDomainUrl);
        int response = 2;
        FormDataMultiPart part = new FormDataMultiPart();
        part.field("domainId", (Object)domainId, MediaType.MULTIPART_FORM_DATA_TYPE).field("metadataFile", (Object)metadataFile, MediaType.MULTIPART_FORM_DATA_TYPE);
        if (this.isForceOverwrite()) {
            part.field("overwrite", (Object)(this.isForceOverwrite() + ""), MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        this.addAclToRequest(part);
        part.getField("metadataFile").setContentDisposition((ContentDisposition)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"metadataFile").fileName(domainId)).build());
        try {
            WebResource.Builder builder = this.resourceBuilder(resource, part);
            ClientResponse resp = this.httpPut(builder);
            if (resp != null && resp.getStatus() == 200 && ((String)resp.getEntity(String.class)).equals("3")) {
                response = 3;
            }
        }
        catch (Exception ex) {
            Log.error((Object)ex.getMessage());
        }
        return response;
    }

    public int publishDsw(InputStream metadataFile, String domainId) throws Exception {
        if (!StringUtils.endsWith((String)domainId, (String)".xmi")) {
            throw new IllegalArgumentException("Domain ID for DSW must end in .xmi");
        }
        String publishDswUrl = this.biServerConnection.getUrl() + "plugin/data-access/api/datasource/dsw/import";
        WebResource resource = this.getClient().resource(publishDswUrl);
        FormDataMultiPart part = new FormDataMultiPart();
        part.field("domainId", (Object)domainId, MediaType.MULTIPART_FORM_DATA_TYPE).field("metadataFile", (Object)metadataFile, MediaType.MULTIPART_FORM_DATA_TYPE);
        if (this.isForceOverwrite()) {
            part.field("overwrite", (Object)Boolean.toString(this.isForceOverwrite()), MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        this.addAclToRequest(part);
        part.field("checkConnection", (Object)Boolean.TRUE.toString(), MediaType.MULTIPART_FORM_DATA_TYPE);
        try {
            WebResource.Builder builder = this.resourceBuilder(resource, part);
            ClientResponse resp = this.httpPut(builder);
            if (resp != null) {
                switch (ClientResponse.Status.fromStatusCode((int)resp.getStatus())) {
                    case OK: 
                    case CREATED: {
                        return 3;
                    }
                }
                return 2;
            }
        }
        catch (Exception ex) {
            Log.error((Object)ex.getMessage());
        }
        return 2;
    }

    private void addAclToRequest(FormDataMultiPart part) {
        String xml;
        if (this.aclModel != null && (xml = this.aclModel.toXml()) != null) {
            part.field("acl", (Object)this.aclModel.toXml(), MediaType.MULTIPART_FORM_DATA_TYPE);
        }
    }

    private void error(String message) {
        logger.severe(message);
    }

    private void success(String message) {
        logger.info(message);
    }

    public DatabaseConnection connectionNameExists(String connectionName) {
        if (StringUtils.isBlank((String)connectionName)) {
            return null;
        }
        try {
            String storeDomainUrl = this.biServerConnection.getUrl() + DATA_ACCESS_API_CONNECTION_GET + REST_NAME_PARM + connectionName;
            storeDomainUrl = URIUtil.encodeQuery((String)storeDomainUrl);
            WebResource resource = this.getClient().resource(storeDomainUrl);
            WebResource.Builder builder = (WebResource.Builder)resource.type("application/json").type("application/xml");
            ClientResponse response = this.httpGet(builder);
            if (response != null && response.getStatus() == 200) {
                String payload = (String)response.getEntity(String.class);
                DatabaseConnection connection = JAXBUtils.unmarshalFromJson(payload, DatabaseConnection.class);
                return connection;
            }
        }
        catch (Exception ex) {
            Log.error((Object)ex.getMessage());
        }
        return null;
    }

    public boolean isForceOverwrite() {
        return this.forceOverwrite;
    }

    public void setForceOverwrite(boolean forceOverwrite) {
        this.forceOverwrite = forceOverwrite;
    }

    public DataSourceAclModel getAclModel() {
        return this.aclModel;
    }

    public void setAclModel(DataSourceAclModel aclModel) {
        this.aclModel = aclModel;
    }
}

