/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.publish;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.refinery.publish.agilebi.BiServerConnection;
import org.pentaho.di.core.refinery.publish.agilebi.ModelServerPublish;
import org.pentaho.di.core.refinery.publish.model.DataSourceAclModel;
import org.pentaho.di.core.refinery.publish.model.DataSourcePublishModel;
import org.pentaho.di.core.refinery.publish.util.PublishRestUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.build.JobEntryBuildModel;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.job.entries.common.ConnectionValidator;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@JobEntry(id="DATASOURCE_PUBLISH", i18nPackageName="org.pentaho.di.job.entries.publish", image="publish.svg", name="JobEntryDatasourcePublish.JobName", description="JobEntryDatasourcePublish.JobDescription", documentationUrl="0N0/060/0B0/020/0D0", categoryDescription="JobCategory.Category.Modeling")
public class JobEntryDatasourcePublish
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryDatasourcePublish.class;
    private static final String METADATA_EXTENSION = ".xmi";
    private static final String ENCODING = "UTF-8";
    private DataSourcePublishModel dataSourcePublishModel;

    public DataSourcePublishModel getDataSourcePublishModel() {
        return this.dataSourcePublishModel;
    }

    public void setDataSourcePublishModel(DataSourcePublishModel dataSourcePublishModel) {
        this.dataSourcePublishModel = dataSourcePublishModel;
    }

    public Result execute(Result result, int i) throws KettleException {
        boolean metaPublished = false;
        boolean dsPublished = false;
        DatabaseMeta databaseMeta = null;
        ModelServerPublish modelServerPublish = null;
        String dswFlag = null;
        String modelName = null;
        try {
            BiServerConnection biServerModel = this.dataSourcePublishModel.getBiServerConnection();
            biServerModel.setName(this.environmentSubstitute(biServerModel.getName()));
            biServerModel.setUserId(this.environmentSubstitute(biServerModel.getUserId()));
            biServerModel.setPassword(this.environmentSubstitute(biServerModel.getPassword()));
            String url = this.environmentSubstitute(biServerModel.getUrl());
            if (url != null && url.endsWith("//")) {
                url = url.substring(0, url.length() - 1);
            }
            biServerModel.setUrl(url);
            ConnectionValidator validator = this.getConnectionValidator(biServerModel);
            validator.validateConnectionInRuntime();
            BiServerConnection connection = new BiServerConnection();
            connection.setName(biServerModel.getName());
            connection.setUrl(biServerModel.getUrl());
            connection.setPassword(biServerModel.getPassword());
            connection.setUserId(biServerModel.getUserId());
            this.log.logBasic(this.getMsg("JobEntryDatasourcePublish.Publish.BAServer", biServerModel.getUrl()));
            modelServerPublish = this.getModelServerPublish();
            modelServerPublish.setBiServerConnection(connection);
            boolean forceOverride = this.dataSourcePublishModel.isOverride();
            DataSourceAclModel datasourceAcl = new DataSourceAclModel();
            String accessType = Const.isEmpty((String)this.dataSourcePublishModel.getAccessType()) ? "everyone" : this.environmentSubstitute(this.dataSourcePublishModel.getAccessType()).toLowerCase();
            String userOrRole = this.environmentSubstitute(this.dataSourcePublishModel.getUserOrRole());
            if ("role".equals(accessType)) {
                if (StringUtils.isBlank((String)userOrRole)) {
                    throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Error.MissingRoleMsg", new String[0]));
                }
                datasourceAcl.addRole(userOrRole);
            } else if ("user".equals(accessType)) {
                if (StringUtils.isBlank((String)userOrRole)) {
                    throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Error.MissingUserMsg", new String[0]));
                }
                datasourceAcl.addUser(userOrRole);
            } else if (!"everyone".equals(accessType)) {
                throw new KettleException("Access Type '" + accessType + "' not recognized");
            }
            modelServerPublish.setAclModel(datasourceAcl);
            modelName = this.getModelName();
            this.log.logBasic(this.getMsg("JobEntryDatasourcePublish.Publish.Model", modelName));
            databaseMeta = this.discoverDatabaseMeta(this.getParentJob().getJobMeta());
            if (databaseMeta != null) {
                if (DatabaseAccessType.values()[databaseMeta.getAccessType()] == DatabaseAccessType.JNDI) {
                    throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Error.JNDIDatasource", databaseMeta.getName()));
                }
                DatabaseConnection dbConnection = modelServerPublish.connectionNameExists(databaseMeta.getName());
                if (dbConnection != null && !this.dataSourcePublishModel.isOverride()) {
                    throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Error.DBConnectionExists", new String[0]));
                }
            } else {
                throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Error.UnableToFindDBConnection", new String[0]));
            }
            this.publishDatabaseMeta(modelServerPublish, databaseMeta, forceOverride);
            dsPublished = true;
            dswFlag = this.getParentJob().getVariable("JobEntryBuildModel.XMI.DSW." + modelName);
            this.log.logBasic(this.getMsg("JobEntryDatasourcePublish.Publish.ReadVariable", "JobEntryBuildModel.XMI.DSW." + modelName, dswFlag));
            if (dswFlag != null && dswFlag.equalsIgnoreCase("true")) {
                this.publishDswXmi(modelName, modelServerPublish, forceOverride);
            } else {
                this.publishMetadataXmi(modelName, modelServerPublish, forceOverride);
            }
            metaPublished = true;
            this.publishMondrianSchema(modelName, modelServerPublish, forceOverride);
            result.setResult(true);
        }
        catch (KettleException e) {
            this.logBasic(this.getMsg("JobEntryDatasourcePublish.Rollback", new String[0]));
            if (dsPublished && databaseMeta != null) {
                this.deleteDatabaseMeta(modelServerPublish, databaseMeta);
            }
            if (metaPublished && modelName != null) {
                this.deleteXMI(modelServerPublish, modelName, dswFlag);
            }
            this.logError(e.getMessage(), e);
            result.setResult(false);
            result.setNrErrors(1L);
        }
        return result;
    }

    protected String checkDswId(String modelName) {
        if (!modelName.endsWith(METADATA_EXTENSION)) {
            if (StringUtils.endsWithIgnoreCase((String)modelName, (String)METADATA_EXTENSION)) {
                modelName = StringUtils.removeEndIgnoreCase((String)modelName, (String)METADATA_EXTENSION);
            }
            modelName = modelName + METADATA_EXTENSION;
        }
        return modelName;
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(super.getXML());
        DataSourcePublishModel model = this.getDataSourcePublishModel();
        if (model != null) {
            xml.append("      ").append(XMLHandler.addTagValue((String)"logical_model", (String)model.getModelName()));
            xml.append("      ").append(XMLHandler.addTagValue((String)"override", (boolean)model.isOverride()));
            xml.append("      ").append(XMLHandler.addTagValue((String)"acl_access_type", (String)model.getAccessType()));
            xml.append("      ").append(XMLHandler.addTagValue((String)"acl_user_or_role", (String)model.getUserOrRole()));
            BiServerConnection biServerConnection = model.getBiServerConnection();
            if (biServerConnection != null) {
                xml.append("      ").append(XMLHandler.addTagValue((String)"ba_server_name", (String)Const.nullToEmpty((String)biServerConnection.getName())));
                String password = Encr.encryptPasswordIfNotUsingVariables((String)biServerConnection.getPassword());
                xml.append("      ").append(XMLHandler.addTagValue((String)"ba_server_password", (String)Const.nullToEmpty((String)password)));
                xml.append("      ").append(XMLHandler.addTagValue((String)"ba_server_url", (String)Const.nullToEmpty((String)biServerConnection.getUrl())));
                xml.append("      ").append(XMLHandler.addTagValue((String)"ba_server_user_id", (String)Const.nullToEmpty((String)biServerConnection.getUserId())));
            }
        }
        return xml.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        super.loadXML(entrynode, databases, slaveServers);
        DataSourcePublishModel model = new DataSourcePublishModel();
        BiServerConnection biServerModel = new BiServerConnection();
        biServerModel.setName(Const.nullToEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"ba_server_name")));
        biServerModel.setUrl(Const.nullToEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"ba_server_url")));
        biServerModel.setUserId(Const.nullToEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"ba_server_user_id")));
        String password = Encr.decryptPasswordOptionallyEncrypted((String)Const.nullToEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"ba_server_password")));
        biServerModel.setPassword(password);
        model.setBiServerConnection(biServerModel);
        model.setOverride(BooleanUtils.toBoolean((String)XMLHandler.getTagValue((Node)entrynode, (String)"override")));
        model.setAccessType(XMLHandler.getTagValue((Node)entrynode, (String)"acl_access_type"));
        model.setUserOrRole(XMLHandler.getTagValue((Node)entrynode, (String)"acl_user_or_role"));
        model.setModelName(XMLHandler.getTagValue((Node)entrynode, (String)"logical_model"));
        this.setDataSourcePublishModel(model);
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        super.loadRep(rep, metaStore, id_jobentry, databases, slaveServers);
        BiServerConnection biServerModel = new BiServerConnection();
        biServerModel.setName(rep.getJobEntryAttributeString(id_jobentry, "ba_server_name"));
        String password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "ba_server_password"));
        biServerModel.setPassword(Const.nullToEmpty((String)password));
        biServerModel.setUrl(Const.nullToEmpty((String)rep.getJobEntryAttributeString(id_jobentry, "ba_server_url")));
        biServerModel.setUserId(Const.nullToEmpty((String)rep.getJobEntryAttributeString(id_jobentry, "ba_server_user_id")));
        DataSourcePublishModel dsModel = new DataSourcePublishModel();
        dsModel.setModelName(rep.getJobEntryAttributeString(id_jobentry, "logical_model"));
        dsModel.setOverride(rep.getJobEntryAttributeBoolean(id_jobentry, "override"));
        dsModel.setAccessType(rep.getJobEntryAttributeString(id_jobentry, "acl_access_type"));
        dsModel.setUserOrRole(rep.getJobEntryAttributeString(id_jobentry, "acl_user_or_role"));
        dsModel.setBiServerConnection(biServerModel);
        this.setDataSourcePublishModel(dsModel);
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        if (this.dataSourcePublishModel != null) {
            BiServerConnection biServerConnection = this.dataSourcePublishModel.getBiServerConnection();
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ba_server_name", Const.nullToEmpty((String)biServerConnection.getName()));
            String password = Encr.encryptPasswordIfNotUsingVariables((String)biServerConnection.getPassword());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ba_server_password", Const.nullToEmpty((String)password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ba_server_url", Const.nullToEmpty((String)biServerConnection.getUrl()));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ba_server_user_id", Const.nullToEmpty((String)biServerConnection.getUserId()));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logical_model", this.dataSourcePublishModel.getModelName());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "override", this.dataSourcePublishModel.isOverride());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "acl_access_type", this.dataSourcePublishModel.getAccessType());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "acl_user_or_role", this.dataSourcePublishModel.getUserOrRole());
        }
    }

    protected ModelServerPublish getModelServerPublish() {
        return new ModelServerPublish();
    }

    protected PublishRestUtil getPublishRestUtil() {
        return new PublishRestUtil();
    }

    protected ConnectionValidator getConnectionValidator(BiServerConnection connection) {
        ConnectionValidator validator = new ConnectionValidator();
        validator.setConnection(connection);
        return validator;
    }

    protected void publishDatabaseMeta(ModelServerPublish modelServerPublish, DatabaseMeta databaseMeta, boolean forceOverride) throws KettleException {
        if (this.isKettleThinLocal(databaseMeta)) {
            throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Publish.LocalPentahoDataService", new String[0]));
        }
        modelServerPublish.setDatabaseMeta(databaseMeta);
        DatabaseConnection connection = modelServerPublish.connectionNameExists(databaseMeta.getName());
        try {
            boolean success = forceOverride ? (connection != null ? modelServerPublish.publishDataSource(true, connection.getId()) : modelServerPublish.publishDataSource(false, null)) : modelServerPublish.publishDataSource(false, connection != null ? connection.getId() : null);
            if (!success) {
                throw new Exception(this.getMsg("JobEntryDatasourcePublish.Publish.DBConnection.Failed", databaseMeta.getName()));
            }
        }
        catch (KettleException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        this.logBasic(this.getMsg("JobEntryDatasourcePublish.Publish.DBConnection.Success", databaseMeta.getName()));
    }

    protected void deleteDatabaseMeta(ModelServerPublish modelServerPublish, DatabaseMeta databaseMeta) throws KettleException {
        if (this.isKettleThinLocal(databaseMeta)) {
            throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Publish.LocalPentahoDataService", new String[0]));
        }
        DatabaseConnection connection = modelServerPublish.connectionNameExists(databaseMeta.getName());
        try {
            boolean success = true;
            if (connection != null) {
                success = modelServerPublish.deleteConnection(connection.getName());
            }
            if (!success) {
                throw new Exception(this.getMsg("JobEntryDatasourcePublish.Delete.DBConnection.Failed", databaseMeta.getName()));
            }
        }
        catch (KettleException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        this.logBasic(this.getMsg("JobEntryDatasourcePublish.Delete.DBConnection.Success", databaseMeta.getName()));
    }

    protected void deleteXMI(ModelServerPublish modelServerPublish, String modelName, String dswFlag) throws KettleException {
        try {
            boolean success = true;
            success = dswFlag != null && dswFlag.equalsIgnoreCase("true") ? modelServerPublish.deleteDSWXmi(this.checkDswId(modelName)) : modelServerPublish.deleteMetadataXmi(modelName);
            if (!success) {
                throw new Exception(this.getMsg("JobEntryDatasourcePublish.Delete.XMI.Failed", modelName));
            }
        }
        catch (KettleException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        this.logBasic(this.getMsg("JobEntryDatasourcePublish.Delete.XMI.Success", modelName));
    }

    private boolean isKettleThinLocal(DatabaseMeta databaseMeta) {
        return "KettleThin".equals(databaseMeta.getDatabaseInterface().getPluginId()) && "true".equals(databaseMeta.getExtraOptions().get("KettleThin.local"));
    }

    protected void publishMondrianSchema(String modelName, ModelServerPublish modelServerPublish, boolean forceOverride) throws KettleException {
        String mondrianSchema = this.getParentJob().getVariable("JobEntryBuildModel.Mondrian.Schema." + modelName);
        this.log.logDetailed(this.getMsg("JobEntryDatasourcePublish.Publish.ReadVariable", "JobEntryBuildModel.Mondrian.Schema." + modelName, mondrianSchema));
        String mondrianDatasource = this.getParentJob().getVariable("JobEntryBuildModel.Mondrian.Datasource." + modelName);
        this.log.logBasic(this.getMsg("JobEntryDatasourcePublish.Publish.ReadVariable", "JobEntryBuildModel.Mondrian.Datasource." + modelName, mondrianDatasource));
        if (mondrianSchema == null || mondrianDatasource == null) {
            return;
        }
        ByteArrayInputStream mondrianInputStream = null;
        try {
            mondrianInputStream = new ByteArrayInputStream(mondrianSchema.getBytes(ENCODING));
            modelServerPublish.setForceOverwrite(forceOverride);
            int status = modelServerPublish.publishMondrianSchema(mondrianInputStream, modelName, mondrianDatasource, forceOverride);
            if (status != 3) {
                throw new Exception(this.getMsg("JobEntryDatasourcePublish.Publish.Mondrian.Failed", modelName));
            }
        }
        catch (Exception e) {
            try {
                throw new KettleException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(mondrianInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)mondrianInputStream);
        this.logBasic(this.getMsg("JobEntryDatasourcePublish.Publish.Mondrian.Success", modelName));
    }

    protected void publishMetadataXmi(String modelName, ModelServerPublish modelServerPublish, boolean forceOverride) throws KettleException {
        String xmiString = this.getParentJob().getVariable("JobEntryBuildModel.XMI." + modelName);
        this.log.logDetailed(this.getMsg("JobEntryDatasourcePublish.Publish.ReadVariable", "JobEntryBuildModel.XMI." + modelName, xmiString));
        if (xmiString == null) {
            return;
        }
        ByteArrayInputStream xmiInputStream = null;
        try {
            xmiInputStream = new ByteArrayInputStream(xmiString.getBytes(ENCODING));
            modelServerPublish.setForceOverwrite(forceOverride);
            int status = modelServerPublish.publishMetaDataFile(xmiInputStream, modelName);
            if (status != 3) {
                throw new Exception(this.getMsg("JobEntryDatasourcePublish.Publish.Metadata.Failed", modelName));
            }
        }
        catch (Exception e) {
            try {
                throw new KettleException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(xmiInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)xmiInputStream);
        this.logBasic(this.getMsg("JobEntryDatasourcePublish.Publish.Metadata.Success", modelName));
    }

    protected void publishDswXmi(String modelName, ModelServerPublish modelServerPublish, boolean forceOverride) throws KettleException {
        String dswXmiVar = "JobEntryBuildModel.XMI." + modelName;
        String xmiString = this.getParentJob().getVariable(dswXmiVar);
        this.log.logDetailed(this.getMsg("JobEntryDatasourcePublish.Publish.ReadVariable", dswXmiVar, xmiString));
        if (xmiString == null) {
            return;
        }
        InputStream xmiInputStream = null;
        try {
            xmiInputStream = IOUtils.toInputStream((String)xmiString, (String)ENCODING);
            modelServerPublish.setForceOverwrite(forceOverride);
            int status = modelServerPublish.publishDsw(xmiInputStream, this.checkDswId(modelName));
            if (status != 3) {
                throw new Exception(this.getMsg("JobEntryDatasourcePublish.Publish.Dsw.Failed", modelName));
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)xmiInputStream);
        }
        this.logBasic(this.getMsg("JobEntryDatasourcePublish.Publish.Dsw.Success", modelName));
    }

    private String getModelName() throws KettleException {
        String modelName = this.dataSourcePublishModel.getModelName();
        if (StringUtils.isBlank((String)modelName) && (modelName = this.discoverModelName(this.getParentJob().getJobMeta())) == null) {
            throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Error.UnableToDiscoverModel", new String[0]));
        }
        if (StringUtils.isBlank((String)modelName)) {
            throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Error.UnableToFindModelName", new String[0]));
        }
        return this.environmentSubstitute(modelName);
    }

    public DatabaseMeta discoverDatabaseMeta(JobMeta jobMeta) throws KettleException {
        JobEntryBuildModel jobEntryBuildModel = this.findPrecedingBuildModelJobEntry(jobMeta, this);
        if (jobEntryBuildModel == null) {
            return null;
        }
        JobEntryBuildModel cloneJei = (JobEntryBuildModel)jobEntryBuildModel.clone();
        cloneJei.copyVariablesFrom((VariableSpace)this);
        cloneJei.setRepository(this.rep);
        if (this.rep != null) {
            cloneJei.setMetaStore(this.rep.getMetaStore());
        }
        cloneJei.setParentJob(this.getParentJob());
        return cloneJei.getConnectionInfo().getDatabaseMeta();
    }

    public String discoverModelName(JobMeta jobMeta) {
        JobEntryBuildModel jobEntryBuildModel = this.findPrecedingBuildModelJobEntry(jobMeta, this);
        if (jobEntryBuildModel == null) {
            return null;
        }
        return jobEntryBuildModel.getModelName();
    }

    public JobEntryBuildModel findPrecedingBuildModelJobEntry(JobMeta jobMeta, JobEntryInterface jobEntry) {
        JobEntryInterface previous = this.getPreviousJobEntry(jobMeta, jobEntry);
        if (previous == null) {
            return null;
        }
        if (JobEntryBuildModel.class.isAssignableFrom(previous.getClass())) {
            return (JobEntryBuildModel)previous;
        }
        return this.findPrecedingBuildModelJobEntry(jobMeta, previous);
    }

    protected JobEntryInterface getPreviousJobEntry(JobMeta jobMeta, JobEntryInterface jobEntry) {
        for (JobHopMeta hop : jobMeta.getJobhops()) {
            JobEntryInterface toEntry;
            if (!hop.isEnabled() || !(toEntry = hop.getToEntry().getEntry()).equals(jobEntry)) continue;
            return hop.getFromEntry().getEntry();
        }
        return null;
    }

    public boolean evaluates() {
        return true;
    }

    private String getMsg(String key, String ... parameters) {
        return BaseMessages.getString(PKG, (String)key, (String[])parameters);
    }

    public final class Fields {
        public static final String LOGICAL_MODEL = "logical_model";
        public static final String OVERRIDE = "override";
        public static final String BASERVER_URL = "ba_server_url";
        public static final String BASERVER_NAME = "ba_server_name";
        public static final String BASERVER_USERID = "ba_server_user_id";
        public static final String BASERVER_PASSWORD = "ba_server_password";
        public static final String ACL_ACCESS_TYPE = "acl_access_type";
        public static final String ACL_USER_OR_ROLE = "acl_user_or_role";
    }
}

