/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.annotation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroupXmlReader;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroupXmlWriter;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationManager;
import org.pentaho.agilebi.modeler.models.annotations.data.ColumnMapping;
import org.pentaho.agilebi.modeler.models.annotations.data.DataProvider;
import org.pentaho.agilebi.modeler.models.annotations.util.KeyValueClosure;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaChangeListenerInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationData;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationStep;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="FieldMetadataAnnotation", image="ModelAnnotation.svg", i18nPackageName="org.pentaho.di.trans.steps.annotation", name="ModelAnnotation.TransName", description="ModelAnnotation.TransDescription", documentationUrl="0N0/060/0B0/020/0B0", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Flow")
public class ModelAnnotationMeta
extends BaseStepMeta
implements StepMetaInterface,
StepMetaChangeListenerInterface {
    private static Class<?> PKG = ModelAnnotationMeta.class;
    private boolean sharedDimension;
    private ModelAnnotationGroup modelAnnotations;
    private String modelAnnotationCategory;
    private String targetOutputStep;

    public ModelAnnotationGroup getModelAnnotations() {
        return this.modelAnnotations;
    }

    public void setModelAnnotations(ModelAnnotationGroup modelAnnotations) {
        this.modelAnnotations = modelAnnotations;
    }

    public String getModelAnnotationCategory() {
        return this.modelAnnotationCategory;
    }

    public void setModelAnnotationCategory(String modelAnnotationCategory) {
        this.modelAnnotationCategory = modelAnnotationCategory;
    }

    public String getTargetOutputStep() {
        return this.targetOutputStep;
    }

    public void setTargetOutputStep(String targetOutputStep) {
        this.targetOutputStep = targetOutputStep;
    }

    public void setSharedDimension(boolean sharedDimension) {
        this.sharedDimension = sharedDimension;
    }

    public boolean isSharedDimension() {
        return this.sharedDimension;
    }

    public void setDefault() {
        this.modelAnnotations = new ModelAnnotationGroup();
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new ModelAnnotationStep(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new ModelAnnotationData();
    }

    public String getXML() {
        return this.getModelAnnotationsXml();
    }

    protected String getModelAnnotationsXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("    ").append(XMLHandler.addTagValue((String)"category", (String)this.getModelAnnotationCategory()));
        xml.append("    ").append(XMLHandler.addTagValue((String)"targetOutputStep", (String)this.getTargetOutputStep()));
        ModelAnnotationGroupXmlWriter xmlWriter = new ModelAnnotationGroupXmlWriter(this.getModelAnnotations());
        xml.append(xmlWriter.getXML());
        return xml.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
        if (StringUtils.isNotBlank((String)this.getModelAnnotationCategory())) {
            this.readDataFromMetaStore(metaStore);
        }
    }

    private void readData(Node step) throws KettleXMLException {
        try {
            ModelAnnotationGroup modelAnnotationGroup = this.readModelAnnotationGroup(step);
            this.setModelAnnotations(modelAnnotationGroup);
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"ModelAnnotationMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    protected ModelAnnotationGroup readModelAnnotationGroup(Node step) throws KettleXMLException {
        this.setModelAnnotationCategory(XMLHandler.getTagValue((Node)step, (String)"category"));
        this.setTargetOutputStep(XMLHandler.getTagValue((Node)step, (String)"targetOutputStep"));
        ModelAnnotationGroupXmlReader mar = new ModelAnnotationGroupXmlReader();
        ModelAnnotationGroup modelAnnotationGroup = mar.readModelAnnotationGroup(step);
        this.sharedDimension = modelAnnotationGroup.isSharedDimension();
        return modelAnnotationGroup;
    }

    public void saveRep(final Repository rep, IMetaStore metaStore, final ObjectId id_transformation, final ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "CATEGORY_NAME", this.getModelAnnotationCategory());
            rep.saveStepAttribute(id_transformation, id_step, "TARGET_OUTPUT_STEP", this.getTargetOutputStep());
            if (this.getModelAnnotations() != null) {
                for (int i = 0; i < this.getModelAnnotations().size(); ++i) {
                    ModelAnnotation modelAnnotation = (ModelAnnotation)this.getModelAnnotations().get(i);
                    if (StringUtils.isBlank((String)modelAnnotation.getName())) {
                        modelAnnotation.setName(UUID.randomUUID().toString());
                    }
                    rep.saveStepAttribute(id_transformation, id_step, i, "ANNOTATION_NAME", modelAnnotation.getName());
                    rep.saveStepAttribute(id_transformation, id_step, i, "ANNOTATION_FIELD_NAME", modelAnnotation.getAnnotation().getField());
                    if (modelAnnotation.getType() == null) continue;
                    rep.saveStepAttribute(id_transformation, id_step, i, "ANNOTATION_TYPE", modelAnnotation.getType().toString());
                    final int INDEX = i;
                    modelAnnotation.iterateProperties(new KeyValueClosure(){

                        public void execute(String key, Serializable serializable) {
                            try {
                                if (serializable != null && StringUtils.isNotBlank((String)serializable.toString())) {
                                    rep.saveStepAttribute(id_transformation, id_step, INDEX, "PROPERTY_VALUE_" + key, serializable.toString());
                                }
                            }
                            catch (KettleException e) {
                                ModelAnnotationMeta.this.logError(e.getMessage());
                            }
                        }
                    });
                }
                rep.saveStepAttribute(id_transformation, id_step, "SHARED_DIMENSION", this.getModelAnnotations().isSharedDimension());
                rep.saveStepAttribute(id_transformation, id_step, "DESCRIPTION", this.getModelAnnotations().getDescription());
                List dataProviders = this.getModelAnnotations().getDataProviders();
                if (dataProviders != null && !dataProviders.isEmpty()) {
                    for (int dIdx = 0; dIdx < dataProviders.size(); ++dIdx) {
                        DataProvider dataProvider = (DataProvider)dataProviders.get(dIdx);
                        rep.saveStepAttribute(id_transformation, id_step, dIdx, "DP_NAME", dataProvider.getName());
                        rep.saveStepAttribute(id_transformation, id_step, dIdx, "DP_SCHEMA_NAME", dataProvider.getSchemaName());
                        rep.saveStepAttribute(id_transformation, id_step, dIdx, "DP_TABLE_NAME", dataProvider.getTableName());
                        rep.saveStepAttribute(id_transformation, id_step, dIdx, "DP_DATABASE_META_NAME_REF", dataProvider.getDatabaseMetaNameRef());
                        List columnMappings = dataProvider.getColumnMappings();
                        if (columnMappings == null || columnMappings.isEmpty()) continue;
                        rep.saveStepAttribute(id_transformation, id_step, "CM_COUNT_" + dIdx, (long)columnMappings.size());
                        for (int cIdx = 0; cIdx < columnMappings.size(); ++cIdx) {
                            ColumnMapping columnMapping = (ColumnMapping)columnMappings.get(cIdx);
                            rep.saveStepAttribute(id_transformation, id_step, dIdx, "CM_NAME_" + cIdx, columnMapping.getName());
                            rep.saveStepAttribute(id_transformation, id_step, dIdx, "CM_COLUMN_NAME_" + cIdx, columnMapping.getColumnName());
                            if (columnMapping.getColumnDataType() == null) continue;
                            rep.saveStepAttribute(id_transformation, id_step, dIdx, "CM_DATA_TYPE_" + cIdx, columnMapping.getColumnDataType().name());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ModelAnnotationMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        ModelAnnotationGroup modelAnnotationGroup = new ModelAnnotationGroup();
        try {
            this.setModelAnnotationCategory(rep.getStepAttributeString(id_step, "CATEGORY_NAME"));
            this.setTargetOutputStep(rep.getStepAttributeString(id_step, "TARGET_OUTPUT_STEP"));
            int nrAnnotations = rep.countNrStepAttributes(id_step, "ANNOTATION_NAME");
            for (int i = 0; i < nrAnnotations; ++i) {
                String annotationName = rep.getStepAttributeString(id_step, i, "ANNOTATION_NAME");
                String annotationFieldName = rep.getStepAttributeString(id_step, i, "ANNOTATION_FIELD_NAME");
                String annotationType = rep.getStepAttributeString(id_step, i, "ANNOTATION_TYPE");
                ModelAnnotation modelAnnotation = ModelAnnotationGroupXmlReader.create((String)annotationType, (String)annotationFieldName);
                if (StringUtils.isNotBlank((String)annotationName)) {
                    modelAnnotation.setName(annotationName);
                }
                if (StringUtils.isNotBlank((String)annotationType)) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (String key : modelAnnotation.getAnnotation().getModelPropertyIds()) {
                        try {
                            String value = rep.getStepAttributeString(id_step, i, "PROPERTY_VALUE_" + key);
                            if (!StringUtils.isNotBlank((String)value)) continue;
                            map.put(key, value);
                        }
                        catch (KettleException value) {}
                    }
                    modelAnnotation.populateAnnotation(map);
                }
                modelAnnotationGroup.add((Object)modelAnnotation);
            }
            modelAnnotationGroup.setSharedDimension(BooleanUtils.toBoolean((String)rep.getStepAttributeString(id_step, "SHARED_DIMENSION")));
            this.sharedDimension = modelAnnotationGroup.isSharedDimension();
            modelAnnotationGroup.setDescription(rep.getStepAttributeString(id_step, "DESCRIPTION"));
            ArrayList<DataProvider> dataProviders = new ArrayList<DataProvider>();
            int nrDataProviders = rep.countNrStepAttributes(id_step, "DP_NAME");
            for (int i = 0; i < nrDataProviders; ++i) {
                DataProvider dataProvider = new DataProvider();
                dataProvider.setName(rep.getStepAttributeString(id_step, i, "DP_NAME"));
                dataProvider.setSchemaName(rep.getStepAttributeString(id_step, i, "DP_SCHEMA_NAME"));
                dataProvider.setTableName(rep.getStepAttributeString(id_step, i, "DP_TABLE_NAME"));
                dataProvider.setDatabaseMetaNameRef(rep.getStepAttributeString(id_step, i, "DP_DATABASE_META_NAME_REF"));
                ArrayList<ColumnMapping> columnMappings = new ArrayList<ColumnMapping>();
                long nrColumnMappings = rep.getStepAttributeString(id_step, "CM_COUNT_" + i) != null ? Long.valueOf(rep.getStepAttributeString(id_step, "CM_COUNT_" + i)) : 0L;
                int j = 0;
                while ((long)j < nrColumnMappings) {
                    ColumnMapping columnMapping = new ColumnMapping();
                    columnMapping.setName(rep.getStepAttributeString(id_step, i, "CM_NAME_" + j));
                    columnMapping.setColumnName(rep.getStepAttributeString(id_step, i, "CM_COLUMN_NAME_" + j));
                    String dataType = rep.getStepAttributeString(id_step, i, "CM_DATA_TYPE_" + j);
                    if (StringUtils.isNotBlank((String)dataType)) {
                        columnMapping.setColumnDataType(DataType.valueOf((String)dataType));
                    }
                    columnMappings.add(columnMapping);
                    ++j;
                }
                dataProvider.setColumnMappings(columnMappings);
                dataProviders.add(dataProvider);
            }
            modelAnnotationGroup.setDataProviders(dataProviders);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ModelAnnotationMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
        this.setModelAnnotations(modelAnnotationGroup);
        if (StringUtils.isNotBlank((String)this.getModelAnnotationCategory())) {
            this.readDataFromMetaStore(metaStore);
        }
    }

    public void readDataFromMetaStore(IMetaStore metaStore) {
        try {
            if (metaStore == null) {
                return;
            }
            ModelAnnotationManager manager = this.getModelAnnotationManager(this.getModelAnnotations());
            if (manager.containsGroup(this.getModelAnnotationCategory(), metaStore)) {
                this.setModelAnnotations(manager.readGroup(this.getModelAnnotationCategory(), metaStore));
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage());
        }
    }

    public void saveToMetaStore(IMetaStore metaStore) throws Exception {
        this.saveToMetaStore(metaStore, this.getModelAnnotations());
    }

    public void saveToMetaStore(IMetaStore metaStore, ModelAnnotationGroup modelAnnotations) throws Exception {
        if (metaStore == null) {
            return;
        }
        ModelAnnotationManager manager = this.getModelAnnotationManager(modelAnnotations);
        if (modelAnnotations != null && StringUtils.isBlank((String)modelAnnotations.getName())) {
            modelAnnotations.setName(this.getName());
        }
        this.checkValidName(modelAnnotations.getName());
        manager.createGroup(modelAnnotations, metaStore);
    }

    public void checkValidName(String name) throws KettleException {
        char[] fileSystemReservedChars = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|', '\t', '\r', '\n'};
        if (StringUtils.isBlank((String)name)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)(this.isSharedDimension() ? "ModelAnnotation.SharedDimensionMissingName.Message" : "ModelAnnotation.ModelAnnotationGroupMissingName.Message"), (String[])new String[0]));
        }
        if (StringUtils.indexOfAny((String)name, (char[])fileSystemReservedChars) >= 0 || StringUtils.startsWith((String)name, (String)".")) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (char ch : fileSystemReservedChars) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" ");
                }
                if (Character.isWhitespace(ch)) {
                    sb.append(StringEscapeUtils.escapeJava((String)Character.toString(ch)));
                    continue;
                }
                sb.append(ch);
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)(this.isSharedDimension() ? "ModelAnnotation.MetaStoreInvalidName.SharedDimension.Message" : "ModelAnnotation.MetaStoreInvalidName.Message"), (String[])new String[]{sb.toString()}));
        }
    }

    protected ModelAnnotationManager getModelAnnotationManager(ModelAnnotationGroup modelAnnotationGroup) {
        if (modelAnnotationGroup.isSharedDimension()) {
            return new ModelAnnotationManager(true);
        }
        return new ModelAnnotationManager();
    }

    public void onStepChange(TransMeta transMeta, StepMeta oldMeta, StepMeta newMeta) {
        String target = this.getTargetOutputStep();
        if (!StringUtils.isBlank((String)target) && target.equals(oldMeta.getName())) {
            this.setTargetOutputStep(newMeta.getName());
        }
    }
}

