/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.annotation;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.models.annotations.CreateMeasure;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationData;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationMeta;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class ModelAnnotationStep
extends BaseStep
implements StepInterface {
    private static final Class<?> PKG = ModelAnnotationMeta.class;

    public ModelAnnotationStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] row = this.getRow();
        if (this.first) {
            this.first = false;
            ModelAnnotationMeta modelAnnotationMeta = (ModelAnnotationMeta)smi;
            ModelAnnotationData modelAnnotationData = (ModelAnnotationData)sdi;
            if (modelAnnotationMeta.isSharedDimension() && !this.isOutputStepFound(modelAnnotationMeta.getTargetOutputStep())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"ModelAnnotation.Runtime.MissingDataProvider", (String[])new String[0]));
            }
            modelAnnotationData.annotations = this.processAnnotations(modelAnnotationMeta);
        }
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        this.putRow(this.getInputRowMeta(), row);
        return true;
    }

    private ModelAnnotationGroup processAnnotations(ModelAnnotationMeta modelAnnotationMeta) throws KettleException {
        ModelAnnotationGroup currentGroup;
        if (this.isGroupLinked(modelAnnotationMeta)) {
            String groupName = this.environmentSubstitute(modelAnnotationMeta.getModelAnnotationCategory());
            currentGroup = this.fetchAnnotations(groupName, modelAnnotationMeta);
        } else {
            currentGroup = modelAnnotationMeta.getModelAnnotations();
        }
        this.validateMeasuresNumeric(currentGroup);
        if (this.getTrans().getParentJob() != null) {
            ModelAnnotationGroup allAnnotations = this.getExistingAnnotations();
            if (!currentGroup.isSharedDimension()) {
                allAnnotations.addAll((Collection)currentGroup);
            }
            this.getTrans().getParentJob().getExtensionDataMap().put("KEY_MODEL_ANNOTATIONS", allAnnotations);
        }
        return currentGroup;
    }

    private boolean isGroupLinked(ModelAnnotationMeta meta) {
        return !StringUtils.isBlank((String)this.environmentSubstitute(meta.getModelAnnotationCategory()));
    }

    protected ModelAnnotationGroup fetchAnnotations(String groupName, ModelAnnotationMeta modelAnnotationMeta) throws KettleException {
        if (StringUtils.isBlank((String)groupName)) {
            throw new IllegalArgumentException("no group");
        }
        if (this.getMetaStore() == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ModelAnnotation.Runtime.NoMetastore", (String[])new String[0]));
        }
        try {
            ModelAnnotationManager mgr = this.getModelAnnotationsManager(modelAnnotationMeta);
            ModelAnnotationGroup group = mgr.readGroup(groupName, this.metaStore);
            if (group == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"ModelAnnotation.Runtime.GroupNotFound", (String[])new String[]{groupName}));
            }
            return group;
        }
        catch (MetaStoreException e) {
            throw new KettleException((Throwable)e);
        }
    }

    protected ModelAnnotationManager getModelAnnotationsManager(ModelAnnotationMeta modelAnnotationMeta) {
        if (modelAnnotationMeta.isSharedDimension()) {
            return new ModelAnnotationManager(true);
        }
        return new ModelAnnotationManager();
    }

    private void validateMeasuresNumeric(ModelAnnotationGroup annotations) throws KettleException {
        if (this.getInputRowMeta() != null) {
            for (ModelAnnotation annotation : annotations) {
                if (annotation.getType() == null || !annotation.getType().equals((Object)ModelAnnotation.Type.CREATE_MEASURE)) continue;
                for (ValueMetaInterface valueMeta : this.getInputRowMeta().getValueMetaList()) {
                    CreateMeasure createMeasure;
                    if (valueMeta.isNumeric() || !valueMeta.getName().equals(annotation.getAnnotation().getField()) || (createMeasure = (CreateMeasure)annotation.getAnnotation()).getAggregateType().equals((Object)AggregationType.COUNT) || createMeasure.getAggregateType().equals((Object)AggregationType.COUNT_DISTINCT)) continue;
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ModelAnnotation.Runtime.NonNumericMeasure", (String[])new String[]{createMeasure.getAggregateType().name()}));
                }
            }
        }
    }

    private ModelAnnotationGroup getExistingAnnotations() {
        Object o;
        Object v0 = o = this.getTrans().getParentJob() == null ? null : this.getTrans().getParentJob().getExtensionDataMap().get("KEY_MODEL_ANNOTATIONS");
        if (o == null) {
            return new ModelAnnotationGroup();
        }
        return o;
    }

    private boolean isOutputStepFound(String outputStep) throws KettleException {
        if (!Const.isEmpty((String)outputStep)) {
            for (StepMetaDataCombi outCombi : this.getTrans().getSteps()) {
                if (!outCombi.stepname.equals(this.environmentSubstitute(outputStep))) continue;
                return true;
            }
        }
        return false;
    }
}

